package com.atlassian.confluence.extra.flyingpdf.util;

import java.util.HashMap;

public class ImageTranscoderCacheUtil {
    private final static ThreadLocal<HashMap<String, String>> threadLocal = new ThreadLocal<>();

    /**
     * Initializes <code>HashMap</code> cache for current thread.
     */
    public static void initializeCache(){
        threadLocal.set(new HashMap<>());
    }

    /**
     * Removes <code>HashMap</code> for current thread.
     */
    public static void purgeCache(){
        threadLocal.remove();
    }

   public static String getCacheImage(String uri) {
       HashMap<String, String> cache = threadLocal.get();
       if(cache != null){
           return cache.get(uri);
       }
       return null;
   }

   public static void setCacheImage(String uri, String imageName) {
       HashMap<String, String> cache = threadLocal.get();
       if(cache != null){
           cache.put(uri, imageName);
       }
   }
}
