package com.atlassian.confluence.extra.flyingpdf.impl;

import com.atlassian.confluence.extra.flyingpdf.analytic.ExportScope;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;

/**
 * Audit event about PDF export: page or space
 */
public class PdfExportEvent {

    private final ExportScope exportScope;

    private final long spaceId;

    private final String spaceKey;

    private final String spaceName;

    private final long pageId;

    private final String pageTitle;

    private final String pageType;

    public PdfExportEvent(AbstractPage page) {
        this.exportScope = ExportScope.PAGE;

        Space space = page.getSpace();

        this.spaceId = space.getId();
        this.spaceKey = space.getKey();
        this.spaceName = space.getName();

        this.pageId = page.getId();
        this.pageTitle = page.getTitle();
        this.pageType = page.getType();
    }

    public PdfExportEvent(Space space) {
        this.exportScope = ExportScope.SPACE;

        this.spaceId = space.getId();
        this.spaceKey = space.getKey();
        this.spaceName = space.getName();

        this.pageId = 0L;
        this.pageTitle = null;
        this.pageType = null;
    }

    public ExportScope getExportScope() {
        return exportScope;
    }

    public long getSpaceId() {
        return spaceId;
    }

    public String getSpaceKey() {
        return spaceKey;
    }

    public String getSpaceName() {
        return spaceName;
    }

    public long getPageId() {
        return pageId;
    }

    public String getPageTitle() {
        return pageTitle;
    }

    public String getPageType() {
        return pageType;
    }
}
