package com.atlassian.confluence.extra.flyingpdf.html;

import com.atlassian.confluence.extra.flyingpdf.util.UrlUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Accumulates Table Of Contents information and is used to Render TOC from Velocity template
 */
public class TocBuilder {

    private final String baseUrl;

    private final String spaceKey;

    private final List<TocEntry> entries = new ArrayList<TocEntry>();

    public TocBuilder() {
        // Sometimes we don't need these
        this(null, null);
    }

    public TocBuilder(String baseUrl, String spaceKey) {
        this.baseUrl = baseUrl;
        this.spaceKey = spaceKey;
    }

    public void addEntry(int level, String pageTitle) {
        entries.add(new TocEntry(level, pageTitle));
    }

    public void addEntry(int level, String pageTitle, int pageLocation) {
        entries.add(new TocEntry(level, pageTitle, pageLocation));
    }

    public List<TocEntry> getEntries() {
        return entries;
    }

    @SuppressWarnings("unused")
    public class TocEntry {

        /**
         * Page level in hierarchy will affect the padding
         */
        private final int level;

        /**
         * Page title to be displayed
         */
        private final String title;

        /**
         * Page location. If we work with single HTML file, these are substituted to PDF automatically by flyingsaucer.
         * Otherwise, we want to calculate them manually.
         */
        private final int pageLocation;

        TocEntry(int level, String title) {
            this(level, title, 0);
        }

        TocEntry(int level, String title, int pageLocation) {
            this.level = level;
            this.title = title;
            this.pageLocation = pageLocation;
        }

        public int getLevel() {
            return level;
        }

        public String getTitle() {
            return title;
        }

        /**
         * URL to the page. When {@link com.atlassian.confluence.extra.flyingpdf.util.PdfPostProcessor} is run after
         * PDF merge, they are
         * @return the full url
         */
        public String getFullUrl() {
            return baseUrl + "/display/" + spaceKey + "/" + UrlUtils.encodeTitle(title);
        }

        public int getPageLocation() {
            return pageLocation;
        }

    }
}
