package com.atlassian.confluence.extra.flyingpdf.config;

import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import org.apache.log4j.Logger;
import org.springframework.core.io.ByteArrayResource;

import java.io.IOException;

/**
 * Listen for fonts being installed or uninstalled on other cluster nodes and ensure the
 * configuration is mirrored on this node.
 */
public class CustomFontClusterEventListener implements EventListener {
    private static final Logger log = Logger.getLogger(CustomFontClusterEventListener.class);
    private static final Class[] HANDLED_CLASSES = new Class[]{ClusterEventWrapper.class};

    private FontDao fontDao;

    public void handleEvent(Event event) {
        if (event instanceof ClusterEventWrapper) {
            ClusterEventWrapper clusterEventWrapper = (ClusterEventWrapper) event;
            Event wrappedEvent = clusterEventWrapper.getEvent();
            if (wrappedEvent instanceof CustomFontInstalledEvent) {
                handleInstallEvent((CustomFontInstalledEvent) wrappedEvent);
            } else if (wrappedEvent instanceof CustomFontRemovedEvent) {
                handleRemoveEvent((CustomFontRemovedEvent) wrappedEvent);
            }
        }
    }

    private void handleRemoveEvent(CustomFontRemovedEvent event) {
        try {
            fontDao.removeFont(event.getFontName());
        } catch (IOException e) {
            log.error("Unable to remove custom PDF font: " + event.getFontName() + " - " + e.getMessage(), e);
        }
    }

    private void handleInstallEvent(CustomFontInstalledEvent event) {
        ByteArrayResource resource = new ByteArrayResource(event.getFontData());
        try {
            fontDao.saveFont(event.getFontName(), resource);
        } catch (IOException ex) {
            log.error("Unable to install custom PDF font: " + event.getFontName() + " - " + ex.getMessage(), ex);
        }
    }

    public Class[] getHandledEventClasses() {
        return HANDLED_CLASSES;
    }

    public void setPdfExportFontsDirectoryFontDao(FontDao pdfExportFontsDirectoryFontDao) {
        this.fontDao = pdfExportFontsDirectoryFontDao;
    }
}
