package com.atlassian.confluence.extra.flyingpdf.util;

import com.atlassian.annotations.Internal;
import com.lowagie.text.Element;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;

/**
 * Adds page numbers at the bottom of PDF pages
 */
@Internal
public class PageNumbersPageProcessor implements PdfPageProcessor {

    @Override
    public void processPage(PdfReader reader, PdfStamper stamper, int page) {
        // Pages can have different dimensions so calculate for each page
        float xPos = (reader.getPageSize(page).getRight() - reader.getPageSize(page).getLeft()) / 2;
        PdfContentByte pdfContentByte = stamper.getOverContent(page);
        ColumnText.showTextAligned(pdfContentByte, Element.ALIGN_CENTER,
                new Phrase(String.valueOf(page), FontFactory.getFont(FontFactory.HELVETICA, 8)), xPos, 35, 0);
    }
}
