package com.atlassian.confluence.extra.flyingpdf.util;

import com.atlassian.confluence.util.i18n.DocumentationBeanFactory;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.stereotype.Component;

/**
 * Helper class to encapsulate error messages generation.
 */
@Component
public class ErrorMessages {

    private final I18NBeanFactory i18NBeanFactory;
    private final DocumentationBeanFactory documentationBeanFactory;

    public ErrorMessages(
            @ComponentImport I18NBeanFactory i18NBeanFactory,
            @ComponentImport DocumentationBeanFactory documentationBeanFactory) {
        this.i18NBeanFactory = i18NBeanFactory;
        this.documentationBeanFactory = documentationBeanFactory;
    }

    public String pageTimeoutMessage(String pageTitle) {
        return i18NBeanFactory.getI18NBean().getText("com.atlassian.confluence.extra.flyingpdf.error.sandbox.convert.timeout",
                new String[]{pageTitle, documentationUrl()});
    }

    public String pageErrorMessage(String pageTitle) {
        return i18NBeanFactory.getI18NBean().getText("com.atlassian.confluence.extra.flyingpdf.error.sandbox.convert.error",
                new String[]{pageTitle, documentationUrl()});
    }

    public String joinTimeoutMessage() {
        return i18NBeanFactory.getI18NBean().getText("com.atlassian.confluence.extra.flyingpdf.error.sandbox.join.timeout",
                new String[]{documentationUrl()});
    }

    public String joinErrorMessage() {
        return i18NBeanFactory.getI18NBean().getText("com.atlassian.confluence.extra.flyingpdf.error.sandbox.join.error",
                new String[]{documentationUrl()});
    }

    public String tooManyConcurrentExports() {
        return i18NBeanFactory.getI18NBean().getText("com.atlassian.confluence.extra.flyingpdf.error.too.many.concurrent.exports",
                new String[]{documentationUrl()});
    }

    private String documentationUrl() {
        return documentationBeanFactory.getDocumentationBean().getLink("PDF+export+in+Confluence+Data+Center");
    }

}
