package com.atlassian.confluence.extra.flyingpdf.impl;

import com.atlassian.confluence.extra.flyingpdf.PdfExporterService;
import com.atlassian.confluence.extra.flyingpdf.html.DecorationPolicy;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

public class BetterExportSpaceAction extends AbstractSpaceAction implements ServletRequestAware {
    public static final String CONTENT_OPTION_CUSTOM_EXPORT = "visible";

    protected HttpServletRequest servletRequest;
    protected PdfExportLongRunningTaskFactory pdfExportLongRunningTaskFactory;
    protected PdfExporterService pdfExporterService;
    protected LongRunningTaskId taskId;
    protected LongRunningTaskManager longRunningTaskManager;
    protected String downloadPath;
    private List<String> contentToBeExported;
    private String contentOption;
    private boolean addPageNumbers;
    private ServletContext servletContext;
    private PermissionManager permissionManager;

    public String doExport() {
        List<String> contentToBeExported = StringUtils.equals(this.contentOption, CONTENT_OPTION_CUSTOM_EXPORT) ?
                getContentToBeExported() : null;

        PdfExportLongRunningTask task = pdfExportLongRunningTaskFactory.createNewLongRunningTask(
                contentToBeExported, getSpace(), getAuthenticatedUser(), servletRequest.getContextPath(), getDecorations());

        taskId = longRunningTaskManager.startLongRunningTask(getAuthenticatedUser(), task);
        return SUCCESS;
    }

    public String execute() {
        return doExport();
    }

    @Override
    public boolean isPermitted() {
        UtilTimerStack.push("BetterExportSpaceAction.isPermitted");
        boolean isPermitted = pdfExporterService.isPermitted(getRemoteUser(), getSpace());
        UtilTimerStack.pop("BetterExportSpaceAction.isPermitted");
        return isPermitted;
    }

    public boolean exportableContentExists() {
        UtilTimerStack.push("BetterExportSpaceAction.exportableContentExists");
        boolean containsStuff = pdfExporterService.exportableContentExists(getSpace());
        UtilTimerStack.pop("BetterExportSpaceAction.exportableContentExists");
        return containsStuff;
    }

    private DecorationPolicy getDecorations() {
        return addPageNumbers ? DecorationPolicy.pageNumbers() : DecorationPolicy.none();
    }

    public String getSpaceAdvancedUrl() {
        return "/spaces/viewspacesummary.action?key=" + getHelper().getSpaceKey();
    }

    public String getDownloadPath() {
        return downloadPath;
    }

    public List<String> getContentToBeExported() {
        return contentToBeExported;
    }

    public void setContentToBeExported(List<String> contentToBeExported) {
        this.contentToBeExported = contentToBeExported;
    }

    public void setContentOption(String contentOption) {
        this.contentOption = contentOption;
    }

    public void setAddPageNumbers(boolean addPageNumbers) {
        this.addPageNumbers = addPageNumbers;
    }

    public boolean isSpaceAdmin() {
        return permissionManager.hasPermission(getRemoteUser(), Permission.ADMINISTER, getSpace());
    }

    public ServletContext getServletContext() {
        if (servletContext != null)
            return servletContext;
        else
            return ServletActionContext.getServletContext();
    }

    @SuppressWarnings("unused") /* used in xwork.xml in doflyingpdf.action's success result */
    public LongRunningTaskId getTaskId() {
        return taskId;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setPdfExportLongRunningTaskFactory(PdfExportLongRunningTaskFactory pdfExportLongRunningTaskFactory) {
        this.pdfExportLongRunningTaskFactory = pdfExportLongRunningTaskFactory;
    }

    public void setServletRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public void setDiagnosticsPdfExporterService(DiagnosticPdfExporterService diagnosticsPdfExporterService) {
        this.pdfExporterService = diagnosticsPdfExporterService;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setLongRunningTaskManager(LongRunningTaskManager longRunningTaskManager) {
        this.longRunningTaskManager = longRunningTaskManager;
    }
}
