package com.atlassian.confluence.extra.flyingpdf.html;

import com.atlassian.confluence.extra.flyingpdf.PdfExportProgressMonitor;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.spaces.Space;
import org.w3c.dom.Document;

/**
 * Represents a class that will render a ContentTree worth of content from Confluence and return a List
 * of files where each file represents a page.
 */
public interface XhtmlBuilder {
    /**
     * Build the HTML representation of the supplied contentTree and include any additional decoration provided.
     *
     * @param contentTree   a ContentTree of content from Confluence
     * @param linkRendering details on how internal links should be rendered
     * @return an XHTML representation of the supplied content tree
     * @throws ImportExportException on any exceptions occurring during the building process.
     */
    Document buildHtml(ContentTree contentTree, Space space, LinkRenderingDetails linkRendering,
                       DecorationPolicy decoration) throws ImportExportException;

    /**
     * Build the HTML representation of the supplied contentTree and include any additional decoration provided.
     *
     * @param contentTree   a ContentTree of content from Confluence
     * @param monitor       the monitor that will be informed of the ongoing progress of the operation.
     * @param linkRendering details on how internal links should be rendered
     * @return an XHTML representation of the supplied content tree
     * @throws ImportExportException on any exceptions occurring during the building process.
     */
    Document buildHtml(ContentTree contentTree, Space space, LinkRenderingDetails linkRendering,
                       DecorationPolicy decoration, PdfExportProgressMonitor monitor)
            throws ImportExportException;

    /**
     * Build the HTML representation of the supplied blog post and include any additional decoration provided.
     *
     * @param blogPost      a BlogPost from Confluence
     * @return an XHTML representation of the supplied blog post
     * @throws ImportExportException on any exceptions occurring during the building process.
     */
    Document buildHtml(BlogPost blogPost) throws ImportExportException;

    Document generateTableOfContents(String baseUrl, Space space, TocBuilder tocBuilder) throws ImportExportException;
}
