package com.atlassian.confluence.extra.flyingpdf.html;

import com.atlassian.confluence.extra.flyingpdf.html.LinkFixer.InternalPageStrategy;
import com.atlassian.confluence.pages.Page;

import java.util.Collection;
import java.util.Collections;

/**
 * Information about how links in pages should be processed
 */
public class LinkRenderingDetails {

    /**
     * A collections of pages that are exported in this request. We need to know those, because we might want to process
     * them differently. E.g. change web links for this pages to PDF bookmarks
     */
    private final Collection<Page> internalPages;

    /**
     * How links to internal pages should be processed
     */
    private final InternalPageStrategy linkStrategy;

    /**
     * Default from historically first implementation (all HTML in memory)
     */
    public static LinkRenderingDetails anchors() {
        return new LinkRenderingDetails(Collections.emptyList(), InternalPageStrategy.ANCHOR);
    }

    public LinkRenderingDetails(Collection<Page> internalPages, InternalPageStrategy linkStrategy) {
        this.internalPages = internalPages;
        this.linkStrategy = linkStrategy;
    }

    public Collection<Page> getInternalPages() {
        return internalPages;
    }

    public InternalPageStrategy getLinkStrategy() {
        return linkStrategy;
    }
}
