package com.atlassian.confluence.extra.flyingpdf.html;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class BookmarksBuilder {
    public static class BookmarkEntry {
        private final String title;
        private final List<BookmarkEntry> childEntries;

        public BookmarkEntry(String title) {
            this.title = title;
            this.childEntries = new ArrayList<BookmarkEntry>();
        }

        public void addChildEntry(BookmarkEntry child) {
            childEntries.add(child);
        }

        public String getTitle() {
            return title;
        }

        public List<BookmarkEntry> getChildEntries() {
            return childEntries;
        }

        public boolean hasChildEntries() {
            return !childEntries.isEmpty();
        }
    }

    private final List<BookmarkEntry> entries = new ArrayList<BookmarkEntry>();

    private final Stack<BookmarkEntry> currentEntryStack = new Stack<BookmarkEntry>();

    /**
     * Begin a bookmarks entry - subsequent beginEntries will create bookmarks beneath this one until
     * {@link #endEntry()} is called.
     */
    public void beginEntry(String title) {
        BookmarkEntry currentEntry = new BookmarkEntry(title);
        if (currentEntryStack.isEmpty()) {
            // this is a top level entry so add to the list
            entries.add(currentEntry);
        } else {
            // this is not a top level entry so add as a child of the current entry
            currentEntryStack.peek().addChildEntry(currentEntry);
        }

        currentEntryStack.push(currentEntry);
    }

    /**
     * The should be an endEntry call for each {@link #beginEntry(String)} that is called.
     */
    public void endEntry() {
        if (currentEntryStack.isEmpty())
            throw new IllegalStateException("Too many endEntry calls made.");

        currentEntryStack.pop();
    }

    /**
     * @return the Bookmark entries that have been recorded.
     */
    public List<BookmarkEntry> getEntries() {
        return entries;
    }
}
