/**
 *
 */
package com.atlassian.confluence.extra.flyingpdf.config;

import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

import java.io.IOException;

/**
 *
 */
public interface FontManager {
    /**
     * Installs the specified font resource. If an existing custom font currently exists then it will be replaced.
     */
    void installFont(Resource fontResource) throws IOException;

    /**
     * @return the font installed for use in PDF generation. Null will be returned if no custom font is installed.
     */
    FileSystemResource getInstalledFont();

    /**
     * @return true if a custom font has been installed
     */
    boolean isCustomFontInstalled();

    /**
     * Removes custom font if one has been installed.
     */
    void removeInstalledFont() throws IOException;
}
