package com.atlassian.confluence.extra.flyingpdf.config;

import org.springframework.core.io.Resource;

import java.io.IOException;

public interface FontDao {
    /**
     * Save the supplied font resource, overwriting any existing font with the same name.
     *
     * @param fontName the name for the font.
     * @throws IOException if there is a problem saving the supplied font resource
     */
    void saveFont(String fontName, Resource fontResource) throws IOException;

    /**
     * Save the supplied font resource, with the overwrite parameter controlling whether any existing font resource with
     * the same name will be overwritten.
     * <p>
     * If overwrite is false and the fontResource already exists then this method will return immediately.
     *
     * @param fontName     the name for the font.
     * @param fontResource the fontResource to save
     * @param overwrite    if true then replace any existing font with that name.
     * @throws IOException if there is a problem saving the resource.
     */
    void saveFont(String fontName, Resource fontResource, boolean overwrite) throws IOException;

    /**
     * Retrieve the font resource with the supplied name.
     *
     * @param fontName the name of the font required.
     * @return the retrieved font resource. Null should never be returned.
     * @throws IOException if the supplied font cannot be found or cannot be read.
     */
    Resource getFont(String fontName) throws IOException;

    /**
     * Remove the named font resource.
     *
     * @throws IOException if the named font resource cannot be found or cannot be removed.
     */
    void removeFont(String fontName) throws IOException;
}
