package com.atlassian.confluence.extra.flyingpdf.config;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.themes.ThemeManager;

public class ConfigurePdfExportStyleSheetAction
        extends GlobalConfigurePdfExportStyleSheet implements SpaceAware {
    private Space space;
    private ThemeManager themeManager;

    public String getKey() {
        return getSpace().getKey();
    }


    public boolean isSpaceRequired() {
        return true;
    }


    public boolean isViewPermissionRequired() {
        return true;
    }

    @Override
    public boolean isPermitted() {
        return permissionManager.hasPermission(getRemoteUser(), Permission.ADMINISTER, getSpace());
    }

    public void setSpace(Space space) {
        this.space = space;
        this.context = new ConfluenceBandanaContext(space);

    }

    public Space getSpace() {
        return space;
    }

    public ThemeManager getThemeManager() {
        return themeManager;
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }
}
