package com.atlassian.confluence.extra.flyingpdf.config;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.xwork.FileUploadUtils;
import com.atlassian.xwork.FileUploadUtils.UploadedFile;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import org.apache.log4j.Logger;
import org.springframework.core.io.FileSystemResource;

import java.io.IOException;


public class ConfigurePDFLanguageSupportAction extends ConfluenceActionSupport {
    private static final Logger log = Logger.getLogger(ConfigurePDFLanguageSupportAction.class);
    private FontManager pdfExportFontManager;
    private boolean installFontSuccess = false;

    public String execute() throws Exception {
        UploadedFile uploadedFile = FileUploadUtils.getSingleUploadedFile();
        if (uploadedFile == null) {
            addActionError(getText("pdf.font.error.nofile"));
            return ERROR;
        }

        try {
            pdfExportFontManager.installFont(new FileSystemResource(uploadedFile.getFile()) {
                @Override
                public String getFilename() {
                    return uploadedFile.getFileName();
                }
            });
        } catch (Exception ex) {
            log.error("Unable to install language font.", ex);
            addActionError(ex.getMessage());
            return ERROR;
        }

        return SUCCESS;
    }

    @PermittedMethods({HttpMethod.GET, HttpMethod.POST})
    public String doRestoreDefault() {
        try {
            pdfExportFontManager.removeInstalledFont();
        } catch (IOException ex) {
            log.error("Unable to remove custom font.", ex);
            addActionError(ex.getMessage());
            return ERROR;
        }

        return SUCCESS;
    }

    @Override
    public boolean isPermitted() {
        return (permissionManager.hasPermission(getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM));
    }

    public String getInstalledFontName() {
        FileSystemResource fontResource = pdfExportFontManager.getInstalledFont();
        if (fontResource != null)
            return fontResource.getFilename();
        else
            return null;
    }

    public boolean isInstallFontSuccess() {
        return installFontSuccess;
    }

    public void setInstallFontSuccess(boolean installFontSuccess) {
        this.installFontSuccess = installFontSuccess;
    }

    public void setPdfExportFontManager(FontManager pdfExportFontManager) {
        this.pdfExportFontManager = pdfExportFontManager;
    }
}

