/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.margincollapse.MarginsCollapseHandler;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.property.FloatPropertyValue;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.property.VerticalAlignment;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AccessibleAttributesApplier;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.CollapsedTableBorders;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.FloatingHelper;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.TableBorders;
import com.itextpdf.layout.renderer.TableWidths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRenderer
extends AbstractRenderer {
    protected List<CellRenderer[]> rows = new ArrayList<CellRenderer[]>();
    protected Table.RowRange rowRange;
    protected TableRenderer headerRenderer;
    protected TableRenderer footerRenderer;
    protected boolean isOriginalNonSplitRenderer = true;
    private float[] columnWidths = null;
    private List<Float> heights = new ArrayList<Float>();
    private float[] countedColumnWidth = null;
    private float totalWidthForColumns;
    private float topBorderMaxWidth;
    TableBorders bordersHandler;

    private TableRenderer() {
    }

    public TableRenderer(Table modelElement, Table.RowRange rowRange) {
        super(modelElement);
        this.setRowRange(rowRange);
    }

    public TableRenderer(Table modelElement) {
        this(modelElement, new Table.RowRange(0, modelElement.getNumberOfRows() - 1));
    }

    @Override
    public void addChild(IRenderer renderer) {
        if (renderer instanceof CellRenderer) {
            Cell cell = (Cell)renderer.getModelElement();
            this.rows.get((int)(cell.getRow() - this.rowRange.getStartRow() + cell.getRowspan() - 1))[cell.getCol()] = (CellRenderer)renderer;
        } else {
            Logger logger = LoggerFactory.getLogger(TableRenderer.class);
            logger.error("Only CellRenderer could be added");
        }
    }

    @Override
    protected Rectangle applyBorderBox(Rectangle rect, Border[] borders, boolean reverse) {
        return rect;
    }

    @Override
    protected Rectangle applyPaddings(Rectangle rect, float[] paddings, boolean reverse) {
        return rect;
    }

    Table getTable() {
        return (Table)this.getModelElement();
    }

    private void initializeHeaderAndFooter(boolean isFirstOnThePage) {
        boolean headerShouldBeApplied;
        boolean footerShouldBeApplied;
        Table table = (Table)this.getModelElement();
        Border[] tableBorder = this.getBorders();
        Table footerElement = table.getFooter();
        boolean bl = footerShouldBeApplied = (!table.isComplete() || 0 == table.getLastRowBottomBorder().size() || !table.isSkipLastFooter()) && !Boolean.TRUE.equals(this.getOwnProperty(96));
        if (footerElement != null && footerShouldBeApplied) {
            this.footerRenderer = this.initFooterOrHeaderRenderer(true, tableBorder);
        }
        Table headerElement = table.getHeader();
        boolean isFirstHeader = this.rowRange.getStartRow() == 0 && this.isOriginalNonSplitRenderer;
        boolean bl2 = headerShouldBeApplied = !(!table.isComplete() && this.rows.isEmpty() || !isFirstOnThePage || table.isSkipFirstHeader() && isFirstHeader || Boolean.TRUE.equals(this.getOwnProperty(97)));
        if (headerElement != null && headerShouldBeApplied) {
            this.headerRenderer = this.initFooterOrHeaderRenderer(false, tableBorder);
        }
    }

    private boolean isOriginalRenderer() {
        return this.isOriginalNonSplitRenderer && !this.isFooterRenderer() && !this.isHeaderRenderer();
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        LayoutResult result;
        boolean isAndWasComplete;
        this.overrideHeightProperties();
        Float blockMinHeight = this.retrieveMinHeight();
        Float blockMaxHeight = this.retrieveMaxHeight();
        LayoutArea area = layoutContext.getArea();
        boolean wasParentsHeightClipped = layoutContext.isClippedHeight();
        boolean wasHeightClipped = false;
        Rectangle layoutBox = area.getBBox().clone();
        Table tableModel = (Table)this.getModelElement();
        if (!tableModel.isComplete()) {
            this.setProperty(43, 0);
        }
        if (this.rowRange.getStartRow() != 0) {
            this.setProperty(46, 0);
        }
        this.heights.clear();
        this.childRenderers.clear();
        HashMap<Integer, Integer> rowMoves = new HashMap<Integer, Integer>();
        int numberOfColumns = ((Table)this.getModelElement()).getNumberOfColumns();
        List<Border> lastFlushedRowBottomBorder = tableModel.getLastRowBottomBorder();
        boolean bl = isAndWasComplete = tableModel.isComplete() && 0 == lastFlushedRowBottomBorder.size();
        if (!this.isFooterRenderer() && !this.isHeaderRenderer() && this.isOriginalNonSplitRenderer) {
            this.bordersHandler = new CollapsedTableBorders(this.rows, numberOfColumns, this.getBorders(), !isAndWasComplete ? this.rowRange.getStartRow() : 0);
            this.bordersHandler.initializeBorders();
        }
        this.bordersHandler.setRowRange(this.rowRange.getStartRow(), this.rowRange.getFinishRow());
        this.initializeHeaderAndFooter(0 == this.rowRange.getStartRow() || area.isEmptyArea());
        this.bordersHandler.updateBordersOnNewPage(this.isOriginalNonSplitRenderer, this.isFooterRenderer() || this.isHeaderRenderer(), this, this.headerRenderer, this.footerRenderer);
        if (this.isOriginalNonSplitRenderer) {
            this.correctRowRange();
        }
        if (this.isOriginalRenderer()) {
            float[] margins = this.getMargins();
            this.calculateColumnWidths(layoutBox.getWidth() - margins[1] - margins[3]);
        }
        float tableWidth = this.getTableWidth();
        MarginsCollapseHandler marginsCollapseHandler = null;
        boolean marginsCollapsingEnabled = Boolean.TRUE.equals(this.getPropertyAsBoolean(89));
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler = new MarginsCollapseHandler(this, layoutContext.getMarginsCollapseInfo());
        }
        List<Rectangle> siblingFloatRendererAreas = layoutContext.getFloatRendererAreas();
        float clearHeightCorrection = FloatingHelper.calculateClearHeightCorrection(this, siblingFloatRendererAreas, layoutBox);
        FloatPropertyValue floatPropertyValue = (FloatPropertyValue)((Object)this.getProperty(99));
        if (FloatingHelper.isRendererFloating(this, floatPropertyValue)) {
            layoutBox.decreaseHeight(clearHeightCorrection);
            FloatingHelper.adjustFloatedTableLayoutBox(this, layoutBox, tableWidth, siblingFloatRendererAreas, floatPropertyValue);
        } else {
            clearHeightCorrection = FloatingHelper.adjustLayoutBoxAccordingToFloats(siblingFloatRendererAreas, layoutBox, Float.valueOf(tableWidth), clearHeightCorrection, marginsCollapseHandler);
        }
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler.startMarginsCollapse(layoutBox);
        }
        this.applyMargins(layoutBox, false);
        this.applyFixedXOrYPosition(true, layoutBox);
        if (null != blockMaxHeight && blockMaxHeight.floatValue() < layoutBox.getHeight() && !Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
            layoutBox.moveUp(layoutBox.getHeight() - blockMaxHeight.floatValue()).setHeight(blockMaxHeight.floatValue());
            wasHeightClipped = true;
        }
        if (layoutBox.getWidth() > tableWidth) {
            layoutBox.setWidth(tableWidth + this.bordersHandler.getRightBorderMaxWidth() / 2.0f + this.bordersHandler.getLeftBorderMaxWidth() / 2.0f);
        }
        this.occupiedArea = new LayoutArea(area.getPageNumber(), new Rectangle(layoutBox.getX(), layoutBox.getY() + layoutBox.getHeight(), tableWidth, 0.0f));
        if (this.footerRenderer != null) {
            this.prepareFooterOrHeaderRendererForLayout(this.footerRenderer, layoutBox.getWidth());
            if (0 != this.rows.size() || !isAndWasComplete) {
                this.bordersHandler.collapseTableWithFooter(this.footerRenderer.bordersHandler, false);
            } else if (null != this.headerRenderer) {
                this.headerRenderer.bordersHandler.collapseTableWithFooter(this.footerRenderer.bordersHandler, false);
            }
            result = this.footerRenderer.layout(new LayoutContext(new LayoutArea(area.getPageNumber(), layoutBox), wasHeightClipped || wasParentsHeightClipped));
            if (result.getStatus() != 1) {
                this.deleteOwnProperty(10);
                return new LayoutResult(3, null, null, this, result.getCauseOfNothing());
            }
            float footerHeight = result.getOccupiedArea().getBBox().getHeight();
            this.footerRenderer.move(0.0f, -(layoutBox.getHeight() - footerHeight));
            layoutBox.moveUp(footerHeight).decreaseHeight(footerHeight);
            if (!tableModel.isEmpty()) {
                float maxFooterTopBorderWidth = this.footerRenderer.bordersHandler.getMaxTopWidth();
                this.footerRenderer.occupiedArea.getBBox().decreaseHeight(maxFooterTopBorderWidth);
                layoutBox.moveDown(maxFooterTopBorderWidth).increaseHeight(maxFooterTopBorderWidth);
            }
            if (Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                this.footerRenderer.setProperty(26, true);
            }
        }
        if (this.headerRenderer != null) {
            this.prepareFooterOrHeaderRendererForLayout(this.headerRenderer, layoutBox.getWidth());
            if (0 != this.rows.size()) {
                this.bordersHandler.collapseTableWithHeader(this.headerRenderer.bordersHandler, !tableModel.isEmpty());
            } else if (null != this.footerRenderer) {
                this.footerRenderer.bordersHandler.collapseTableWithHeader(this.headerRenderer.bordersHandler, true);
            }
            this.topBorderMaxWidth = this.bordersHandler.getMaxTopWidth();
            result = this.headerRenderer.layout(new LayoutContext(new LayoutArea(area.getPageNumber(), layoutBox), wasHeightClipped || wasParentsHeightClipped));
            if (result.getStatus() != 1) {
                this.deleteOwnProperty(13);
                return new LayoutResult(3, null, null, this, result.getCauseOfNothing());
            }
            float headerHeight = result.getOccupiedArea().getBBox().getHeight();
            layoutBox.decreaseHeight(headerHeight);
            this.occupiedArea.getBBox().moveDown(headerHeight).increaseHeight(headerHeight);
            this.bordersHandler.fixHeaderOccupiedArea(this.occupiedArea.getBBox(), layoutBox);
        }
        this.topBorderMaxWidth = this.bordersHandler.getMaxTopWidth();
        this.bordersHandler.applyLeftAndRightTableBorder(layoutBox, false);
        this.bordersHandler.applyTopTableBorder(this.occupiedArea.getBBox(), layoutBox, tableModel.isEmpty() || 0 == this.rows.size(), isAndWasComplete, false);
        LayoutResult[] splits = new LayoutResult[numberOfColumns];
        int[] targetOverflowRowIndex = new int[numberOfColumns];
        ArrayList<Boolean> rowsHasCellWithSetHeight = new ArrayList<Boolean>();
        for (int row = 0; row < this.rows.size(); ++row) {
            int status;
            float widestRowBottomBorderWidth;
            int col;
            ArrayList<Rectangle> childFloatRendererAreas = new ArrayList<Rectangle>();
            if (row == 1 && Boolean.TRUE.equals(this.getProperty(26))) {
                if (Boolean.TRUE.equals(this.getOwnProperty(26))) {
                    this.deleteOwnProperty(26);
                } else {
                    this.setProperty(26, false);
                }
            }
            CellRenderer[] currentRow = this.rows.get(row);
            float rowHeight = 0.0f;
            boolean split = false;
            boolean hasContent = true;
            boolean cellWithBigRowspanAdded = false;
            ArrayList<CellRenderer> currChildRenderers = new ArrayList<CellRenderer>();
            ArrayDeque<CellRendererInfo> cellProcessingQueue = new ArrayDeque<CellRendererInfo>();
            for (col = 0; col < currentRow.length; ++col) {
                if (currentRow[col] == null) continue;
                cellProcessingQueue.addLast(new CellRendererInfo(currentRow[col], col, row));
            }
            boolean rowHasCellWithSetHeight = false;
            IRenderer firstCauseOfNothing = null;
            this.bordersHandler.setFinishRow(this.rowRange.getStartRow() + row);
            Border widestRowBottomBorder = this.bordersHandler.getWidestHorizontalBorder(this.rowRange.getStartRow() + row + 1);
            this.bordersHandler.setFinishRow(this.rowRange.getFinishRow());
            float f = widestRowBottomBorderWidth = null == widestRowBottomBorder ? 0.0f : widestRowBottomBorder.getWidth();
            while (cellProcessingQueue.size() > 0) {
                boolean currentCellHasBigRowspan;
                CellRendererInfo currentCellInfo = (CellRendererInfo)cellProcessingQueue.pop();
                col = currentCellInfo.column;
                CellRenderer cell = currentCellInfo.cellRenderer;
                int colspan = cell.getPropertyAsInteger(16);
                int rowspan = cell.getPropertyAsInteger(60);
                if (1 != rowspan) {
                    cellWithBigRowspanAdded = true;
                }
                targetOverflowRowIndex[col] = currentCellInfo.finishRowInd;
                boolean bl2 = currentCellHasBigRowspan = row != currentCellInfo.finishRowInd;
                if (cell.hasOwnOrModelProperty(27)) {
                    rowHasCellWithSetHeight = true;
                }
                float cellWidth = 0.0f;
                float colOffset = 0.0f;
                for (int k = col; k < col + colspan; ++k) {
                    cellWidth += this.countedColumnWidth[k];
                }
                for (int l = 0; l < col; ++l) {
                    colOffset += this.countedColumnWidth[l];
                }
                float rowspanOffset = 0.0f;
                for (int m = row - 1; m > currentCellInfo.finishRowInd - rowspan && m >= 0; --m) {
                    rowspanOffset += this.heights.get(m).floatValue();
                }
                float cellLayoutBoxHeight = rowspanOffset + (!currentCellHasBigRowspan || hasContent ? layoutBox.getHeight() : 0.0f);
                float cellLayoutBoxBottom = layoutBox.getY() + (!currentCellHasBigRowspan || hasContent ? 0.0f : layoutBox.getHeight());
                Rectangle cellLayoutBox = new Rectangle(layoutBox.getX() + colOffset, cellLayoutBoxBottom, cellWidth, cellLayoutBoxHeight);
                LayoutArea cellArea = new LayoutArea(layoutContext.getArea().getPageNumber(), cellLayoutBox);
                VerticalAlignment verticalAlignment = (VerticalAlignment)((Object)cell.getProperty(75));
                cell.setProperty(75, null);
                UnitValue cellWidthProperty = (UnitValue)cell.getProperty(77);
                if (cellWidthProperty != null && cellWidthProperty.isPercentValue()) {
                    cell.setProperty(77, UnitValue.createPointValue(cellWidth));
                }
                float[] cellIndents = this.bordersHandler.getCellBorderIndents(currentCellInfo.finishRowInd, col, rowspan, colspan);
                this.bordersHandler.applyCellIndents(cellArea.getBBox(), cellIndents[0], cellIndents[1], cellIndents[2] + widestRowBottomBorderWidth, cellIndents[3], false);
                cellWidth = cellArea.getBBox().getWidth();
                LayoutResult cellResult = cell.setParent(this).layout(new LayoutContext(cellArea, null, childFloatRendererAreas, wasHeightClipped || wasParentsHeightClipped));
                cell.setProperty(75, (Object)verticalAlignment);
                if (cellResult.getStatus() != 3) {
                    cell.getOccupiedArea().getBBox().setWidth(cellWidth);
                } else if (null == firstCauseOfNothing) {
                    firstCauseOfNothing = cellResult.getCauseOfNothing();
                }
                if (currentCellHasBigRowspan) {
                    if (cellResult.getStatus() != 1) {
                        splits[col] = cellResult;
                        if (cellResult.getStatus() != 3) {
                            splits[col].getOverflowRenderer().setProperty(75, (Object)VerticalAlignment.TOP);
                        }
                    }
                    if (cellResult.getStatus() == 2) {
                        currentRow[col] = (CellRenderer)cellResult.getSplitRenderer();
                    } else {
                        this.rows.get((int)currentCellInfo.finishRowInd)[col] = null;
                        currentRow[col] = cell;
                        rowMoves.put(col, currentCellInfo.finishRowInd);
                    }
                } else if (cellResult.getStatus() != 1) {
                    if (!split) {
                        int addCol;
                        boolean skipLastFooter;
                        boolean bl3 = skipLastFooter = null != this.footerRenderer && tableModel.isSkipLastFooter() && tableModel.isComplete();
                        if (skipLastFooter) {
                            LayoutArea potentialArea = new LayoutArea(area.getPageNumber(), layoutBox.clone());
                            Border widestRowTopBorder = this.bordersHandler.getWidestHorizontalBorder(this.rowRange.getStartRow() + row);
                            if (null != widestRowTopBorder) {
                                potentialArea.getBBox().moveDown(widestRowTopBorder.getWidth() / 2.0f).increaseHeight(widestRowTopBorder.getWidth() / 2.0f);
                            }
                            float footerHeight = this.footerRenderer.getOccupiedArea().getBBox().getHeight();
                            potentialArea.getBBox().moveDown(footerHeight).increaseHeight(footerHeight);
                            TableRenderer overflowRenderer = this.createOverflowRenderer(new Table.RowRange(this.rowRange.getStartRow() + row, this.rowRange.getFinishRow()));
                            overflowRenderer.rows = this.rows.subList(row, this.rows.size());
                            overflowRenderer.setProperty(97, true);
                            overflowRenderer.setProperty(96, true);
                            overflowRenderer.setProperty(46, 0);
                            overflowRenderer.setProperty(43, 0);
                            overflowRenderer.setProperty(44, 0);
                            overflowRenderer.setProperty(45, 0);
                            if (null != this.headerRenderer) {
                                overflowRenderer.setProperty(13, Border.NO_BORDER);
                            }
                            overflowRenderer.rowRange = new Table.RowRange(0, this.rows.size() - row - 1);
                            overflowRenderer.bordersHandler = this.bordersHandler;
                            this.bordersHandler.skipFooter(overflowRenderer.getBorders());
                            if (null != this.headerRenderer) {
                                this.bordersHandler.skipHeader(overflowRenderer.getBorders());
                            }
                            int savedStartRow = overflowRenderer.bordersHandler.startRow;
                            overflowRenderer.bordersHandler.setStartRow(row);
                            this.prepareFooterOrHeaderRendererForLayout(overflowRenderer, layoutBox.getWidth());
                            LayoutResult res = overflowRenderer.layout(new LayoutContext(potentialArea, wasHeightClipped || wasParentsHeightClipped));
                            this.bordersHandler.setStartRow(savedStartRow);
                            if (1 == res.getStatus()) {
                                this.footerRenderer = null;
                                layoutBox.increaseHeight(footerHeight).moveDown(footerHeight);
                                this.deleteOwnProperty(10);
                                this.bordersHandler.setFinishRow(this.rowRange.getStartRow() + row);
                                widestRowBottomBorder = this.bordersHandler.getWidestHorizontalBorder(this.rowRange.getStartRow() + row + 1);
                                this.bordersHandler.setFinishRow(this.rowRange.getFinishRow());
                                widestRowBottomBorderWidth = null == widestRowBottomBorder ? 0.0f : widestRowBottomBorder.getWidth();
                                cellProcessingQueue.clear();
                                currChildRenderers.clear();
                                for (addCol = 0; addCol < currentRow.length; ++addCol) {
                                    if (currentRow[addCol] == null) continue;
                                    cellProcessingQueue.addLast(new CellRendererInfo(currentRow[addCol], addCol, row));
                                }
                                continue;
                            }
                            int reusedRows = 0;
                            if (null != res.getSplitRenderer()) {
                                reusedRows = ((TableRenderer)res.getSplitRenderer()).rows.size();
                            }
                            for (int i = 0; i < numberOfColumns; ++i) {
                                if (null == this.rows.get(row + reusedRows)[i]) continue;
                                this.rows.get((int)(row + reusedRows))[i] = (CellRenderer)this.rows.get(row + reusedRows)[i].getModelElement().createRendererSubTree();
                            }
                            if (null != this.headerRenderer) {
                                this.bordersHandler.collapseTableWithHeader(this.headerRenderer.bordersHandler, true);
                            }
                            this.bordersHandler.collapseTableWithFooter(this.footerRenderer.bordersHandler, true);
                        }
                        block8: for (addCol = 0; addCol < currentRow.length; ++addCol) {
                            if (currentRow[addCol] != null) continue;
                            for (int addRow = row + 1; addRow < this.rows.size(); ++addRow) {
                                if (this.rows.get(addRow)[addCol] == null) continue;
                                CellRenderer addRenderer = this.rows.get(addRow)[addCol];
                                if (row + addRenderer.getPropertyAsInteger(60) - 1 < addRow) continue block8;
                                cellProcessingQueue.addLast(new CellRendererInfo(addRenderer, addCol, addRow));
                                continue block8;
                            }
                        }
                    }
                    split = true;
                    splits[col] = cellResult;
                    if (cellResult.getStatus() == 3) {
                        hasContent = false;
                        splits[col].getOverflowRenderer().setProperty(75, (Object)verticalAlignment);
                    }
                }
                currChildRenderers.add(cell);
                if (cellResult.getStatus() == 3) continue;
                rowHeight = Math.max(rowHeight, cellResult.getOccupiedArea().getBBox().getHeight() + this.bordersHandler.getCellVerticalAddition(cellIndents) - rowspanOffset);
            }
            if (hasContent) {
                this.heights.add(Float.valueOf(rowHeight));
                rowsHasCellWithSetHeight.add(rowHasCellWithSetHeight);
                this.occupiedArea.getBBox().moveDown(rowHeight);
                this.occupiedArea.getBBox().increaseHeight(rowHeight);
                layoutBox.decreaseHeight(rowHeight);
            }
            if (split || row == this.rows.size() - 1) {
                this.bordersHandler.setFinishRow(this.bordersHandler.getStartRow() + row);
                if (!hasContent && this.bordersHandler.getFinishRow() != this.bordersHandler.getStartRow()) {
                    this.bordersHandler.setFinishRow(this.bordersHandler.getFinishRow() - 1);
                }
                boolean skip = false;
                if (null != this.footerRenderer && tableModel.isComplete() && tableModel.isSkipLastFooter() && !split) {
                    this.footerRenderer = null;
                    if (tableModel.isEmpty()) {
                        this.deleteOwnProperty(13);
                    }
                    skip = true;
                }
                this.correctLayoutedCellsOccupiedAreas(splits, row, targetOverflowRowIndex, blockMinHeight, layoutBox, rowsHasCellWithSetHeight, !split, !hasContent && cellWithBigRowspanAdded, skip);
            }
            if ((split || row == this.rows.size() - 1) && null != this.footerRenderer) {
                if (!hasContent && this.childRenderers.size() == 0) {
                    this.bordersHandler.applyTopTableBorder(this.occupiedArea.getBBox(), layoutBox, true);
                } else {
                    this.bordersHandler.applyBottomTableBorder(this.occupiedArea.getBBox(), layoutBox, tableModel.isEmpty(), false, true);
                }
                layoutBox.moveDown(this.footerRenderer.occupiedArea.getBBox().getHeight()).increaseHeight(this.footerRenderer.occupiedArea.getBBox().getHeight());
                this.bordersHandler.applyLeftAndRightTableBorder(layoutBox, true);
                this.prepareFooterOrHeaderRendererForLayout(this.footerRenderer, layoutBox.getWidth());
                this.bordersHandler.collapseTableWithFooter(this.footerRenderer.bordersHandler, hasContent || 0 != this.childRenderers.size());
                if (this.bordersHandler instanceof CollapsedTableBorders) {
                    this.footerRenderer.setBorders(CollapsedTableBorders.getCollapsedBorder(this.footerRenderer.getBorders()[2], this.getBorders()[2]), 2);
                }
                this.footerRenderer.layout(new LayoutContext(new LayoutArea(area.getPageNumber(), layoutBox), wasHeightClipped || wasParentsHeightClipped));
                this.bordersHandler.applyLeftAndRightTableBorder(layoutBox, false);
                float footerHeight = this.footerRenderer.getOccupiedAreaBBox().getHeight();
                this.footerRenderer.move(0.0f, -(layoutBox.getHeight() - footerHeight));
                layoutBox.setY(this.footerRenderer.occupiedArea.getBBox().getTop()).setHeight(this.occupiedArea.getBBox().getBottom() - layoutBox.getBottom());
            }
            if (!split) {
                this.childRenderers.addAll(currChildRenderers);
                currChildRenderers.clear();
            }
            if (!split) continue;
            if (marginsCollapsingEnabled) {
                marginsCollapseHandler.endMarginsCollapse(layoutBox);
            }
            TableRenderer[] splitResult = this.split(row, hasContent, cellWithBigRowspanAdded);
            OverflowRowsWrapper overflowRows = new OverflowRowsWrapper(splitResult[1]);
            if (null != this.headerRenderer || null != this.footerRenderer) {
                if (null != this.headerRenderer || tableModel.isEmpty()) {
                    splitResult[1].deleteOwnProperty(13);
                }
                if (null != this.footerRenderer || tableModel.isEmpty()) {
                    splitResult[1].deleteOwnProperty(10);
                }
            }
            if (split) {
                int[] rowspans = new int[currentRow.length];
                boolean[] columnsWithCellToBeEnlarged = new boolean[currentRow.length];
                for (col = 0; col < currentRow.length; ++col) {
                    boolean isBigRowspannedCell;
                    if (splits[col] != null) {
                        CellRenderer cellSplit = (CellRenderer)splits[col].getSplitRenderer();
                        if (null != cellSplit) {
                            rowspans[col] = cellSplit.getModelElement().getRowspan();
                        }
                        if (splits[col].getStatus() != 3 && (hasContent || cellWithBigRowspanAdded)) {
                            this.childRenderers.add(cellSplit);
                        }
                        LayoutArea cellOccupiedArea = currentRow[col].getOccupiedArea();
                        if (hasContent || cellWithBigRowspanAdded || splits[col].getStatus() == 3) {
                            CellRenderer cellOverflow = (CellRenderer)splits[col].getOverflowRenderer();
                            CellRenderer originalCell = currentRow[col];
                            currentRow[col] = null;
                            this.rows.get((int)targetOverflowRowIndex[col])[col] = originalCell;
                            overflowRows.setCell(0, col, null);
                            overflowRows.setCell(targetOverflowRowIndex[col] - row, col, (CellRenderer)cellOverflow.setParent(splitResult[1]));
                        } else {
                            overflowRows.setCell(targetOverflowRowIndex[col] - row, col, (CellRenderer)currentRow[col].setParent(splitResult[1]));
                        }
                        overflowRows.getCell((int)(targetOverflowRowIndex[col] - row), (int)col).occupiedArea = cellOccupiedArea;
                        continue;
                    }
                    if (currentRow[col] == null) continue;
                    if (hasContent) {
                        rowspans[col] = currentRow[col].getModelElement().getRowspan();
                    }
                    boolean bl4 = isBigRowspannedCell = 1 != currentRow[col].getModelElement().getRowspan();
                    if (!hasContent && !isBigRowspannedCell) continue;
                    columnsWithCellToBeEnlarged[col] = true;
                }
                int minRowspan = Integer.MAX_VALUE;
                for (col = 0; col < rowspans.length; ++col) {
                    if (0 == rowspans[col]) continue;
                    minRowspan = Math.min(minRowspan, rowspans[col]);
                }
                for (col = 0; col < numberOfColumns; ++col) {
                    if (!columnsWithCellToBeEnlarged[col]) continue;
                    LayoutArea cellOccupiedArea = currentRow[col].getOccupiedArea();
                    if (1 == minRowspan) {
                        CellRenderer overflowCell = (CellRenderer)currentRow[col].getModelElement().clone(true).getRenderer();
                        overflowCell.setParent(this);
                        overflowCell.deleteProperty(27);
                        overflowCell.deleteProperty(85);
                        overflowCell.deleteProperty(84);
                        overflowRows.setCell(0, col, null);
                        overflowRows.setCell(targetOverflowRowIndex[col] - row, col, overflowCell);
                        currentRow[col].isLastRendererForModelElement = false;
                        this.childRenderers.add(currentRow[col]);
                        CellRenderer originalCell = currentRow[col];
                        currentRow[col] = null;
                        this.rows.get((int)targetOverflowRowIndex[col])[col] = originalCell;
                    } else {
                        int i;
                        this.childRenderers.add(currentRow[col]);
                        for (i = row; i < row + minRowspan && i + 1 < this.rows.size() && splitResult[1].rows.get(i + 1 - row)[col] != null; ++i) {
                            overflowRows.setCell(i - row, col, splitResult[1].rows.get(i + 1 - row)[col]);
                            overflowRows.setCell(i + 1 - row, col, null);
                            this.rows.get((int)i)[col] = this.rows.get(i + 1)[col];
                            this.rows.get((int)(i + 1))[col] = null;
                        }
                        if (i != row + minRowspan - 1 && null != this.rows.get(i)[col]) {
                            CellRenderer overflowCell = (CellRenderer)this.rows.get(i)[col].getModelElement().getRenderer().setParent(this);
                            this.rows.get((int)i)[col].isLastRendererForModelElement = false;
                            overflowRows.setCell(i - row, col, null);
                            overflowRows.setCell(targetOverflowRowIndex[col] - row, col, overflowCell);
                            CellRenderer originalCell = this.rows.get(i)[col];
                            this.rows.get((int)i)[col] = null;
                            this.rows.get((int)targetOverflowRowIndex[col])[col] = originalCell;
                        }
                    }
                    overflowRows.getCell((int)(targetOverflowRowIndex[col] - row), (int)col).occupiedArea = cellOccupiedArea;
                }
            }
            if (null == this.footerRenderer) {
                if (0 != this.childRenderers.size()) {
                    this.bordersHandler.applyBottomTableBorder(this.occupiedArea.getBBox(), layoutBox, false);
                } else {
                    this.bordersHandler.applyTopTableBorder(this.occupiedArea.getBBox(), layoutBox, true);
                    if (!isAndWasComplete) {
                        this.bordersHandler.applyTopTableBorder(this.occupiedArea.getBBox(), layoutBox, 0 == this.childRenderers.size(), true, false);
                    }
                }
            }
            if (Boolean.TRUE.equals(this.getPropertyAsBoolean(86)) || Boolean.TRUE.equals(this.getPropertyAsBoolean(87))) {
                this.extendLastRow(splitResult[1].rows.get(0), layoutBox);
            }
            this.adjustFooterAndFixOccupiedArea(layoutBox);
            for (Map.Entry entry : rowMoves.entrySet()) {
                if (null != splitResult[1].rows.get((Integer)entry.getValue() - splitResult[0].rows.size())[(Integer)entry.getKey()]) continue;
                CellRenderer originalCellRenderer = this.rows.get(row)[(Integer)entry.getKey()];
                CellRenderer overflowCellRenderer = splitResult[1].rows.get(row - splitResult[0].rows.size())[(Integer)entry.getKey()];
                this.rows.get((int)((Integer)entry.getValue()).intValue())[((Integer)entry.getKey()).intValue()] = originalCellRenderer;
                this.rows.get((int)row)[((Integer)entry.getKey()).intValue()] = null;
                overflowRows.setCell((Integer)entry.getValue() - splitResult[0].rows.size(), (Integer)entry.getKey(), overflowCellRenderer);
                overflowRows.setCell(row - splitResult[0].rows.size(), (Integer)entry.getKey(), null);
            }
            if (this.isKeepTogether() && 0 == lastFlushedRowBottomBorder.size() && !Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                return new LayoutResult(3, null, null, this, null == firstCauseOfNothing ? this : firstCauseOfNothing);
            }
            int n = status = this.occupiedArea.getBBox().getHeight() - (null == this.footerRenderer ? 0.0f : this.footerRenderer.getOccupiedArea().getBBox().getHeight()) - (null == this.headerRenderer ? 0.0f : this.headerRenderer.getOccupiedArea().getBBox().getHeight() - this.headerRenderer.bordersHandler.getMaxBottomWidth()) == 0.0f && isAndWasComplete ? 3 : 2;
            if (status == 3 && Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) || wasHeightClipped) {
                if (wasHeightClipped) {
                    Logger logger = LoggerFactory.getLogger(TableRenderer.class);
                    logger.warn("Element content was clipped because some height properties are set.");
                    if (status == 3) {
                        this.bordersHandler.applyTopTableBorder(this.occupiedArea.getBBox(), layoutBox, 0 == this.childRenderers.size(), true, false);
                        this.bordersHandler.applyBottomTableBorder(this.occupiedArea.getBBox(), layoutBox, 0 == this.childRenderers.size(), true, false);
                    }
                    if (null != blockMinHeight && blockMinHeight.floatValue() > this.occupiedArea.getBBox().getHeight()) {
                        float blockBottom = Math.max(this.occupiedArea.getBBox().getBottom() - (blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight()), layoutBox.getBottom());
                        if (0 == this.heights.size()) {
                            this.heights.add(Float.valueOf(blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight() / 2.0f));
                        } else {
                            this.heights.set(this.heights.size() - 1, Float.valueOf(this.heights.get(this.heights.size() - 1).floatValue() + blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight()));
                        }
                        this.occupiedArea.getBBox().increaseHeight(this.occupiedArea.getBBox().getBottom() - blockBottom).setY(blockBottom);
                    }
                }
                this.applyFixedXOrYPosition(false, layoutBox);
                this.applyMargins(this.occupiedArea.getBBox(), true);
                LayoutArea editedArea = FloatingHelper.adjustResultOccupiedAreaForFloatAndClear(this, siblingFloatRendererAreas, layoutContext.getArea().getBBox(), clearHeightCorrection, marginsCollapsingEnabled);
                return new LayoutResult(1, editedArea, splitResult[0], null);
            }
            if (this.hasProperty(27)) {
                splitResult[1].updateHeight(Float.valueOf(this.retrieveHeight().floatValue() - this.occupiedArea.getBBox().getHeight()));
            }
            if (this.hasProperty(85)) {
                splitResult[1].updateMinHeight(Float.valueOf(this.retrieveMinHeight().floatValue() - this.occupiedArea.getBBox().getHeight()));
            }
            if (this.hasProperty(84)) {
                splitResult[1].updateMaxHeight(Float.valueOf(this.retrieveMaxHeight().floatValue() - this.occupiedArea.getBBox().getHeight()));
            }
            this.applyFixedXOrYPosition(false, layoutBox);
            this.applyMargins(this.occupiedArea.getBBox(), true);
            LayoutArea editedArea = null;
            if (status != 3) {
                editedArea = FloatingHelper.adjustResultOccupiedAreaForFloatAndClear(this, siblingFloatRendererAreas, layoutContext.getArea().getBBox(), clearHeightCorrection, marginsCollapsingEnabled);
            }
            return new LayoutResult(status, editedArea, splitResult[0], splitResult[1], null == firstCauseOfNothing ? this : firstCauseOfNothing);
        }
        if (tableModel.isComplete() && !tableModel.isEmpty()) {
            int lastInRow;
            CellRenderer[] lastRow = this.rows.get(this.rows.size() - 1);
            for (lastInRow = lastRow.length - 1; lastInRow >= 0 && null == lastRow[lastInRow]; --lastInRow) {
            }
            if (lastInRow < 0 || lastRow.length != lastInRow + lastRow[lastInRow].getPropertyAsInteger(16)) {
                Logger logger = LoggerFactory.getLogger(TableRenderer.class);
                logger.warn("Last row is not completed. Table bottom border may collapse as you do not expect it");
            }
        }
        if (tableModel.isComplete() && (0 != lastFlushedRowBottomBorder.size() || tableModel.isEmpty()) && null != this.footerRenderer) {
            layoutBox.moveDown(this.footerRenderer.occupiedArea.getBBox().getHeight()).increaseHeight(this.footerRenderer.occupiedArea.getBBox().getHeight());
            this.bordersHandler.applyLeftAndRightTableBorder(layoutBox, true);
            this.prepareFooterOrHeaderRendererForLayout(this.footerRenderer, layoutBox.getWidth());
            if (0 != this.rows.size() || !isAndWasComplete) {
                this.bordersHandler.collapseTableWithFooter(this.footerRenderer.bordersHandler, true);
            } else if (null != this.headerRenderer) {
                this.headerRenderer.bordersHandler.collapseTableWithFooter(this.footerRenderer.bordersHandler, true);
            }
            this.footerRenderer.layout(new LayoutContext(new LayoutArea(area.getPageNumber(), layoutBox), wasHeightClipped || wasParentsHeightClipped));
            this.bordersHandler.applyLeftAndRightTableBorder(layoutBox, false);
            float footerHeight = this.footerRenderer.getOccupiedAreaBBox().getHeight();
            this.footerRenderer.move(0.0f, -(layoutBox.getHeight() - footerHeight));
            layoutBox.moveUp(footerHeight).decreaseHeight(footerHeight);
        }
        float bottomTableBorderWidth = this.bordersHandler.getMaxBottomWidth();
        if (tableModel.isComplete()) {
            if (null == this.footerRenderer) {
                if (0 != this.childRenderers.size()) {
                    this.bordersHandler.applyBottomTableBorder(this.occupiedArea.getBBox(), layoutBox, false);
                } else if (0 != lastFlushedRowBottomBorder.size()) {
                    this.bordersHandler.applyTopTableBorder(this.occupiedArea.getBBox(), layoutBox, 0 == this.childRenderers.size(), true, false);
                } else {
                    this.bordersHandler.applyBottomTableBorder(this.occupiedArea.getBBox(), layoutBox, 0 == this.childRenderers.size(), true, false);
                }
            } else if (tableModel.isEmpty() && null != this.headerRenderer) {
                float headerBottomBorderWidth = this.headerRenderer.bordersHandler.getMaxBottomWidth();
                this.headerRenderer.bordersHandler.applyBottomTableBorder(this.headerRenderer.occupiedArea.getBBox(), layoutBox, true, true, true);
                this.occupiedArea.getBBox().moveUp(headerBottomBorderWidth).decreaseHeight(headerBottomBorderWidth);
            }
        } else {
            if (0 != this.heights.size()) {
                this.heights.set(this.heights.size() - 1, Float.valueOf(this.heights.get(this.heights.size() - 1).floatValue() - bottomTableBorderWidth / 2.0f));
            }
            if (null == this.footerRenderer) {
                if (0 != this.childRenderers.size()) {
                    this.bordersHandler.applyBottomTableBorder(this.occupiedArea.getBBox(), layoutBox, 0 == this.childRenderers.size(), false, true);
                }
            } else {
                layoutBox.increaseHeight(bottomTableBorderWidth);
            }
        }
        if (0 != this.rows.size()) {
            if (Boolean.TRUE.equals(this.getPropertyAsBoolean(86))) {
                this.extendLastRow(this.rows.get(this.rows.size() - 1), layoutBox);
            }
        } else if (null != blockMinHeight && blockMinHeight.floatValue() > this.occupiedArea.getBBox().getHeight()) {
            float blockBottom = Math.max(this.occupiedArea.getBBox().getBottom() - (blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight()), layoutBox.getBottom());
            if (0 != this.heights.size()) {
                this.heights.set(this.heights.size() - 1, Float.valueOf(this.heights.get(this.heights.size() - 1).floatValue() + this.occupiedArea.getBBox().getBottom() - blockBottom));
            } else {
                this.heights.add(Float.valueOf(this.occupiedArea.getBBox().getBottom() - blockBottom + this.occupiedArea.getBBox().getHeight() / 2.0f));
            }
            this.occupiedArea.getBBox().increaseHeight(this.occupiedArea.getBBox().getBottom() - blockBottom).setY(blockBottom);
        }
        this.applyFixedXOrYPosition(false, layoutBox);
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler.endMarginsCollapse(layoutBox);
        }
        this.applyMargins(this.occupiedArea.getBBox(), true);
        if (!tableModel.isComplete() && null != this.footerRenderer) {
            this.footerRenderer = null;
            this.bordersHandler.skipFooter(this.bordersHandler.tableBoundingBorders);
        }
        this.adjustFooterAndFixOccupiedArea(layoutBox);
        FloatingHelper.removeFloatsAboveRendererBottom(siblingFloatRendererAreas, this);
        LayoutArea editedArea = FloatingHelper.adjustResultOccupiedAreaForFloatAndClear(this, siblingFloatRendererAreas, layoutContext.getArea().getBBox(), clearHeightCorrection, marginsCollapsingEnabled);
        return new LayoutResult(1, editedArea, null, null, null);
    }

    @Override
    public void draw(DrawContext drawContext) {
        PdfDocument document = drawContext.getDocument();
        boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
        boolean ignoreTag = false;
        PdfName role = null;
        if (isTagged) {
            role = ((IAccessibleElement)((Object)this.getModelElement())).getRole();
            boolean isHeaderOrFooter = PdfName.THead.equals(role) || PdfName.TFoot.equals(role);
            boolean ignoreHeaderFooterTag = document.getTagStructureContext().getTagStructureTargetVersion().compareTo(PdfVersion.PDF_1_5) < 0;
            boolean bl = ignoreTag = isHeaderOrFooter && ignoreHeaderFooterTag;
        }
        if (role != null && !role.equals(PdfName.Artifact) && !ignoreTag) {
            boolean toRemoveConnectionsWithTag;
            TagTreePointer tagPointer = document.getTagStructureContext().getAutoTaggingPointer();
            IAccessibleElement accessibleElement = (IAccessibleElement)((Object)this.getModelElement());
            boolean alreadyCreated = tagPointer.isElementConnectedToTag(accessibleElement);
            tagPointer.addTag(accessibleElement, true);
            if (!alreadyCreated) {
                PdfDictionary layoutAttributes = AccessibleAttributesApplier.getLayoutAttributes(role, this, tagPointer);
                TableRenderer.applyGeneratedAccessibleAttributes(tagPointer, layoutAttributes);
            }
            this.beginTranformationIfApplied(drawContext.getCanvas());
            super.draw(drawContext);
            this.endTranformationIfApplied(drawContext.getCanvas());
            tagPointer.moveToParent();
            boolean bl = toRemoveConnectionsWithTag = this.isLastRendererForModelElement && ((Table)this.getModelElement()).isComplete();
            if (toRemoveConnectionsWithTag) {
                tagPointer.removeElementConnectionToTag(accessibleElement);
            }
        } else {
            this.beginTranformationIfApplied(drawContext.getCanvas());
            super.draw(drawContext);
            this.endTranformationIfApplied(drawContext.getCanvas());
        }
    }

    @Override
    public void drawChildren(DrawContext drawContext) {
        boolean shouldHaveFooterOrHeaderTag;
        Table modelElement = (Table)this.getModelElement();
        if (this.headerRenderer != null) {
            boolean notToTagHeader;
            boolean firstHeader = this.rowRange.getStartRow() == 0 && this.isOriginalNonSplitRenderer && !modelElement.isSkipFirstHeader();
            boolean bl = notToTagHeader = drawContext.isTaggingEnabled() && !firstHeader;
            if (notToTagHeader) {
                drawContext.setTaggingEnabled(false);
                drawContext.getCanvas().openTag(new CanvasArtifact());
            }
            this.headerRenderer.draw(drawContext);
            if (notToTagHeader) {
                drawContext.getCanvas().closeTag();
                drawContext.setTaggingEnabled(true);
            }
        }
        boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement && !this.childRenderers.isEmpty();
        TagTreePointer tagPointer = null;
        boolean bl = shouldHaveFooterOrHeaderTag = modelElement.getHeader() != null || modelElement.getFooter() != null;
        if (isTagged) {
            PdfName role = modelElement.getRole();
            if (role != null && !PdfName.Artifact.equals(role)) {
                tagPointer = drawContext.getDocument().getTagStructureContext().getAutoTaggingPointer();
                boolean ignoreHeaderFooterTag = drawContext.getDocument().getTagStructureContext().getTagStructureTargetVersion().compareTo(PdfVersion.PDF_1_5) < 0;
                boolean bl2 = shouldHaveFooterOrHeaderTag = shouldHaveFooterOrHeaderTag && !ignoreHeaderFooterTag && (!modelElement.isSkipFirstHeader() || !modelElement.isSkipLastFooter());
                if (shouldHaveFooterOrHeaderTag) {
                    if (tagPointer.getKidsRoles().contains(PdfName.TBody)) {
                        tagPointer.moveToKid(PdfName.TBody);
                    } else {
                        tagPointer.addTag(PdfName.TBody);
                    }
                }
            } else {
                isTagged = false;
            }
        }
        for (IRenderer child : this.childRenderers) {
            if (isTagged) {
                int adjustByHeaderRowsNum = 0;
                if (modelElement.getHeader() != null && !modelElement.isSkipFirstHeader() && !shouldHaveFooterOrHeaderTag) {
                    adjustByHeaderRowsNum = modelElement.getHeader().getNumberOfRows();
                }
                int cellRow = ((Cell)child.getModelElement()).getRow() + adjustByHeaderRowsNum;
                int cellRowKidIndex = -1;
                int foundRowsNum = 0;
                List<PdfName> kidsRoles = tagPointer.getKidsRoles();
                for (int i = 0; i < kidsRoles.size(); ++i) {
                    PdfName kidRole = kidsRoles.get(i);
                    if (kidRole == null || PdfName.TR.equals(kidRole)) {
                        ++foundRowsNum;
                    }
                    if (foundRowsNum - 1 != cellRow) continue;
                    cellRowKidIndex = i;
                    break;
                }
                if (cellRowKidIndex > -1) {
                    tagPointer.moveToKid(cellRowKidIndex);
                } else {
                    tagPointer.addTag(PdfName.TR);
                }
            }
            child.draw(drawContext);
            if (!isTagged) continue;
            tagPointer.moveToParent();
        }
        if (isTagged && shouldHaveFooterOrHeaderTag) {
            tagPointer.moveToParent();
        }
        this.drawBorders(drawContext);
        if (this.footerRenderer != null) {
            boolean notToTagFooter;
            boolean lastFooter = this.isLastRendererForModelElement && modelElement.isComplete() && !modelElement.isSkipLastFooter();
            boolean bl3 = notToTagFooter = drawContext.isTaggingEnabled() && !lastFooter;
            if (notToTagFooter) {
                drawContext.setTaggingEnabled(false);
                drawContext.getCanvas().openTag(new CanvasArtifact());
            }
            this.footerRenderer.draw(drawContext);
            if (notToTagFooter) {
                drawContext.getCanvas().closeTag();
                drawContext.setTaggingEnabled(true);
            }
        }
    }

    protected void drawBackgrounds(DrawContext drawContext) {
        boolean shrinkBackgroundArea;
        boolean bl = shrinkBackgroundArea = this.bordersHandler instanceof CollapsedTableBorders && (this.isHeaderRenderer() || this.isFooterRenderer());
        if (shrinkBackgroundArea) {
            this.occupiedArea.getBBox().applyMargins(this.bordersHandler.getMaxTopWidth() / 2.0f, this.bordersHandler.getRightBorderMaxWidth() / 2.0f, this.bordersHandler.getMaxBottomWidth() / 2.0f, this.bordersHandler.getLeftBorderMaxWidth() / 2.0f, false);
        }
        super.drawBackground(drawContext);
        if (shrinkBackgroundArea) {
            this.occupiedArea.getBBox().applyMargins(this.bordersHandler.getMaxTopWidth() / 2.0f, this.bordersHandler.getRightBorderMaxWidth() / 2.0f, this.bordersHandler.getMaxBottomWidth() / 2.0f, this.bordersHandler.getLeftBorderMaxWidth() / 2.0f, true);
        }
        if (null != this.headerRenderer) {
            this.headerRenderer.drawBackgrounds(drawContext);
        }
        if (null != this.footerRenderer) {
            this.footerRenderer.drawBackgrounds(drawContext);
        }
    }

    @Override
    public void drawBackground(DrawContext drawContext) {
        if (!this.isFooterRenderer() && !this.isHeaderRenderer()) {
            this.drawBackgrounds(drawContext);
        }
    }

    @Override
    public IRenderer getNextRenderer() {
        TableRenderer nextTable = new TableRenderer();
        nextTable.modelElement = this.modelElement;
        return nextTable;
    }

    @Override
    public void move(float dxRight, float dyUp) {
        super.move(dxRight, dyUp);
        if (this.headerRenderer != null) {
            this.headerRenderer.move(dxRight, dyUp);
        }
        if (this.footerRenderer != null) {
            this.footerRenderer.move(dxRight, dyUp);
        }
    }

    @Deprecated
    protected float[] calculateScaledColumnWidths(Table tableModel, float tableWidth) {
        return this.countedColumnWidth;
    }

    protected TableRenderer[] split(int row) {
        return this.split(row, false);
    }

    protected TableRenderer[] split(int row, boolean hasContent) {
        return this.split(row, hasContent, false);
    }

    protected TableRenderer[] split(int row, boolean hasContent, boolean cellWithBigRowspanAdded) {
        TableRenderer splitRenderer = this.createSplitRenderer(new Table.RowRange(this.rowRange.getStartRow(), this.rowRange.getStartRow() + row));
        splitRenderer.rows = this.rows.subList(0, row);
        splitRenderer.bordersHandler = this.bordersHandler;
        splitRenderer.heights = this.heights;
        splitRenderer.columnWidths = this.columnWidths;
        splitRenderer.countedColumnWidth = this.countedColumnWidth;
        splitRenderer.totalWidthForColumns = this.totalWidthForColumns;
        TableRenderer overflowRenderer = this.createOverflowRenderer(new Table.RowRange(this.rowRange.getStartRow() + row, this.rowRange.getFinishRow()));
        if (0 == row && !hasContent && !cellWithBigRowspanAdded && 0 == this.rowRange.getStartRow()) {
            overflowRenderer.isOriginalNonSplitRenderer = this.isOriginalNonSplitRenderer;
        }
        overflowRenderer.rows = this.rows.subList(row, this.rows.size());
        splitRenderer.occupiedArea = this.occupiedArea;
        overflowRenderer.bordersHandler = this.bordersHandler;
        return new TableRenderer[]{splitRenderer, overflowRenderer};
    }

    protected TableRenderer createSplitRenderer(Table.RowRange rowRange) {
        TableRenderer splitRenderer = (TableRenderer)this.getNextRenderer();
        splitRenderer.rowRange = rowRange;
        splitRenderer.parent = this.parent;
        splitRenderer.modelElement = this.modelElement;
        splitRenderer.childRenderers = this.childRenderers;
        splitRenderer.addAllProperties(this.getOwnProperties());
        splitRenderer.headerRenderer = this.headerRenderer;
        splitRenderer.footerRenderer = this.footerRenderer;
        splitRenderer.isLastRendererForModelElement = false;
        splitRenderer.topBorderMaxWidth = this.topBorderMaxWidth;
        return splitRenderer;
    }

    protected TableRenderer createOverflowRenderer(Table.RowRange rowRange) {
        TableRenderer overflowRenderer = (TableRenderer)this.getNextRenderer();
        overflowRenderer.setRowRange(rowRange);
        overflowRenderer.parent = this.parent;
        overflowRenderer.modelElement = this.modelElement;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        overflowRenderer.isOriginalNonSplitRenderer = false;
        overflowRenderer.countedColumnWidth = this.countedColumnWidth;
        return overflowRenderer;
    }

    @Override
    protected Float retrieveWidth(float parentBoxWidth) {
        Float tableWidth = super.retrieveWidth(parentBoxWidth);
        Table tableModel = (Table)this.getModelElement();
        if (tableWidth == null || tableWidth.floatValue() == 0.0f) {
            float totalColumnWidthInPercent = 0.0f;
            for (int col = 0; col < tableModel.getNumberOfColumns(); ++col) {
                UnitValue columnWidth = tableModel.getColumnWidth(col);
                if (!columnWidth.isPercentValue()) continue;
                totalColumnWidthInPercent += columnWidth.getValue();
            }
            tableWidth = Float.valueOf(parentBoxWidth);
            if (totalColumnWidthInPercent > 0.0f) {
                tableWidth = Float.valueOf(parentBoxWidth * totalColumnWidthInPercent / 100.0f);
            }
        }
        return tableWidth;
    }

    @Override
    protected MinMaxWidth getMinMaxWidth(float availableWidth) {
        this.initializeTableLayoutBorders();
        float rightMaxBorder = this.bordersHandler.getRightBorderMaxWidth();
        float leftMaxBorder = this.bordersHandler.getLeftBorderMaxWidth();
        TableWidths tableWidths = new TableWidths(this, availableWidth, true, rightMaxBorder, leftMaxBorder);
        float[] columns = tableWidths.layout();
        float minWidth = tableWidths.getMinWidth();
        this.cleanTableLayoutBorders();
        float maxColTotalWidth = 0.0f;
        for (float column : columns) {
            maxColTotalWidth += column;
        }
        float additionalWidth = this.getPropertyAsFloat(45).floatValue() + this.getPropertyAsFloat(44).floatValue() + rightMaxBorder / 2.0f + leftMaxBorder / 2.0f;
        return new MinMaxWidth(additionalWidth, availableWidth, minWidth, maxColTotalWidth);
    }

    @Override
    protected Float getLastYLineRecursively() {
        return null;
    }

    private void initializeTableLayoutBorders() {
        this.bordersHandler = new CollapsedTableBorders(this.rows, ((Table)this.getModelElement()).getNumberOfColumns(), this.getBorders());
        this.bordersHandler.initializeBorders();
        this.bordersHandler.setTableBoundingBorders(this.getBorders());
        this.bordersHandler.setRowRange(this.rowRange.getStartRow(), this.rowRange.getFinishRow());
        this.initializeHeaderAndFooter(true);
        this.bordersHandler.updateBordersOnNewPage(this.isOriginalNonSplitRenderer, this.isFooterRenderer() || this.isHeaderRenderer(), this, this.headerRenderer, this.footerRenderer);
        this.correctRowRange();
    }

    private void cleanTableLayoutBorders() {
        this.footerRenderer = null;
        this.headerRenderer = null;
        this.rowRange = new Table.RowRange(this.rowRange.getStartRow(), this.bordersHandler.getFinishRow());
        this.deleteOwnProperty(10);
        this.deleteOwnProperty(13);
    }

    private void correctRowRange() {
        if (this.rows.size() < this.rowRange.getFinishRow() - this.rowRange.getStartRow() + 1) {
            this.rowRange = new Table.RowRange(this.rowRange.getStartRow(), this.rowRange.getStartRow() + this.rows.size() - 1);
        }
    }

    @Override
    public void drawBorder(DrawContext drawContext) {
    }

    protected void drawBorders(DrawContext drawContext) {
        this.drawBorders(drawContext, null != this.headerRenderer, null != this.footerRenderer);
    }

    @Deprecated
    protected void drawBorders(DrawContext drawContext, boolean hasHeader, boolean hasFooter) {
        boolean isTagged;
        float height = this.occupiedArea.getBBox().getHeight();
        if (null != this.footerRenderer) {
            height -= this.footerRenderer.occupiedArea.getBBox().getHeight();
        }
        if (null != this.headerRenderer) {
            height -= this.headerRenderer.occupiedArea.getBBox().getHeight();
        }
        if (height < 1.0E-4f) {
            return;
        }
        float startX = this.getOccupiedArea().getBBox().getX() + this.bordersHandler.getLeftBorderMaxWidth() / 2.0f;
        float startY = this.getOccupiedArea().getBBox().getY() + this.getOccupiedArea().getBBox().getHeight();
        if (null != this.headerRenderer) {
            startY -= this.headerRenderer.occupiedArea.getBBox().getHeight();
            startY += this.topBorderMaxWidth / 2.0f;
        } else {
            startY -= this.topBorderMaxWidth / 2.0f;
        }
        if (this.hasProperty(46)) {
            Float topMargin = this.getPropertyAsFloat(46);
            startY -= null == topMargin ? 0.0f : topMargin.floatValue();
        }
        if (this.hasProperty(44)) {
            Float leftMargin = this.getPropertyAsFloat(44);
            startX += null == leftMargin ? 0.0f : leftMargin.floatValue();
        }
        if (this.childRenderers.size() == 0) {
            Border[] borders = this.bordersHandler.tableBoundingBorders;
            if (null != borders[0]) {
                if (null != borders[2] && 0 == this.heights.size()) {
                    this.heights.add(0, Float.valueOf(borders[0].getWidth() / 2.0f + borders[2].getWidth() / 2.0f));
                }
            } else if (null != borders[2]) {
                startY -= borders[2].getWidth() / 2.0f;
            }
            if (0 == this.heights.size()) {
                this.heights.add(Float.valueOf(0.0f));
            }
        }
        boolean bl = isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
        if (isTagged) {
            drawContext.getCanvas().openTag(new CanvasArtifact());
        }
        boolean isTopTablePart = this.isTopTablePart();
        boolean isBottomTablePart = this.isBottomTablePart();
        boolean isComplete = this.getTable().isComplete();
        boolean isFooterRendererOfLargeTable = this.isFooterRendererOfLargeTable();
        this.bordersHandler.setRowRange(this.rowRange.getStartRow(), this.rowRange.getStartRow() + this.heights.size() - 1);
        if (this.bordersHandler instanceof CollapsedTableBorders) {
            if (hasFooter) {
                ((CollapsedTableBorders)this.bordersHandler).setBottomBorderCollapseWith(this.footerRenderer.bordersHandler.getFirstHorizontalBorder());
            } else if (isBottomTablePart) {
                ((CollapsedTableBorders)this.bordersHandler).setBottomBorderCollapseWith(null);
            }
        }
        float y1 = startY;
        if (isFooterRendererOfLargeTable) {
            this.bordersHandler.drawHorizontalBorder(0, startX, y1, drawContext.getCanvas(), this.countedColumnWidth);
        }
        if (0 != this.heights.size()) {
            y1 -= this.heights.get(0).floatValue();
        }
        for (int i = 1; i < this.heights.size(); ++i) {
            this.bordersHandler.drawHorizontalBorder(i, startX, y1, drawContext.getCanvas(), this.countedColumnWidth);
            if (i >= this.heights.size()) continue;
            y1 -= this.heights.get(i).floatValue();
        }
        if (!isBottomTablePart && isComplete) {
            this.bordersHandler.drawHorizontalBorder(this.heights.size(), startX, y1, drawContext.getCanvas(), this.countedColumnWidth);
        }
        float x1 = startX;
        if (this.countedColumnWidth.length > 0) {
            x1 += this.countedColumnWidth[0];
        }
        for (int i = 1; i < this.bordersHandler.getNumberOfColumns(); ++i) {
            this.bordersHandler.drawVerticalBorder(i, startY, x1, drawContext.getCanvas(), this.heights);
            if (i >= this.countedColumnWidth.length) continue;
            x1 += this.countedColumnWidth[i];
        }
        if (isTopTablePart) {
            this.bordersHandler.drawHorizontalBorder(0, startX, startY, drawContext.getCanvas(), this.countedColumnWidth);
        }
        if (isBottomTablePart && isComplete) {
            this.bordersHandler.drawHorizontalBorder(this.heights.size(), startX, y1, drawContext.getCanvas(), this.countedColumnWidth);
        }
        this.bordersHandler.drawVerticalBorder(0, startY, startX, drawContext.getCanvas(), this.heights);
        this.bordersHandler.drawVerticalBorder(this.bordersHandler.getNumberOfColumns(), startY, x1, drawContext.getCanvas(), this.heights);
        if (isTagged) {
            drawContext.getCanvas().closeTag();
        }
    }

    private void applyFixedXOrYPosition(boolean isXPosition, Rectangle layoutBox) {
        if (this.isPositioned() && this.isFixedLayout()) {
            if (isXPosition) {
                float x = this.getPropertyAsFloat(79).floatValue();
                layoutBox.setX(x);
            } else {
                float y = this.getPropertyAsFloat(80).floatValue();
                this.move(0.0f, y - this.occupiedArea.getBBox().getY());
            }
        }
    }

    private void adjustFooterAndFixOccupiedArea(Rectangle layoutBox) {
        if (this.footerRenderer != null) {
            this.footerRenderer.move(0.0f, layoutBox.getHeight());
            float footerHeight = this.footerRenderer.getOccupiedArea().getBBox().getHeight();
            this.occupiedArea.getBBox().moveDown(footerHeight).increaseHeight(footerHeight);
        }
    }

    private void correctLayoutedCellsOccupiedAreas(LayoutResult[] splits, int row, int[] targetOverflowRowIndex, Float blockMinHeight, Rectangle layoutBox, List<Boolean> rowsHasCellWithSetHeight, boolean isLastRenderer, boolean processBigRowspan, boolean skip) {
        int finish = this.bordersHandler.getFinishRow();
        this.bordersHandler.setFinishRow(this.rowRange.getFinishRow());
        Border currentBorder = this.bordersHandler.getWidestHorizontalBorder(finish + 1);
        this.bordersHandler.setFinishRow(finish);
        if (skip) {
            this.bordersHandler.tableBoundingBorders[2] = this.getBorders()[2];
            this.bordersHandler.skipFooter(this.bordersHandler.tableBoundingBorders);
        }
        float currentBottomIndent = null == currentBorder ? 0.0f : currentBorder.getWidth();
        float realBottomIndent = this.bordersHandler.getMaxBottomWidth();
        if (0 != this.heights.size()) {
            this.heights.set(this.heights.size() - 1, Float.valueOf(this.heights.get(this.heights.size() - 1).floatValue() + (realBottomIndent - currentBottomIndent) / 2.0f));
            this.occupiedArea.getBBox().increaseHeight((realBottomIndent - currentBottomIndent) / 2.0f).moveDown((realBottomIndent - currentBottomIndent) / 2.0f);
            layoutBox.decreaseHeight((realBottomIndent - currentBottomIndent) / 2.0f);
            if (processBigRowspan) {
                CellRenderer[] currentRow = this.rows.get(this.heights.size());
                for (int col = 0; col < currentRow.length; ++col) {
                    CellRenderer cell;
                    CellRenderer cellRenderer = cell = null == splits[col] ? currentRow[col] : (CellRenderer)splits[col].getSplitRenderer();
                    if (cell == null) continue;
                    float height = 0.0f;
                    int rowspan = cell.getPropertyAsInteger(60);
                    int colspan = cell.getPropertyAsInteger(16);
                    float[] indents = this.bordersHandler.getCellBorderIndents(targetOverflowRowIndex[col], col, rowspan, colspan);
                    for (int l = this.heights.size() - 1 - 1; l > targetOverflowRowIndex[col] - rowspan && l >= 0; --l) {
                        height += this.heights.get(l).floatValue();
                    }
                    float cellHeightInLastRow = cell.getOccupiedArea().getBBox().getHeight() + indents[0] / 2.0f + indents[2] / 2.0f - height;
                    if (!(this.heights.get(this.heights.size() - 1).floatValue() < cellHeightInLastRow)) continue;
                    this.heights.set(this.heights.size() - 1, Float.valueOf(cellHeightInLastRow));
                }
            }
        }
        float additionalCellHeight = 0.0f;
        int numOfRowsWithFloatHeight = 0;
        if (isLastRenderer) {
            float additionalHeight = 0.0f;
            if (null != blockMinHeight && blockMinHeight.floatValue() > this.occupiedArea.getBBox().getHeight() + realBottomIndent / 2.0f) {
                additionalHeight = Math.min(layoutBox.getHeight() - realBottomIndent / 2.0f, blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight() - realBottomIndent / 2.0f);
                for (int k = 0; k < rowsHasCellWithSetHeight.size(); ++k) {
                    if (!Boolean.FALSE.equals(rowsHasCellWithSetHeight.get(k))) continue;
                    ++numOfRowsWithFloatHeight;
                }
            }
            additionalCellHeight = additionalHeight / (float)(0 == numOfRowsWithFloatHeight ? this.heights.size() : numOfRowsWithFloatHeight);
            for (int k = 0; k < this.heights.size(); ++k) {
                if (0 != numOfRowsWithFloatHeight && !Boolean.FALSE.equals(rowsHasCellWithSetHeight.get(k))) continue;
                this.heights.set(k, Float.valueOf(this.heights.get(k).floatValue() + additionalCellHeight));
            }
        }
        float cumulativeShift = 0.0f;
        for (int k = 0; k < this.heights.size(); ++k) {
            this.correctRowCellsOccupiedAreas(splits, row, targetOverflowRowIndex, k, rowsHasCellWithSetHeight, cumulativeShift, additionalCellHeight);
            if (!isLastRenderer || 0 != numOfRowsWithFloatHeight && !Boolean.FALSE.equals(rowsHasCellWithSetHeight.get(k))) continue;
            cumulativeShift += additionalCellHeight;
        }
        this.occupiedArea.getBBox().moveDown(cumulativeShift).increaseHeight(cumulativeShift);
        layoutBox.decreaseHeight(cumulativeShift);
    }

    private void correctRowCellsOccupiedAreas(LayoutResult[] splits, int row, int[] targetOverflowRowIndex, int currentRowIndex, List<Boolean> rowsHasCellWithSetHeight, float cumulativeShift, float additionalCellHeight) {
        CellRenderer[] currentRow = this.rows.get(currentRowIndex);
        for (int col = 0; col < currentRow.length; ++col) {
            CellRenderer cell;
            CellRenderer cellRenderer = cell = currentRowIndex < row || null == splits[col] ? currentRow[col] : (CellRenderer)splits[col].getSplitRenderer();
            if (cell == null) continue;
            float height = 0.0f;
            int colspan = cell.getPropertyAsInteger(16);
            int rowspan = cell.getPropertyAsInteger(60);
            float rowspanOffset = 0.0f;
            float[] indents = this.bordersHandler.getCellBorderIndents(currentRowIndex < row ? currentRowIndex : targetOverflowRowIndex[col], col, rowspan, colspan);
            for (int l = (currentRowIndex < row ? currentRowIndex : this.heights.size() - 1) - 1; l > (currentRowIndex < row ? currentRowIndex : targetOverflowRowIndex[col]) - rowspan && l >= 0; --l) {
                height += this.heights.get(l).floatValue();
                if (!Boolean.FALSE.equals(rowsHasCellWithSetHeight.get(l))) continue;
                rowspanOffset += additionalCellHeight;
            }
            height += this.heights.get(currentRowIndex < row ? currentRowIndex : this.heights.size() - 1).floatValue();
            float shift = (height -= indents[0] / 2.0f + indents[2] / 2.0f) - cell.getOccupiedArea().getBBox().getHeight();
            Rectangle bBox = cell.getOccupiedArea().getBBox();
            bBox.moveDown(shift);
            cell.move(0.0f, -(cumulativeShift - rowspanOffset));
            bBox.setHeight(height);
            cell.applyVerticalAlignment();
        }
    }

    protected void extendLastRow(CellRenderer[] lastRow, Rectangle freeBox) {
        if (null != lastRow && 0 != this.heights.size()) {
            this.heights.set(this.heights.size() - 1, Float.valueOf(this.heights.get(this.heights.size() - 1).floatValue() + freeBox.getHeight()));
            this.occupiedArea.getBBox().moveDown(freeBox.getHeight()).increaseHeight(freeBox.getHeight());
            for (CellRenderer cell : lastRow) {
                if (null == cell) continue;
                cell.occupiedArea.getBBox().moveDown(freeBox.getHeight()).increaseHeight(freeBox.getHeight());
            }
            freeBox.moveUp(freeBox.getHeight()).setHeight(0.0f);
        }
    }

    private void setRowRange(Table.RowRange rowRange) {
        this.rowRange = rowRange;
        for (int row = rowRange.getStartRow(); row <= rowRange.getFinishRow(); ++row) {
            this.rows.add(new CellRenderer[((Table)this.modelElement).getNumberOfColumns()]);
        }
    }

    private TableRenderer initFooterOrHeaderRenderer(boolean footer, Border[] tableBorders) {
        Table table = (Table)this.getModelElement();
        Table footerOrHeader = footer ? table.getFooter() : table.getHeader();
        int innerBorder = footer ? 0 : 2;
        int outerBorder = footer ? 2 : 0;
        TableRenderer renderer = (TableRenderer)footerOrHeader.createRendererSubTree().setParent(this);
        Border[] borders = renderer.getBorders();
        if (table.isEmpty()) {
            renderer.setBorders(CollapsedTableBorders.getCollapsedBorder(borders[innerBorder], tableBorders[innerBorder]), innerBorder);
            this.bordersHandler.tableBoundingBorders[innerBorder] = Border.NO_BORDER;
        }
        renderer.setBorders(CollapsedTableBorders.getCollapsedBorder(borders[1], tableBorders[1]), 1);
        renderer.setBorders(CollapsedTableBorders.getCollapsedBorder(borders[3], tableBorders[3]), 3);
        renderer.setBorders(CollapsedTableBorders.getCollapsedBorder(borders[outerBorder], tableBorders[outerBorder]), outerBorder);
        this.bordersHandler.tableBoundingBorders[outerBorder] = Border.NO_BORDER;
        renderer.bordersHandler = new CollapsedTableBorders(renderer.rows, ((Table)renderer.getModelElement()).getNumberOfColumns(), renderer.getBorders());
        renderer.bordersHandler.initializeBorders();
        renderer.bordersHandler.setRowRange(renderer.rowRange.getStartRow(), renderer.rowRange.getFinishRow());
        ((CollapsedTableBorders)renderer.bordersHandler).collapseAllBordersAndEmptyRows();
        renderer.correctRowRange();
        return renderer;
    }

    private TableRenderer prepareFooterOrHeaderRendererForLayout(TableRenderer renderer, float layoutBoxWidth) {
        renderer.countedColumnWidth = this.countedColumnWidth;
        renderer.bordersHandler.leftBorderMaxWidth = this.bordersHandler.getLeftBorderMaxWidth();
        renderer.bordersHandler.rightBorderMaxWidth = this.bordersHandler.getRightBorderMaxWidth();
        if (this.hasProperty(77)) {
            renderer.setProperty(77, UnitValue.createPointValue(layoutBoxWidth));
        }
        return this;
    }

    private boolean isHeaderRenderer() {
        return this.parent instanceof TableRenderer && ((TableRenderer)this.parent).headerRenderer == this;
    }

    private boolean isFooterRenderer() {
        return this.parent instanceof TableRenderer && ((TableRenderer)this.parent).footerRenderer == this;
    }

    private boolean isFooterRendererOfLargeTable() {
        return this.isFooterRenderer() && (!this.getTable().isComplete() || 0 != ((TableRenderer)this.parent).getTable().getLastRowBottomBorder().size());
    }

    private boolean isTopTablePart() {
        return null == this.headerRenderer && (!this.isFooterRenderer() || 0 == ((TableRenderer)this.parent).rows.size() && null == ((TableRenderer)this.parent).headerRenderer);
    }

    private boolean isBottomTablePart() {
        return null == this.footerRenderer && (!this.isHeaderRenderer() || 0 == ((TableRenderer)this.parent).rows.size() && null == ((TableRenderer)this.parent).footerRenderer);
    }

    private void calculateColumnWidths(float availableWidth) {
        if (this.countedColumnWidth == null || this.totalWidthForColumns != availableWidth) {
            TableWidths tableWidths = new TableWidths(this, availableWidth, false, this.bordersHandler.rightBorderMaxWidth, this.bordersHandler.leftBorderMaxWidth);
            this.countedColumnWidth = tableWidths.layout();
        }
    }

    private float getTableWidth() {
        float sum = 0.0f;
        for (float column : this.countedColumnWidth) {
            sum += column;
        }
        return sum + this.bordersHandler.getRightBorderMaxWidth() / 2.0f + this.bordersHandler.getLeftBorderMaxWidth() / 2.0f;
    }

    private static class OverflowRowsWrapper {
        private TableRenderer overflowRenderer;
        private HashMap<Integer, Boolean> isRowReplaced = new HashMap();
        private boolean isReplaced = false;

        public OverflowRowsWrapper(TableRenderer overflowRenderer) {
            this.overflowRenderer = overflowRenderer;
        }

        public CellRenderer getCell(int row, int col) {
            return this.overflowRenderer.rows.get(row)[col];
        }

        public CellRenderer setCell(int row, int col, CellRenderer newCell) {
            if (!this.isReplaced) {
                this.overflowRenderer.rows = new ArrayList<CellRenderer[]>(this.overflowRenderer.rows);
                this.isReplaced = true;
            }
            if (!Boolean.TRUE.equals(this.isRowReplaced.get(row))) {
                this.overflowRenderer.rows.set(row, (CellRenderer[])this.overflowRenderer.rows.get(row).clone());
            }
            CellRenderer cellRenderer = newCell;
            this.overflowRenderer.rows.get((int)row)[col] = cellRenderer;
            return cellRenderer;
        }
    }

    private static class CellRendererInfo {
        public CellRenderer cellRenderer;
        public int column;
        public int finishRowInd;

        public CellRendererInfo(CellRenderer cellRenderer, int column, int finishRow) {
            this.cellRenderer = cellRenderer;
            this.column = column;
            this.finishRowInd = finishRow;
        }
    }
}

