/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.draw.ILineDrawer;
import com.itextpdf.layout.element.Tab;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabRenderer
extends AbstractRenderer {
    public TabRenderer(Tab tab) {
        super(tab);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        LayoutArea area = layoutContext.getArea();
        Float width = this.retrieveWidth(area.getBBox().getWidth());
        Float height = this.getPropertyAsFloat(85);
        this.occupiedArea = new LayoutArea(area.getPageNumber(), new Rectangle(area.getBBox().getX(), area.getBBox().getY() + area.getBBox().getHeight(), width.floatValue(), height.floatValue()));
        return new LayoutResult(1, this.occupiedArea, null, null);
    }

    @Override
    public void draw(DrawContext drawContext) {
        if (this.occupiedArea == null) {
            Logger logger = LoggerFactory.getLogger(TabRenderer.class);
            logger.error(MessageFormatUtil.format("Occupied area has not been initialized. {0}", "Drawing won't be performed."));
            return;
        }
        ILineDrawer leader = (ILineDrawer)this.getProperty(68);
        if (leader == null) {
            return;
        }
        boolean isTagged = drawContext.isTaggingEnabled();
        if (isTagged) {
            drawContext.getCanvas().openTag(new CanvasArtifact());
        }
        this.beginElementOpacityApplying(drawContext);
        leader.draw(drawContext.getCanvas(), this.occupiedArea.getBBox());
        this.endElementOpacityApplying(drawContext);
        if (isTagged) {
            drawContext.getCanvas().closeTag();
        }
    }

    @Override
    public IRenderer getNextRenderer() {
        return new TabRenderer((Tab)this.modelElement);
    }
}

