/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.element.ListItem;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.property.ListSymbolAlignment;
import com.itextpdf.layout.property.ListSymbolPosition;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.DivRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.renderer.ListRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import com.itextpdf.layout.renderer.TextRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListItemRenderer
extends DivRenderer {
    protected IRenderer symbolRenderer;
    protected float symbolAreaWidth;
    private boolean symbolAddedInside;

    public ListItemRenderer(ListItem modelElement) {
        super(modelElement);
    }

    public void addSymbolRenderer(IRenderer symbolRenderer, float symbolAreaWidth) {
        this.symbolRenderer = symbolRenderer;
        this.symbolAreaWidth = symbolAreaWidth;
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        if (this.symbolRenderer != null && this.getProperty(27) == null && !this.isListSymbolEmpty(this.symbolRenderer)) {
            float[] ascenderDescender = this.calculateAscenderDescender();
            float minHeight = Math.max(this.symbolRenderer.getOccupiedArea().getBBox().getHeight(), ascenderDescender[0] - ascenderDescender[1]);
            this.updateMinHeight(Float.valueOf(minHeight));
        }
        this.applyListSymbolPosition();
        LayoutResult result = super.layout(layoutContext);
        if (2 == result.getStatus()) {
            result.getOverflowRenderer().deleteOwnProperty(85);
        }
        return result;
    }

    @Override
    public void draw(DrawContext drawContext) {
        if (this.occupiedArea == null) {
            Logger logger = LoggerFactory.getLogger(ListItemRenderer.class);
            logger.error(MessageFormatUtil.format("Occupied area has not been initialized. {0}", "Drawing won't be performed."));
            return;
        }
        boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
        TagTreePointer tagPointer = null;
        if (isTagged) {
            tagPointer = drawContext.getDocument().getTagStructureContext().getAutoTaggingPointer();
            IAccessibleElement modelElement = (IAccessibleElement)((Object)this.getModelElement());
            PdfName role = modelElement.getRole();
            if (role != null && !PdfName.Artifact.equals(role)) {
                boolean lBodyTagIsCreated = tagPointer.isElementConnectedToTag(modelElement);
                if (!lBodyTagIsCreated) {
                    tagPointer.addTag(PdfName.LI);
                } else {
                    tagPointer.moveToTag(modelElement).moveToParent();
                }
            } else {
                isTagged = false;
            }
        }
        super.draw(drawContext);
        if (this.symbolRenderer != null && !this.symbolAddedInside) {
            this.symbolRenderer.setParent(this);
            float x = this.occupiedArea.getBBox().getX();
            ListSymbolPosition symbolPosition = (ListSymbolPosition)((Object)ListRenderer.getListItemOrListProperty(this, this.parent, 83));
            if (symbolPosition != ListSymbolPosition.DEFAULT) {
                Float symbolIndent = this.getPropertyAsFloat(39);
                x -= this.symbolAreaWidth + (symbolIndent == null ? 0.0f : symbolIndent.floatValue());
                if (symbolPosition == ListSymbolPosition.OUTSIDE) {
                    x += this.getPropertyAsFloat(44).floatValue();
                }
            }
            this.applyMargins(this.occupiedArea.getBBox(), false);
            this.applyBorderBox(this.occupiedArea.getBBox(), false);
            if (this.childRenderers.size() > 0) {
                Float yLine = null;
                for (int i = 0; !(i >= this.childRenderers.size() || ((IRenderer)this.childRenderers.get(i)).getOccupiedArea().getBBox().getHeight() > 0.0f && (yLine = ((AbstractRenderer)this.childRenderers.get(i)).getFirstYLineRecursively()) != null); ++i) {
                }
                if (yLine != null) {
                    if (this.symbolRenderer instanceof TextRenderer) {
                        ((TextRenderer)this.symbolRenderer).moveYLineTo(yLine.floatValue());
                    } else {
                        this.symbolRenderer.move(0.0f, yLine.floatValue() - this.symbolRenderer.getOccupiedArea().getBBox().getY());
                    }
                } else {
                    this.symbolRenderer.move(0.0f, this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight() - (this.symbolRenderer.getOccupiedArea().getBBox().getY() + this.symbolRenderer.getOccupiedArea().getBBox().getHeight()));
                }
            } else if (this.symbolRenderer instanceof TextRenderer) {
                ((TextRenderer)this.symbolRenderer).moveYLineTo(this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight() - this.calculateAscenderDescender()[0]);
            } else {
                this.symbolRenderer.move(0.0f, this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight() - this.symbolRenderer.getOccupiedArea().getBBox().getHeight() - this.symbolRenderer.getOccupiedArea().getBBox().getY());
            }
            this.applyBorderBox(this.occupiedArea.getBBox(), true);
            this.applyMargins(this.occupiedArea.getBBox(), true);
            ListSymbolAlignment listSymbolAlignment = this.parent.getProperty(38, ListSymbolAlignment.RIGHT);
            float xPosition = x - this.symbolRenderer.getOccupiedArea().getBBox().getX();
            if (listSymbolAlignment == ListSymbolAlignment.RIGHT) {
                xPosition += this.symbolAreaWidth - this.symbolRenderer.getOccupiedArea().getBBox().getWidth();
            }
            this.symbolRenderer.move(xPosition, 0.0f);
            if (this.symbolRenderer.getOccupiedArea().getBBox().getRight() > this.parent.getOccupiedArea().getBBox().getLeft()) {
                if (isTagged) {
                    tagPointer.addTag(0, PdfName.Lbl);
                }
                this.beginElementOpacityApplying(drawContext);
                this.symbolRenderer.draw(drawContext);
                this.endElementOpacityApplying(drawContext);
                if (isTagged) {
                    tagPointer.moveToParent();
                }
            }
        }
        if (isTagged) {
            tagPointer.moveToParent();
        }
    }

    @Override
    public IRenderer getNextRenderer() {
        return new ListItemRenderer((ListItem)this.modelElement);
    }

    @Override
    protected AbstractRenderer createSplitRenderer(int layoutResult) {
        ListItemRenderer splitRenderer = (ListItemRenderer)this.getNextRenderer();
        splitRenderer.parent = this.parent;
        splitRenderer.modelElement = this.modelElement;
        splitRenderer.occupiedArea = this.occupiedArea;
        if (layoutResult == 2) {
            splitRenderer.symbolRenderer = this.symbolRenderer;
            splitRenderer.symbolAreaWidth = this.symbolAreaWidth;
        }
        splitRenderer.setProperty(44, this.getProperty(44));
        return splitRenderer;
    }

    @Override
    protected AbstractRenderer createOverflowRenderer(int layoutResult) {
        ListItemRenderer overflowRenderer = (ListItemRenderer)this.getNextRenderer();
        overflowRenderer.parent = this.parent;
        overflowRenderer.modelElement = this.modelElement;
        if (layoutResult == 3) {
            overflowRenderer.symbolRenderer = this.symbolRenderer;
            overflowRenderer.symbolAreaWidth = this.symbolAreaWidth;
        }
        overflowRenderer.setProperty(44, this.getProperty(44));
        return overflowRenderer;
    }

    private void applyListSymbolPosition() {
        ListSymbolPosition symbolPosition;
        if (this.symbolRenderer != null && (symbolPosition = (ListSymbolPosition)((Object)ListRenderer.getListItemOrListProperty(this, this.parent, 83))) == ListSymbolPosition.INSIDE) {
            Float symbolIndent;
            IRenderer paragraphRenderer;
            if (this.childRenderers.size() > 0 && this.childRenderers.get(0) instanceof ParagraphRenderer) {
                paragraphRenderer = (ParagraphRenderer)this.childRenderers.get(0);
                symbolIndent = this.getPropertyAsFloat(39);
                if (symbolIndent != null) {
                    this.symbolRenderer.setProperty(45, symbolIndent);
                }
                ((ParagraphRenderer)paragraphRenderer).childRenderers.add(0, this.symbolRenderer);
                this.symbolAddedInside = true;
            } else if (this.childRenderers.size() > 0 && this.childRenderers.get(0) instanceof ImageRenderer) {
                paragraphRenderer = ((Paragraph)new Paragraph().setMargin(0.0f)).createRendererSubTree();
                symbolIndent = this.getPropertyAsFloat(39);
                if (symbolIndent != null) {
                    this.symbolRenderer.setProperty(45, symbolIndent);
                }
                paragraphRenderer.addChild(this.symbolRenderer);
                paragraphRenderer.addChild((IRenderer)this.childRenderers.get(0));
                this.childRenderers.set(0, paragraphRenderer);
                this.symbolAddedInside = true;
            }
            if (!this.symbolAddedInside) {
                paragraphRenderer = ((Paragraph)new Paragraph().setMargin(0.0f)).createRendererSubTree();
                symbolIndent = this.getPropertyAsFloat(39);
                if (symbolIndent != null) {
                    this.symbolRenderer.setProperty(45, symbolIndent);
                }
                paragraphRenderer.addChild(this.symbolRenderer);
                this.childRenderers.add(0, paragraphRenderer);
                this.symbolAddedInside = true;
            }
        }
    }

    private boolean isListSymbolEmpty(IRenderer listSymbolRenderer) {
        return listSymbolRenderer instanceof TextRenderer && ((TextRenderer)listSymbolRenderer).getText().toString().length() == 0;
    }

    private float[] calculateAscenderDescender() {
        PdfFont listItemFont = this.resolveFirstPdfFont();
        Float fontSize = this.getPropertyAsFloat(24);
        if (listItemFont != null && fontSize != null) {
            float[] ascenderDescender = TextRenderer.calculateAscenderDescender(listItemFont);
            return new float[]{fontSize.floatValue() * ascenderDescender[0] / 1000.0f, fontSize.floatValue() * ascenderDescender[1] / 1000.0f};
        }
        return new float[]{0.0f, 0.0f};
    }
}

