/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.io.util.NumberUtil;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.font.FontCharacteristics;
import com.itextpdf.layout.font.FontFamilySplitter;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.PositionedLayoutContext;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.property.Background;
import com.itextpdf.layout.property.BackgroundImage;
import com.itextpdf.layout.property.BaseDirection;
import com.itextpdf.layout.property.BoxSizingPropertyValue;
import com.itextpdf.layout.property.HorizontalAlignment;
import com.itextpdf.layout.property.Property;
import com.itextpdf.layout.property.Transform;
import com.itextpdf.layout.property.TransparentColor;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.FloatingHelper;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.renderer.RootRenderer;
import com.itextpdf.layout.renderer.TableRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRenderer
implements IRenderer {
    public static final float EPS = 1.0E-4f;
    public static final float INF = 1000000.0f;
    protected List<IRenderer> childRenderers = new ArrayList<IRenderer>();
    protected List<IRenderer> positionedRenderers = new ArrayList<IRenderer>();
    protected IPropertyContainer modelElement;
    protected boolean flushed = false;
    protected LayoutArea occupiedArea;
    protected IRenderer parent;
    protected Map<Integer, Object> properties = new HashMap<Integer, Object>();
    protected boolean isLastRendererForModelElement = true;

    protected AbstractRenderer() {
    }

    protected AbstractRenderer(IElement modelElement) {
        this.modelElement = modelElement;
    }

    protected AbstractRenderer(AbstractRenderer other) {
        this.childRenderers = other.childRenderers;
        this.positionedRenderers = other.positionedRenderers;
        this.modelElement = other.modelElement;
        this.flushed = other.flushed;
        this.occupiedArea = other.occupiedArea != null ? other.occupiedArea.clone() : null;
        this.parent = other.parent;
        this.properties.putAll(other.properties);
        this.isLastRendererForModelElement = other.isLastRendererForModelElement;
    }

    @Override
    public void addChild(IRenderer renderer) {
        Integer positioning = (Integer)renderer.getProperty(52);
        if (positioning == null || positioning == 2 || positioning == 1) {
            this.childRenderers.add(renderer);
        } else if (positioning == 4) {
            AbstractRenderer root = this;
            while (root.parent instanceof AbstractRenderer) {
                root = (AbstractRenderer)root.parent;
            }
            if (root == this) {
                this.positionedRenderers.add(renderer);
            } else {
                root.addChild(renderer);
            }
        } else if (positioning == 3) {
            IRenderer parent;
            AbstractRenderer positionedParent = this;
            boolean noPositionInfo = AbstractRenderer.noAbsolutePositionInfo(renderer);
            while (!positionedParent.isPositioned() && !noPositionInfo && (parent = positionedParent.parent) instanceof AbstractRenderer) {
                positionedParent = (AbstractRenderer)parent;
            }
            if (positionedParent == this) {
                this.positionedRenderers.add(renderer);
            } else {
                positionedParent.addChild(renderer);
            }
        }
        if (renderer instanceof AbstractRenderer && !((AbstractRenderer)renderer).isPositioned() && ((AbstractRenderer)renderer).positionedRenderers.size() > 0) {
            int pos = 0;
            List<IRenderer> childPositionedRenderers = ((AbstractRenderer)renderer).positionedRenderers;
            while (pos < childPositionedRenderers.size()) {
                if (AbstractRenderer.noAbsolutePositionInfo(childPositionedRenderers.get(pos))) {
                    ++pos;
                    continue;
                }
                this.positionedRenderers.add(childPositionedRenderers.get(pos));
                childPositionedRenderers.remove(pos);
            }
        }
    }

    @Override
    public IPropertyContainer getModelElement() {
        return this.modelElement;
    }

    @Override
    public List<IRenderer> getChildRenderers() {
        return this.childRenderers;
    }

    @Override
    public boolean hasProperty(int property) {
        return this.hasOwnProperty(property) || this.modelElement != null && this.modelElement.hasProperty(property) || this.parent != null && Property.isPropertyInherited(property) && this.parent.hasProperty(property);
    }

    @Override
    public boolean hasOwnProperty(int property) {
        return this.properties.containsKey(property);
    }

    public boolean hasOwnOrModelProperty(int property) {
        return this.properties.containsKey(property) || null != this.getModelElement() && this.getModelElement().hasProperty(property);
    }

    @Override
    public void deleteOwnProperty(int property) {
        this.properties.remove(property);
    }

    public void deleteProperty(int property) {
        if (this.properties.containsKey(property)) {
            this.properties.remove(property);
        } else if (this.modelElement != null) {
            this.modelElement.deleteOwnProperty(property);
        }
    }

    @Override
    public <T1> T1 getProperty(int key) {
        Object property = this.properties.get(key);
        if (property != null || this.properties.containsKey(key)) {
            return (T1)property;
        }
        if (this.modelElement != null && ((property = this.modelElement.getProperty(key)) != null || this.modelElement.hasProperty(key))) {
            return (T1)property;
        }
        if (this.parent != null && Property.isPropertyInherited(key) && (property = this.parent.getProperty(key)) != null) {
            return (T1)property;
        }
        property = this.getDefaultProperty(key);
        if (property != null) {
            return (T1)property;
        }
        return this.modelElement != null ? (T1)this.modelElement.getDefaultProperty(key) : null;
    }

    @Override
    public <T1> T1 getOwnProperty(int property) {
        return (T1)this.properties.get(property);
    }

    @Override
    public <T1> T1 getProperty(int property, T1 defaultValue) {
        T1 result = this.getProperty(property);
        return result != null ? result : defaultValue;
    }

    @Override
    public void setProperty(int property, Object value) {
        this.properties.put(property, value);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        return null;
    }

    public PdfFont getPropertyAsFont(int property) {
        return (PdfFont)this.getProperty(property);
    }

    public Color getPropertyAsColor(int property) {
        return (Color)this.getProperty(property);
    }

    public TransparentColor getPropertyAsTransparentColor(int property) {
        return (TransparentColor)this.getProperty(property);
    }

    public Float getPropertyAsFloat(int property) {
        return NumberUtil.asFloat(this.getProperty(property));
    }

    public Float getPropertyAsFloat(int property, Float defaultValue) {
        return NumberUtil.asFloat(this.getProperty(property, defaultValue));
    }

    public Boolean getPropertyAsBoolean(int property) {
        return (Boolean)this.getProperty(property);
    }

    public Integer getPropertyAsInteger(int property) {
        return NumberUtil.asInteger(this.getProperty(property));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IRenderer renderer : this.childRenderers) {
            sb.append(renderer.toString());
        }
        return sb.toString();
    }

    @Override
    public LayoutArea getOccupiedArea() {
        return this.occupiedArea;
    }

    @Override
    public void draw(DrawContext drawContext) {
        this.applyDestinationsAndAnnotation(drawContext);
        boolean relativePosition = this.isRelativePosition();
        if (relativePosition) {
            this.applyRelativePositioningTranslation(false);
        }
        this.beginElementOpacityApplying(drawContext);
        this.drawBackground(drawContext);
        this.drawBorder(drawContext);
        this.drawChildren(drawContext);
        this.drawPositionedChildren(drawContext);
        this.endElementOpacityApplying(drawContext);
        if (relativePosition) {
            this.applyRelativePositioningTranslation(true);
        }
        this.flushed = true;
    }

    protected void beginElementOpacityApplying(DrawContext drawContext) {
        Float opacity = this.getPropertyAsFloat(92);
        if (opacity != null && opacity.floatValue() < 1.0f) {
            PdfExtGState extGState = new PdfExtGState();
            extGState.setStrokeOpacity(opacity.floatValue()).setFillOpacity(opacity.floatValue());
            drawContext.getCanvas().saveState().setExtGState(extGState);
        }
    }

    protected void endElementOpacityApplying(DrawContext drawContext) {
        Float opacity = this.getPropertyAsFloat(92);
        if (opacity != null && opacity.floatValue() < 1.0f) {
            drawContext.getCanvas().restoreState();
        }
    }

    public void drawBackground(DrawContext drawContext) {
        Background background = (Background)this.getProperty(6);
        BackgroundImage backgroundImage = (BackgroundImage)this.getProperty(90);
        if (background != null || backgroundImage != null) {
            Rectangle backgroundArea;
            boolean isTagged;
            Rectangle bBox = this.getOccupiedAreaBBox();
            boolean bl = isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
            if (isTagged) {
                drawContext.getCanvas().openTag(new CanvasArtifact());
            }
            if ((backgroundArea = this.applyMargins(bBox, false)).getWidth() <= 0.0f || backgroundArea.getHeight() <= 0.0f) {
                Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                logger.warn(MessageFormatUtil.format("The {0} rectangle has negative or zero sizes. It will not be displayed.", "background"));
                return;
            }
            boolean backgroundAreaIsClipped = false;
            if (background != null) {
                backgroundAreaIsClipped = this.clipBackgroundArea(drawContext, backgroundArea);
                TransparentColor backgroundColor = new TransparentColor(background.getColor(), background.getOpacity());
                drawContext.getCanvas().saveState().setFillColor(backgroundColor.getColor());
                backgroundColor.applyFillTransparency(drawContext.getCanvas());
                drawContext.getCanvas().rectangle(backgroundArea.getX() - background.getExtraLeft(), backgroundArea.getY() - background.getExtraBottom(), backgroundArea.getWidth() + background.getExtraLeft() + background.getExtraRight(), backgroundArea.getHeight() + background.getExtraTop() + background.getExtraBottom()).fill().restoreState();
            }
            if (backgroundImage != null && backgroundImage.getImage() != null) {
                if (!backgroundAreaIsClipped) {
                    backgroundAreaIsClipped = this.clipBackgroundArea(drawContext, backgroundArea);
                }
                this.applyBorderBox(backgroundArea, false);
                Rectangle imageRectangle = new Rectangle(backgroundArea.getX(), backgroundArea.getTop() - backgroundImage.getImage().getHeight(), backgroundImage.getImage().getWidth(), backgroundImage.getImage().getHeight());
                if (imageRectangle.getWidth() <= 0.0f || imageRectangle.getHeight() <= 0.0f) {
                    Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                    logger.warn(MessageFormatUtil.format("The {0} rectangle has negative or zero sizes. It will not be displayed.", "background-image"));
                    return;
                }
                this.applyBorderBox(backgroundArea, true);
                drawContext.getCanvas().saveState().rectangle(backgroundArea).clip().newPath();
                float initialX = backgroundImage.isRepeatX() ? imageRectangle.getX() - imageRectangle.getWidth() : imageRectangle.getX();
                float initialY = backgroundImage.isRepeatY() ? imageRectangle.getTop() : imageRectangle.getY();
                imageRectangle.setY(initialY);
                do {
                    imageRectangle.setX(initialX);
                    do {
                        drawContext.getCanvas().addXObject(backgroundImage.getImage(), imageRectangle);
                        imageRectangle.moveRight(imageRectangle.getWidth());
                    } while (backgroundImage.isRepeatX() && imageRectangle.getLeft() < backgroundArea.getRight());
                    imageRectangle.moveDown(imageRectangle.getHeight());
                } while (backgroundImage.isRepeatY() && imageRectangle.getTop() > backgroundArea.getBottom());
                drawContext.getCanvas().restoreState();
            }
            if (backgroundAreaIsClipped) {
                drawContext.getCanvas().restoreState();
            }
            if (isTagged) {
                drawContext.getCanvas().closeTag();
            }
        }
    }

    protected boolean clipBorderArea(DrawContext drawContext, Rectangle outerBorderBox) {
        double curv = 0.4477f;
        UnitValue borderRadius = (UnitValue)this.getProperty(101);
        float radius = 0.0f;
        if (null != borderRadius) {
            if (borderRadius.isPercentValue()) {
                Logger logger = LoggerFactory.getLogger(BlockRenderer.class);
                logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", "border-radius"));
            } else {
                radius = borderRadius.getValue();
            }
        }
        if (0.0f != radius) {
            float top = outerBorderBox.getTop();
            float right = outerBorderBox.getRight();
            float bottom = outerBorderBox.getBottom();
            float left = outerBorderBox.getLeft();
            float verticalRadius = Math.min(outerBorderBox.getHeight() / 2.0f, radius);
            float horizontalRadius = Math.min(outerBorderBox.getWidth() / 2.0f, radius);
            float x1 = right - horizontalRadius;
            float y1 = top - verticalRadius;
            float x2 = right - horizontalRadius;
            float y2 = bottom + verticalRadius;
            float x3 = left + horizontalRadius;
            float y3 = bottom + verticalRadius;
            float x4 = left + horizontalRadius;
            float y4 = top - verticalRadius;
            PdfCanvas canvas = drawContext.getCanvas();
            canvas.saveState();
            canvas.moveTo(left, top).lineTo(x1, top).curveTo((double)x1 + (double)horizontalRadius * (double)0.4477f, top, right, (double)y1 + (double)verticalRadius * (double)0.4477f, right, y1).lineTo(right, bottom).lineTo(left, bottom).lineTo(left, top);
            canvas.clip().newPath();
            canvas.moveTo(right, top).lineTo(right, y2).curveTo(right, (double)y2 - (double)verticalRadius * (double)0.4477f, (double)x2 + (double)horizontalRadius * (double)0.4477f, bottom, x2, bottom).lineTo(left, bottom).lineTo(left, top).lineTo(right, top);
            canvas.clip().newPath();
            canvas.moveTo(right, bottom).lineTo(x3, bottom).curveTo((double)x3 - (double)horizontalRadius * (double)0.4477f, bottom, left, (double)y3 - (double)verticalRadius * (double)0.4477f, left, y3).lineTo(left, top).lineTo(right, top).lineTo(right, bottom);
            canvas.clip().newPath();
            canvas.moveTo(left, bottom).lineTo(left, y4).curveTo(left, (double)y4 + (double)verticalRadius * (double)0.4477f, (double)x4 - (double)horizontalRadius * (double)0.4477f, top, x4, top).lineTo(right, top).lineTo(right, bottom).lineTo(left, bottom);
            canvas.clip().newPath();
            Border[] borders = this.getBorders();
            float radiusTop = verticalRadius;
            float radiusRight = horizontalRadius;
            float radiusBottom = verticalRadius;
            float radiusLeft = horizontalRadius;
            float topBorderWidth = 0.0f;
            float rightBorderWidth = 0.0f;
            float bottomBorderWidth = 0.0f;
            float leftBorderWidth = 0.0f;
            if (borders[0] != null) {
                topBorderWidth = borders[0].getWidth();
                if (y1 > (top -= borders[0].getWidth())) {
                    y1 = top;
                    y4 = top;
                }
                radiusTop = Math.max(0.0f, radiusTop - borders[0].getWidth());
            }
            if (borders[1] != null) {
                rightBorderWidth = borders[1].getWidth();
                if (x1 > (right -= borders[1].getWidth())) {
                    x1 = right;
                    x2 = right;
                }
                radiusRight = Math.max(0.0f, radiusRight - borders[1].getWidth());
            }
            if (borders[2] != null) {
                bottomBorderWidth = borders[2].getWidth();
                bottom += borders[2].getWidth();
                if (x3 < left) {
                    x3 = left;
                    x4 = left;
                }
                radiusBottom = Math.max(0.0f, radiusBottom - borders[2].getWidth());
            }
            if (borders[3] != null) {
                leftBorderWidth = borders[3].getWidth();
                left += borders[3].getWidth();
                radiusLeft = Math.max(0.0f, radiusLeft - borders[3].getWidth());
            }
            canvas.moveTo(x1, top).curveTo((double)x1 + (double)Math.min(radiusTop, radiusRight) * (double)0.4477f, top, right, (double)y1 + (double)Math.min(radiusTop, radiusRight) * (double)0.4477f, right, y1).lineTo(right, y2).lineTo(x3, y2).lineTo(x3, top).lineTo(x1, top).lineTo(x1, top + topBorderWidth).lineTo(left - leftBorderWidth, top + topBorderWidth).lineTo(left - leftBorderWidth, bottom - bottomBorderWidth).lineTo(right + rightBorderWidth, bottom - bottomBorderWidth).lineTo(right + rightBorderWidth, top + topBorderWidth).lineTo(x1, top + topBorderWidth);
            canvas.clip().newPath();
            canvas.moveTo(right, y2).curveTo(right, (double)y2 - (double)Math.min(radiusRight, radiusBottom) * (double)0.4477f, (double)x2 + (double)Math.min(radiusRight, radiusBottom) * (double)0.4477f, bottom, x2, bottom).lineTo(x3, bottom).lineTo(x3, y4).lineTo(right, y4).lineTo(right, y2).lineTo(right + rightBorderWidth, y2).lineTo(right + rightBorderWidth, top + topBorderWidth).lineTo(left - leftBorderWidth, top + topBorderWidth).lineTo(left - leftBorderWidth, bottom - bottomBorderWidth).lineTo(right + rightBorderWidth, bottom - bottomBorderWidth).lineTo(right + rightBorderWidth, y2);
            canvas.clip().newPath();
            canvas.moveTo(x3, bottom).curveTo((double)x3 - (double)Math.min(radiusBottom, radiusLeft) * (double)0.4477f, bottom, left, (double)y3 - (double)Math.min(radiusBottom, radiusLeft) * (double)0.4477f, left, y3).lineTo(left, y4).lineTo(x1, y4).lineTo(x1, bottom).lineTo(x3, bottom).lineTo(x3, bottom - bottomBorderWidth).lineTo(right + rightBorderWidth, bottom - bottomBorderWidth).lineTo(right + rightBorderWidth, top + topBorderWidth).lineTo(left - leftBorderWidth, top + topBorderWidth).lineTo(left - leftBorderWidth, bottom - bottomBorderWidth).lineTo(x3, bottom - bottomBorderWidth);
            canvas.clip().newPath();
            canvas.moveTo(left, y4).curveTo(left, (double)y4 + (double)Math.min(radiusLeft, radiusTop) * (double)0.4477f, (double)x4 - (double)Math.min(radiusLeft, radiusTop) * (double)0.4477f, top, x4, top).lineTo(x1, top).lineTo(x1, y2).lineTo(left, y2).lineTo(left, y4).lineTo(left - leftBorderWidth, y4).lineTo(left - leftBorderWidth, bottom - bottomBorderWidth).lineTo(right + rightBorderWidth, bottom - bottomBorderWidth).lineTo(right + rightBorderWidth, top + topBorderWidth).lineTo(left - leftBorderWidth, top + topBorderWidth).lineTo(left - leftBorderWidth, y4);
            canvas.clip().newPath();
        }
        return 0.0f != radius;
    }

    protected boolean clipBackgroundArea(DrawContext drawContext, Rectangle outerBorderBox) {
        double curv = 0.4477f;
        UnitValue borderRadius = (UnitValue)this.getProperty(101);
        float radius = 0.0f;
        if (null != borderRadius) {
            if (borderRadius.isPercentValue()) {
                Logger logger = LoggerFactory.getLogger(BlockRenderer.class);
                logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", "border-radius"));
            } else {
                radius = borderRadius.getValue();
            }
        }
        if (0.0f != radius) {
            float top = outerBorderBox.getTop();
            float right = outerBorderBox.getRight();
            float bottom = outerBorderBox.getBottom();
            float left = outerBorderBox.getLeft();
            float verticalRadius = Math.min(outerBorderBox.getHeight() / 2.0f, radius);
            float horizontalRadius = Math.min(outerBorderBox.getWidth() / 2.0f, radius);
            float x1 = right - horizontalRadius;
            float y1 = top - verticalRadius;
            float x2 = right - horizontalRadius;
            float y2 = bottom + verticalRadius;
            float x3 = left + horizontalRadius;
            float y3 = bottom + verticalRadius;
            float x4 = left + horizontalRadius;
            float y4 = top - verticalRadius;
            PdfCanvas canvas = drawContext.getCanvas();
            canvas.saveState();
            canvas.moveTo(left, top).lineTo(x1, top).curveTo((double)x1 + (double)horizontalRadius * (double)0.4477f, top, right, (double)y1 + (double)verticalRadius * (double)0.4477f, right, y1).lineTo(right, bottom).lineTo(left, bottom).lineTo(left, top);
            canvas.clip().newPath();
            canvas.moveTo(right, top).lineTo(right, y2).curveTo(right, (double)y2 - (double)verticalRadius * (double)0.4477f, (double)x2 + (double)horizontalRadius * (double)0.4477f, bottom, x2, bottom).lineTo(left, bottom).lineTo(left, top).lineTo(right, top);
            canvas.clip().newPath();
            canvas.moveTo(right, bottom).lineTo(x3, bottom).curveTo((double)x3 - (double)horizontalRadius * (double)0.4477f, bottom, left, (double)y3 - (double)verticalRadius * (double)0.4477f, left, y3).lineTo(left, top).lineTo(right, top).lineTo(right, bottom);
            canvas.clip().newPath();
            canvas.moveTo(left, bottom).lineTo(left, y4).curveTo(left, (double)y4 + (double)verticalRadius * (double)0.4477f, (double)x4 - (double)horizontalRadius * (double)0.4477f, top, x4, top).lineTo(right, top).lineTo(right, bottom).lineTo(left, bottom);
            canvas.clip().newPath();
        }
        return 0.0f != radius;
    }

    public void drawChildren(DrawContext drawContext) {
        ArrayList<IRenderer> waitingRenderers = new ArrayList<IRenderer>();
        for (IRenderer child : this.childRenderers) {
            if (FloatingHelper.isRendererFloating(child) || child.getProperty(106) != null) {
                RootRenderer rootRenderer = this.getRootRenderer();
                if (rootRenderer != null && !rootRenderer.waitingDrawingElements.contains(child)) {
                    rootRenderer.waitingDrawingElements.add(child);
                    continue;
                }
                waitingRenderers.add(child);
                continue;
            }
            child.draw(drawContext);
        }
        for (IRenderer waitingRenderer : waitingRenderers) {
            waitingRenderer.draw(drawContext);
        }
    }

    public void drawBorder(DrawContext drawContext) {
        Border[] borders = this.getBorders();
        boolean gotBorders = false;
        for (Border border : borders) {
            gotBorders = gotBorders || border != null;
        }
        if (gotBorders) {
            float topWidth = borders[0] != null ? borders[0].getWidth() : 0.0f;
            float rightWidth = borders[1] != null ? borders[1].getWidth() : 0.0f;
            float bottomWidth = borders[2] != null ? borders[2].getWidth() : 0.0f;
            float leftWidth = borders[3] != null ? borders[3].getWidth() : 0.0f;
            Rectangle bBox = this.getBorderAreaBBox();
            if (bBox.getWidth() < 0.0f || bBox.getHeight() < 0.0f) {
                Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                logger.error(MessageFormatUtil.format("The {0} rectangle has negative size. It will not be displayed.", "border"));
                return;
            }
            float x1 = bBox.getX();
            float y1 = bBox.getY();
            float x2 = bBox.getX() + bBox.getWidth();
            float y2 = bBox.getY() + bBox.getHeight();
            boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
            PdfCanvas canvas = drawContext.getCanvas();
            if (isTagged) {
                canvas.openTag(new CanvasArtifact());
            }
            boolean isAreaClipped = this.clipBorderArea(drawContext, this.applyMargins(this.occupiedArea.getBBox().clone(), this.getMargins(), false));
            UnitValue borderRadius = (UnitValue)this.getProperty(101);
            float radius = 0.0f;
            if (null != borderRadius) {
                if (borderRadius.isPercentValue()) {
                    Logger logger = LoggerFactory.getLogger(BlockRenderer.class);
                    logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", "border-radius"));
                } else {
                    radius = borderRadius.getValue();
                }
            }
            if (0.0f == radius) {
                if (borders[0] != null) {
                    borders[0].draw(canvas, x1, y2, x2, y2, Border.Side.TOP, leftWidth, rightWidth);
                }
                if (borders[1] != null) {
                    borders[1].draw(canvas, x2, y2, x2, y1, Border.Side.RIGHT, topWidth, bottomWidth);
                }
                if (borders[2] != null) {
                    borders[2].draw(canvas, x2, y1, x1, y1, Border.Side.BOTTOM, rightWidth, leftWidth);
                }
                if (borders[3] != null) {
                    borders[3].draw(canvas, x1, y1, x1, y2, Border.Side.LEFT, bottomWidth, topWidth);
                }
            } else {
                if (borders[0] != null) {
                    borders[0].draw(canvas, x1, y2, x2, y2, radius, Border.Side.TOP, leftWidth, rightWidth);
                }
                if (borders[1] != null) {
                    borders[1].draw(canvas, x2, y2, x2, y1, radius, Border.Side.RIGHT, topWidth, bottomWidth);
                }
                if (borders[2] != null) {
                    borders[2].draw(canvas, x2, y1, x1, y1, radius, Border.Side.BOTTOM, rightWidth, leftWidth);
                }
                if (borders[3] != null) {
                    borders[3].draw(canvas, x1, y1, x1, y2, radius, Border.Side.LEFT, bottomWidth, topWidth);
                }
            }
            if (isAreaClipped) {
                drawContext.getCanvas().restoreState();
            }
            if (isTagged) {
                canvas.closeTag();
            }
        }
    }

    @Override
    public boolean isFlushed() {
        return this.flushed;
    }

    @Override
    public IRenderer setParent(IRenderer parent) {
        this.parent = parent;
        return this;
    }

    public IRenderer getParent() {
        return this.parent;
    }

    @Override
    public void move(float dxRight, float dyUp) {
        this.occupiedArea.getBBox().moveRight(dxRight);
        this.occupiedArea.getBBox().moveUp(dyUp);
        for (IRenderer childRenderer : this.childRenderers) {
            childRenderer.move(dxRight, dyUp);
        }
        for (IRenderer childRenderer : this.positionedRenderers) {
            childRenderer.move(dxRight, dyUp);
        }
    }

    public List<Rectangle> initElementAreas(LayoutArea area) {
        return Collections.singletonList(area.getBBox());
    }

    public Rectangle getOccupiedAreaBBox() {
        return this.occupiedArea.getBBox().clone();
    }

    public Rectangle getBorderAreaBBox() {
        Rectangle rect = this.getOccupiedAreaBBox();
        this.applyMargins(rect, false);
        this.applyBorderBox(rect, false);
        return rect;
    }

    public Rectangle getInnerAreaBBox() {
        Rectangle rect = this.getOccupiedAreaBBox();
        this.applyMargins(rect, false);
        this.applyBorderBox(rect, false);
        this.applyPaddings(rect, false);
        return rect;
    }

    protected void applyDestinationsAndAnnotation(DrawContext drawContext) {
        this.applyDestination(drawContext.getDocument());
        this.applyAction(drawContext.getDocument());
        this.applyLinkAnnotation(drawContext.getDocument());
    }

    static boolean isBorderBoxSizing(IRenderer renderer) {
        BoxSizingPropertyValue boxSizing = (BoxSizingPropertyValue)((Object)renderer.getProperty(105));
        return boxSizing != null && boxSizing.equals((Object)BoxSizingPropertyValue.BORDER_BOX);
    }

    protected Float retrieveWidth(float parentBoxWidth) {
        Float width;
        Float minWidth = this.retrieveUnitValue(parentBoxWidth, 108);
        Float maxWidth = this.retrieveUnitValue(parentBoxWidth, 107);
        if (maxWidth != null && minWidth != null && minWidth.floatValue() > maxWidth.floatValue()) {
            maxWidth = minWidth;
        }
        if ((width = this.retrieveUnitValue(parentBoxWidth, 77)) != null) {
            if (maxWidth != null) {
                width = width.floatValue() > maxWidth.floatValue() ? maxWidth : width;
            } else if (minWidth != null) {
                width = width.floatValue() < minWidth.floatValue() ? minWidth : width;
            }
        } else if (maxWidth != null) {
            Float f = width = maxWidth.floatValue() < parentBoxWidth ? maxWidth : null;
        }
        if (width != null && AbstractRenderer.isBorderBoxSizing(this)) {
            width = Float.valueOf(width.floatValue() - AbstractRenderer.calculatePaddingBorderWidth(this));
        }
        return width != null ? Float.valueOf(Math.max(0.0f, width.floatValue())) : null;
    }

    protected Float retrieveMaxWidth(float parentBoxWidth) {
        Float maxWidth = this.retrieveUnitValue(parentBoxWidth, 107);
        if (maxWidth != null) {
            Float minWidth = this.retrieveUnitValue(parentBoxWidth, 108);
            if (minWidth != null && minWidth.floatValue() > maxWidth.floatValue()) {
                maxWidth = minWidth;
            }
            if (AbstractRenderer.isBorderBoxSizing(this)) {
                maxWidth = Float.valueOf(maxWidth.floatValue() - AbstractRenderer.calculatePaddingBorderWidth(this));
            }
            return Float.valueOf(maxWidth.floatValue() > 0.0f ? maxWidth.floatValue() : 0.0f);
        }
        return null;
    }

    protected Float retrieveMinWidth(float parentBoxWidth) {
        Float minWidth = this.retrieveUnitValue(parentBoxWidth, 108);
        if (minWidth != null) {
            if (AbstractRenderer.isBorderBoxSizing(this)) {
                minWidth = Float.valueOf(minWidth.floatValue() - AbstractRenderer.calculatePaddingBorderWidth(this));
            }
            return Float.valueOf(minWidth.floatValue() > 0.0f ? minWidth.floatValue() : 0.0f);
        }
        return null;
    }

    void updateWidth(UnitValue updatedWidthValue) {
        if (updatedWidthValue.isPointValue() && AbstractRenderer.isBorderBoxSizing(this)) {
            updatedWidthValue.setValue(updatedWidthValue.getValue() + AbstractRenderer.calculatePaddingBorderWidth(this));
        }
        this.setProperty(77, updatedWidthValue);
    }

    protected Float retrieveHeight() {
        Float height = (Float)this.getProperty(27);
        if (height != null && AbstractRenderer.isBorderBoxSizing(this)) {
            height = Float.valueOf(Math.max(0.0f, height.floatValue() - AbstractRenderer.calculatePaddingBorderHeight(this)));
        }
        return height;
    }

    void updateHeight(Float updatedHeightValue) {
        if (AbstractRenderer.isBorderBoxSizing(this)) {
            updatedHeightValue = Float.valueOf(updatedHeightValue.floatValue() + AbstractRenderer.calculatePaddingBorderHeight(this));
        }
        this.setProperty(27, updatedHeightValue);
    }

    protected Float retrieveMaxHeight() {
        Float maxHeight = (Float)this.getProperty(84);
        if (maxHeight != null && AbstractRenderer.isBorderBoxSizing(this)) {
            maxHeight = Float.valueOf(Math.max(0.0f, maxHeight.floatValue() - AbstractRenderer.calculatePaddingBorderHeight(this)));
        }
        return maxHeight;
    }

    void updateMaxHeight(Float updatedMaxHeightValue) {
        if (AbstractRenderer.isBorderBoxSizing(this)) {
            updatedMaxHeightValue = Float.valueOf(updatedMaxHeightValue.floatValue() + AbstractRenderer.calculatePaddingBorderHeight(this));
        }
        this.setProperty(84, updatedMaxHeightValue);
    }

    protected Float retrieveMinHeight() {
        Float minHeight = (Float)this.getProperty(85);
        if (minHeight != null && AbstractRenderer.isBorderBoxSizing(this)) {
            minHeight = Float.valueOf(Math.max(0.0f, minHeight.floatValue() - AbstractRenderer.calculatePaddingBorderHeight(this)));
        }
        return minHeight;
    }

    void updateMinHeight(Float updatedMinHeightValue) {
        if (AbstractRenderer.isBorderBoxSizing(this)) {
            updatedMinHeightValue = Float.valueOf(updatedMinHeightValue.floatValue() + AbstractRenderer.calculatePaddingBorderHeight(this));
        }
        this.setProperty(85, updatedMinHeightValue);
    }

    protected Float retrieveUnitValue(float basePercentValue, int property) {
        UnitValue value = (UnitValue)this.getProperty(property);
        if (value != null) {
            if (value.getUnitType() == 2) {
                return Float.valueOf(value.getValue() * basePercentValue / 100.0f);
            }
            assert (value.getUnitType() == 1);
            return Float.valueOf(value.getValue());
        }
        return null;
    }

    protected Map<Integer, Object> getOwnProperties() {
        return this.properties;
    }

    protected void addAllProperties(Map<Integer, Object> properties) {
        this.properties.putAll(properties);
    }

    protected Float getFirstYLineRecursively() {
        if (this.childRenderers.size() == 0) {
            return null;
        }
        return ((AbstractRenderer)this.childRenderers.get(0)).getFirstYLineRecursively();
    }

    protected Float getLastYLineRecursively() {
        for (int i = this.childRenderers.size() - 1; i >= 0; --i) {
            Float lastYLine;
            IRenderer child = this.childRenderers.get(i);
            if (!(child instanceof AbstractRenderer) || (lastYLine = ((AbstractRenderer)child).getLastYLineRecursively()) == null) continue;
            return lastYLine;
        }
        return null;
    }

    protected Rectangle applyMargins(Rectangle rect, boolean reverse) {
        return this.applyMargins(rect, this.getMargins(), reverse);
    }

    protected Rectangle applyMargins(Rectangle rect, float[] margins, boolean reverse) {
        return rect.applyMargins(margins[0], margins[1], margins[2], margins[3], reverse);
    }

    protected float[] getMargins() {
        return new float[]{this.getPropertyAsFloat(46).floatValue(), this.getPropertyAsFloat(45).floatValue(), this.getPropertyAsFloat(43).floatValue(), this.getPropertyAsFloat(44).floatValue()};
    }

    protected float[] getPaddings() {
        return new float[]{this.getPropertyAsFloat(50).floatValue(), this.getPropertyAsFloat(49).floatValue(), this.getPropertyAsFloat(47).floatValue(), this.getPropertyAsFloat(48).floatValue()};
    }

    protected Rectangle applyPaddings(Rectangle rect, boolean reverse) {
        return this.applyPaddings(rect, this.getPaddings(), reverse);
    }

    protected Rectangle applyPaddings(Rectangle rect, float[] paddings, boolean reverse) {
        return rect.applyMargins(paddings[0], paddings[1], paddings[2], paddings[3], reverse);
    }

    protected Rectangle applyBorderBox(Rectangle rect, boolean reverse) {
        Border[] borders = this.getBorders();
        return this.applyBorderBox(rect, borders, reverse);
    }

    protected Rectangle applyBorderBox(Rectangle rect, Border[] borders, boolean reverse) {
        float topWidth = borders[0] != null ? borders[0].getWidth() : 0.0f;
        float rightWidth = borders[1] != null ? borders[1].getWidth() : 0.0f;
        float bottomWidth = borders[2] != null ? borders[2].getWidth() : 0.0f;
        float leftWidth = borders[3] != null ? borders[3].getWidth() : 0.0f;
        return rect.applyMargins(topWidth, rightWidth, bottomWidth, leftWidth, reverse);
    }

    protected void applyAbsolutePosition(Rectangle parentRect) {
        Float top = this.getPropertyAsFloat(73);
        Float bottom = this.getPropertyAsFloat(14);
        Float left = this.getPropertyAsFloat(34);
        Float right = this.getPropertyAsFloat(54);
        if (left == null && right == null && BaseDirection.RIGHT_TO_LEFT.equals(this.getProperty(7))) {
            right = Float.valueOf(0.0f);
        }
        if (top == null && bottom == null) {
            top = Float.valueOf(0.0f);
        }
        try {
            if (right != null) {
                this.move(parentRect.getRight() - right.floatValue() - this.occupiedArea.getBBox().getRight(), 0.0f);
            }
            if (left != null) {
                this.move(parentRect.getLeft() + left.floatValue() - this.occupiedArea.getBBox().getLeft(), 0.0f);
            }
            if (top != null) {
                this.move(0.0f, parentRect.getTop() - top.floatValue() - this.occupiedArea.getBBox().getTop());
            }
            if (bottom != null) {
                this.move(0.0f, parentRect.getBottom() + bottom.floatValue() - this.occupiedArea.getBBox().getBottom());
            }
        }
        catch (Exception exc) {
            Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format("Occupied area has not been initialized. {0}", "Absolute positioning might be applied incorrectly."));
        }
    }

    protected void applyRelativePositioningTranslation(boolean reverse) {
        float dyUp;
        float top = this.getPropertyAsFloat(73, Float.valueOf(0.0f)).floatValue();
        float bottom = this.getPropertyAsFloat(14, Float.valueOf(0.0f)).floatValue();
        float left = this.getPropertyAsFloat(34, Float.valueOf(0.0f)).floatValue();
        float right = this.getPropertyAsFloat(54, Float.valueOf(0.0f)).floatValue();
        int reverseMultiplier = reverse ? -1 : 1;
        float dxRight = left != 0.0f ? left * (float)reverseMultiplier : -right * (float)reverseMultiplier;
        float f = dyUp = top != 0.0f ? -top * (float)reverseMultiplier : bottom * (float)reverseMultiplier;
        if (dxRight != 0.0f || dyUp != 0.0f) {
            this.move(dxRight, dyUp);
        }
    }

    protected void applyDestination(PdfDocument document) {
        String destination = (String)this.getProperty(17);
        if (destination != null) {
            PdfArray array = new PdfArray();
            array.add((PdfObject)document.getPage(this.occupiedArea.getPageNumber()).getPdfObject());
            array.add(PdfName.XYZ);
            array.add(new PdfNumber(this.occupiedArea.getBBox().getX()));
            array.add(new PdfNumber(this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight()));
            array.add(new PdfNumber(0));
            document.addNamedDestination(destination, array.makeIndirect(document));
            this.deleteProperty(17);
        }
    }

    protected void applyAction(PdfDocument document) {
        PdfAction action = (PdfAction)this.getProperty(1);
        if (action != null) {
            PdfLinkAnnotation link = (PdfLinkAnnotation)this.getProperty(88);
            if (link == null) {
                link = new PdfLinkAnnotation(new Rectangle(0.0f, 0.0f, 0.0f, 0.0f));
                Border border = (Border)this.getProperty(9);
                if (border != null) {
                    link.setBorder(new PdfArray(new float[]{0.0f, 0.0f, border.getWidth()}));
                } else {
                    link.setBorder(new PdfArray(new float[]{0.0f, 0.0f, 0.0f}));
                }
                this.setProperty(88, link);
            }
            link.setAction(action);
        }
    }

    protected void applyLinkAnnotation(PdfDocument document) {
        PdfLinkAnnotation linkAnnotation = (PdfLinkAnnotation)this.getProperty(88);
        if (linkAnnotation != null) {
            Rectangle pdfBBox = this.calculateAbsolutePdfBBox();
            linkAnnotation.setRectangle(new PdfArray(pdfBBox));
            PdfPage page = document.getPage(this.occupiedArea.getPageNumber());
            page.addAnnotation(linkAnnotation);
        }
    }

    protected MinMaxWidth getMinMaxWidth(float availableWidth) {
        return MinMaxWidthUtils.countDefaultMinMaxWidth(this, availableWidth);
    }

    protected boolean setMinMaxWidthBasedOnFixedWidth(MinMaxWidth minMaxWidth) {
        Float width;
        if (this.hasAbsoluteUnitValue(77) && (width = this.retrieveWidth(0.0f)) != null) {
            minMaxWidth.setChildrenMaxWidth(width.floatValue());
            minMaxWidth.setChildrenMinWidth(width.floatValue());
            return true;
        }
        return false;
    }

    protected boolean isNotFittingHeight(LayoutArea layoutArea) {
        return !this.isPositioned() && this.occupiedArea.getBBox().getHeight() > layoutArea.getBBox().getHeight();
    }

    protected boolean isNotFittingWidth(LayoutArea layoutArea) {
        return !this.isPositioned() && this.occupiedArea.getBBox().getWidth() > layoutArea.getBBox().getWidth();
    }

    protected boolean isNotFittingLayoutArea(LayoutArea layoutArea) {
        return this.isNotFittingHeight(layoutArea) || this.isNotFittingWidth(layoutArea);
    }

    protected boolean isPositioned() {
        return !this.isStaticLayout();
    }

    protected boolean isFixedLayout() {
        Object positioning = this.getProperty(52);
        return Integer.valueOf(4).equals(positioning);
    }

    protected boolean isStaticLayout() {
        Object positioning = this.getProperty(52);
        return positioning == null || Integer.valueOf(1).equals(positioning);
    }

    protected boolean isRelativePosition() {
        Integer positioning = this.getPropertyAsInteger(52);
        return Integer.valueOf(2).equals(positioning);
    }

    protected boolean isAbsolutePosition() {
        Integer positioning = this.getPropertyAsInteger(52);
        return Integer.valueOf(3).equals(positioning);
    }

    protected boolean isKeepTogether() {
        return Boolean.TRUE.equals(this.getPropertyAsBoolean(32));
    }

    @Deprecated
    protected void alignChildHorizontally(IRenderer childRenderer, float availableWidth) {
        HorizontalAlignment horizontalAlignment = (HorizontalAlignment)((Object)childRenderer.getProperty(28));
        if (horizontalAlignment != null && horizontalAlignment != HorizontalAlignment.LEFT) {
            float freeSpace = availableWidth - childRenderer.getOccupiedArea().getBBox().getWidth();
            switch (horizontalAlignment) {
                case RIGHT: {
                    childRenderer.move(freeSpace, 0.0f);
                    break;
                }
                case CENTER: {
                    childRenderer.move(freeSpace / 2.0f, 0.0f);
                }
            }
        }
    }

    protected void alignChildHorizontally(IRenderer childRenderer, Rectangle currentArea) {
        float freeSpace;
        float availableWidth = currentArea.getWidth();
        HorizontalAlignment horizontalAlignment = (HorizontalAlignment)((Object)childRenderer.getProperty(28));
        if (horizontalAlignment != null && horizontalAlignment != HorizontalAlignment.LEFT && (freeSpace = availableWidth - childRenderer.getOccupiedArea().getBBox().getWidth()) > 0.0f) {
            try {
                switch (horizontalAlignment) {
                    case RIGHT: {
                        childRenderer.move(freeSpace, 0.0f);
                        break;
                    }
                    case CENTER: {
                        childRenderer.move(freeSpace / 2.0f, 0.0f);
                    }
                }
            }
            catch (NullPointerException npe) {
                Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                logger.error(MessageFormatUtil.format("Occupied area has not been initialized. {0}", "Some of the children might not end up aligned horizontally."));
            }
        }
    }

    protected Border[] getBorders() {
        Border border = (Border)this.getProperty(9);
        Border topBorder = (Border)this.getProperty(13);
        Border rightBorder = (Border)this.getProperty(12);
        Border bottomBorder = (Border)this.getProperty(10);
        Border leftBorder = (Border)this.getProperty(11);
        Border[] borders = new Border[]{topBorder, rightBorder, bottomBorder, leftBorder};
        if (!this.hasOwnOrModelProperty(13)) {
            borders[0] = border;
        }
        if (!this.hasOwnOrModelProperty(12)) {
            borders[1] = border;
        }
        if (!this.hasOwnOrModelProperty(10)) {
            borders[2] = border;
        }
        if (!this.hasOwnOrModelProperty(11)) {
            borders[3] = border;
        }
        return borders;
    }

    protected AbstractRenderer setBorders(Border border, int borderNumber) {
        switch (borderNumber) {
            case 0: {
                this.setProperty(13, border);
                break;
            }
            case 1: {
                this.setProperty(12, border);
                break;
            }
            case 2: {
                this.setProperty(10, border);
                break;
            }
            case 3: {
                this.setProperty(11, border);
            }
        }
        return this;
    }

    protected Rectangle calculateAbsolutePdfBBox() {
        Rectangle contentBox = this.getOccupiedAreaBBox();
        List<Point> contentBoxPoints = this.rectangleToPointsList(contentBox);
        AbstractRenderer renderer = this;
        while (renderer.parent != null) {
            Float angle;
            if (renderer instanceof BlockRenderer && (angle = (Float)renderer.getProperty(55)) != null) {
                BlockRenderer blockRenderer = (BlockRenderer)renderer;
                AffineTransform rotationTransform = blockRenderer.createRotationTransformInsideOccupiedArea();
                this.transformPoints(contentBoxPoints, rotationTransform);
            }
            if (renderer.getProperty(106) != null && (renderer instanceof BlockRenderer || renderer instanceof ImageRenderer || renderer instanceof TableRenderer)) {
                AffineTransform rotationTransform = renderer.createTransformationInsideOccupiedArea();
                this.transformPoints(contentBoxPoints, rotationTransform);
            }
            renderer = (AbstractRenderer)renderer.parent;
        }
        return this.calculateBBox(contentBoxPoints);
    }

    protected Rectangle calculateBBox(List<Point> points) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (Point p : points) {
            minX = Math.min(p.getX(), minX);
            minY = Math.min(p.getY(), minY);
            maxX = Math.max(p.getX(), maxX);
            maxY = Math.max(p.getY(), maxY);
        }
        return new Rectangle((float)minX, (float)minY, (float)(maxX - minX), (float)(maxY - minY));
    }

    protected List<Point> rectangleToPointsList(Rectangle rect) {
        ArrayList<Point> points = new ArrayList<Point>();
        points.addAll(Arrays.asList(new Point(rect.getLeft(), rect.getBottom()), new Point(rect.getRight(), rect.getBottom()), new Point(rect.getRight(), rect.getTop()), new Point(rect.getLeft(), rect.getTop())));
        return points;
    }

    protected List<Point> transformPoints(List<Point> points, AffineTransform transform) {
        for (Point point : points) {
            transform.transform(point, point);
        }
        return points;
    }

    protected float[] calculateShiftToPositionBBoxOfPointsAt(float left, float top, List<Point> points) {
        double minX = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        for (Point point : points) {
            minX = Math.min(point.getX(), minX);
            maxY = Math.max(point.getY(), maxY);
        }
        float dx = (float)((double)left - minX);
        float dy = (float)((double)top - maxY);
        return new float[]{dx, dy};
    }

    protected void overrideHeightProperties() {
        Float height = this.getPropertyAsFloat(27);
        Float maxHeight = this.getPropertyAsFloat(84);
        Float minHeight = this.getPropertyAsFloat(85);
        if (null != height) {
            if (null == maxHeight || height.floatValue() < maxHeight.floatValue()) {
                maxHeight = height;
            } else {
                height = maxHeight;
            }
            if (null == minHeight || height.floatValue() > minHeight.floatValue()) {
                minHeight = height;
            }
        }
        if (null != maxHeight && null != minHeight && minHeight.floatValue() > maxHeight.floatValue()) {
            maxHeight = minHeight;
        }
        if (null != maxHeight) {
            this.setProperty(84, maxHeight);
        }
        if (null != minHeight) {
            this.setProperty(85, minHeight);
        }
    }

    protected boolean hasAbsoluteUnitValue(int property) {
        UnitValue value = (UnitValue)this.getProperty(property);
        return value != null && value.isPointValue();
    }

    boolean isFirstOnRootArea() {
        boolean isFirstOnRootArea = true;
        AbstractRenderer ancestor = this;
        while (isFirstOnRootArea && ancestor.getParent() != null) {
            IRenderer parent = ancestor.getParent();
            if (parent instanceof RootRenderer) {
                isFirstOnRootArea = ((RootRenderer)parent).getCurrentArea().isEmptyArea();
            } else {
                boolean bl = isFirstOnRootArea = parent.getOccupiedArea().getBBox().getHeight() < 1.0E-4f;
            }
            if (!(parent instanceof AbstractRenderer)) break;
            ancestor = (AbstractRenderer)parent;
        }
        return isFirstOnRootArea;
    }

    RootRenderer getRootRenderer() {
        IRenderer currentRenderer = this;
        while (currentRenderer instanceof AbstractRenderer) {
            if (currentRenderer instanceof RootRenderer) {
                return (RootRenderer)currentRenderer;
            }
            currentRenderer = currentRenderer.getParent();
        }
        return null;
    }

    static float calculateAdditionalWidth(AbstractRenderer renderer) {
        Rectangle dummy = new Rectangle(0.0f, 0.0f);
        renderer.applyMargins(dummy, true);
        renderer.applyBorderBox(dummy, true);
        renderer.applyPaddings(dummy, true);
        return dummy.getWidth();
    }

    static boolean noAbsolutePositionInfo(IRenderer renderer) {
        return !renderer.hasProperty(73) && !renderer.hasProperty(14) && !renderer.hasProperty(34) && !renderer.hasProperty(54);
    }

    static Float getPropertyAsFloat(IRenderer renderer, int property) {
        return NumberUtil.asFloat(renderer.getProperty(property));
    }

    static void applyGeneratedAccessibleAttributes(TagTreePointer tagPointer, PdfDictionary attributes) {
        if (attributes == null) {
            return;
        }
        PdfStructElem structElem = tagPointer.getDocument().getTagStructureContext().getPointerStructElem(tagPointer);
        PdfObject structElemAttr = structElem.getAttributes(false);
        if (structElemAttr == null || !structElemAttr.isDictionary() && !structElemAttr.isArray()) {
            structElem.setAttributes(attributes);
        } else if (structElemAttr.isDictionary()) {
            PdfArray attrArr = new PdfArray();
            attrArr.add(attributes);
            attrArr.add(structElemAttr);
            structElem.setAttributes(attrArr);
        } else {
            PdfArray attrArr = (PdfArray)structElemAttr;
            attrArr.add(0, attributes);
        }
    }

    void shrinkOccupiedAreaForAbsolutePosition() {
        if (this.isAbsolutePosition()) {
            Float left = this.getPropertyAsFloat(34);
            Float right = this.getPropertyAsFloat(54);
            UnitValue width = (UnitValue)this.getProperty(77);
            if (left == null && right == null && width == null) {
                this.occupiedArea.getBBox().setWidth(0.0f);
            }
        }
    }

    void drawPositionedChildren(DrawContext drawContext) {
        for (IRenderer positionedChild : this.positionedRenderers) {
            positionedChild.draw(drawContext);
        }
    }

    FontCharacteristics createFontCharacteristics() {
        FontCharacteristics fc = new FontCharacteristics();
        if (this.hasProperty(95)) {
            fc.setFontWeight((String)this.getProperty(95));
        }
        if (this.hasProperty(94)) {
            fc.setFontStyle((String)this.getProperty(94));
        }
        return fc;
    }

    PdfFont resolveFirstPdfFont() {
        Object font = this.getProperty(20);
        if (font instanceof PdfFont) {
            return (PdfFont)font;
        }
        if (font instanceof String) {
            FontProvider provider = (FontProvider)this.getProperty(91);
            if (provider == null) {
                throw new IllegalStateException("Invalid font type. FontProvider expected. Cannot resolve font with string value");
            }
            FontCharacteristics fc = this.createFontCharacteristics();
            return this.resolveFirstPdfFont((String)font, provider, fc);
        }
        throw new IllegalStateException("String or PdfFont expected as value of FONT property");
    }

    PdfFont resolveFirstPdfFont(String font, FontProvider provider, FontCharacteristics fc) {
        return provider.getPdfFont(provider.getFontSelector(FontFamilySplitter.splitFontFamily(font), fc).bestMatch());
    }

    void applyAbsolutePositionIfNeeded(LayoutContext layoutContext) {
        if (this.isAbsolutePosition()) {
            this.applyAbsolutePosition(layoutContext instanceof PositionedLayoutContext ? ((PositionedLayoutContext)layoutContext).getParentOccupiedArea().getBBox() : layoutContext.getArea().getBBox());
        }
    }

    void preparePositionedRendererAndAreaForLayout(IRenderer childPositionedRenderer, Rectangle fullBbox, Rectangle parentBbox) {
        Float left = AbstractRenderer.getPropertyAsFloat(childPositionedRenderer, 34);
        Float right = AbstractRenderer.getPropertyAsFloat(childPositionedRenderer, 54);
        Float top = AbstractRenderer.getPropertyAsFloat(childPositionedRenderer, 73);
        Float bottom = AbstractRenderer.getPropertyAsFloat(childPositionedRenderer, 14);
        childPositionedRenderer.setParent(this);
        this.adjustPositionedRendererLayoutBoxWidth(childPositionedRenderer, fullBbox, left, right);
        if (Integer.valueOf(3).equals(childPositionedRenderer.getProperty(52))) {
            this.updateMinHeightForAbsolutelyPositionedRenderer(childPositionedRenderer, parentBbox, top, bottom);
        }
    }

    private void updateMinHeightForAbsolutelyPositionedRenderer(IRenderer renderer, Rectangle parentRendererBox, Float top, Float bottom) {
        if (top != null && bottom != null && !renderer.hasProperty(27)) {
            Float currentMaxHeight = AbstractRenderer.getPropertyAsFloat(renderer, 84);
            Float currentMinHeight = AbstractRenderer.getPropertyAsFloat(renderer, 85);
            float resolvedMinHeight = Math.max(0.0f, parentRendererBox.getTop() - top.floatValue() - parentRendererBox.getBottom() - bottom.floatValue());
            if (currentMinHeight != null) {
                resolvedMinHeight = Math.max(resolvedMinHeight, currentMinHeight.floatValue());
            }
            if (currentMaxHeight != null) {
                resolvedMinHeight = Math.min(resolvedMinHeight, currentMaxHeight.floatValue());
            }
            renderer.setProperty(85, Float.valueOf(resolvedMinHeight));
        }
    }

    private void adjustPositionedRendererLayoutBoxWidth(IRenderer renderer, Rectangle fullBbox, Float left, Float right) {
        if (left != null) {
            fullBbox.setWidth(fullBbox.getWidth() - left.floatValue()).setX(fullBbox.getX() + left.floatValue());
        }
        if (right != null) {
            fullBbox.setWidth(fullBbox.getWidth() - right.floatValue());
        }
        if (left == null && right == null && !renderer.hasProperty(77)) {
            MinMaxWidth minMaxWidth;
            MinMaxWidth minMaxWidth2 = minMaxWidth = renderer instanceof BlockRenderer ? ((BlockRenderer)renderer).getMinMaxWidth(MinMaxWidthUtils.getMax()) : null;
            if (minMaxWidth != null && minMaxWidth.getMaxWidth() < fullBbox.getWidth()) {
                fullBbox.setWidth(minMaxWidth.getMaxWidth() + 1.0E-4f);
            }
        }
    }

    private static float calculatePaddingBorderWidth(AbstractRenderer renderer) {
        Rectangle dummy = new Rectangle(0.0f, 0.0f);
        renderer.applyBorderBox(dummy, true);
        renderer.applyPaddings(dummy, true);
        return dummy.getWidth();
    }

    private static float calculatePaddingBorderHeight(AbstractRenderer renderer) {
        Rectangle dummy = new Rectangle(0.0f, 0.0f);
        renderer.applyBorderBox(dummy, true);
        renderer.applyPaddings(dummy, true);
        return dummy.getHeight();
    }

    private AffineTransform createTransformationInsideOccupiedArea() {
        Rectangle backgroundArea = this.applyMargins(this.occupiedArea.clone().getBBox(), false);
        float x = backgroundArea.getX();
        float y = backgroundArea.getY();
        float height = backgroundArea.getHeight();
        float width = backgroundArea.getWidth();
        AffineTransform transform = AffineTransform.getTranslateInstance(-1.0f * (x + width / 2.0f), -1.0f * (y + height / 2.0f));
        transform.preConcatenate(Transform.getAffineTransform((Transform)this.getProperty(106), width, height));
        transform.preConcatenate(AffineTransform.getTranslateInstance(x + width / 2.0f, y + height / 2.0f));
        return transform;
    }

    protected void beginTranformationIfApplied(PdfCanvas canvas) {
        if (this.getProperty(106) != null) {
            AffineTransform transform = this.createTransformationInsideOccupiedArea();
            canvas.saveState().concatMatrix(transform);
        }
    }

    protected void endTranformationIfApplied(PdfCanvas canvas) {
        if (this.getProperty(106) != null) {
            canvas.restoreState();
        }
    }
}

