/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.font;

import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.io.font.Type1Font;
import com.itextpdf.io.util.FileUtil;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.layout.font.ComplexFontSelectorStrategy;
import com.itextpdf.layout.font.FontCharacteristics;
import com.itextpdf.layout.font.FontInfo;
import com.itextpdf.layout.font.FontSelector;
import com.itextpdf.layout.font.FontSelectorCache;
import com.itextpdf.layout.font.FontSelectorKey;
import com.itextpdf.layout.font.FontSelectorStrategy;
import com.itextpdf.layout.font.FontSet;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FontProvider {
    private final FontSet fontSet;
    private final Map<FontInfo, PdfFont> pdfFonts;
    private final FontSelectorCache fontSelectorCache;

    public FontProvider(FontSet fontSet) {
        this.fontSet = fontSet != null ? fontSet : new FontSet();
        this.pdfFonts = new HashMap<FontInfo, PdfFont>();
        this.fontSelectorCache = new FontSelectorCache(this.fontSet);
    }

    public FontProvider() {
        this(new FontSet());
    }

    public boolean addFont(FontProgram fontProgram, String encoding) {
        return this.fontSet.addFont(fontProgram, encoding);
    }

    public boolean addFont(String fontPath, String encoding) {
        return this.fontSet.addFont(fontPath, encoding, null);
    }

    public boolean addFont(byte[] fontData, String encoding) {
        return this.fontSet.addFont(fontData, encoding, null);
    }

    public boolean addFont(String fontPath) {
        return this.addFont(fontPath, null);
    }

    public boolean addFont(FontProgram fontProgram) {
        return this.addFont(fontProgram, this.getDefaultEncoding(fontProgram));
    }

    public boolean addFont(byte[] fontData) {
        return this.addFont(fontData, null);
    }

    public int addDirectory(String dir) {
        return this.fontSet.addDirectory(dir);
    }

    public int addSystemFonts() {
        String[] withoutSubDirs;
        String[] withSubDirs;
        int count = 0;
        for (String directory : withSubDirs = new String[]{FileUtil.getFontsDir(), "/usr/share/X11/fonts", "/usr/X/lib/X11/fonts", "/usr/openwin/lib/X11/fonts", "/usr/share/fonts", "/usr/X11R6/lib/X11/fonts"}) {
            count += this.fontSet.addDirectory(directory, true);
        }
        for (String directory : withoutSubDirs = new String[]{"/Library/Fonts", "/System/Library/Fonts"}) {
            count += this.fontSet.addDirectory(directory, false);
        }
        return count;
    }

    public int addStandardPdfFonts() {
        this.addFont("Courier");
        this.addFont("Courier-Bold");
        this.addFont("Courier-BoldOblique");
        this.addFont("Courier-Oblique");
        this.addFont("Helvetica");
        this.addFont("Helvetica-Bold");
        this.addFont("Helvetica-BoldOblique");
        this.addFont("Helvetica-Oblique");
        this.addFont("Symbol");
        this.addFont("Times-Roman");
        this.addFont("Times-Bold");
        this.addFont("Times-BoldItalic");
        this.addFont("Times-Italic");
        this.addFont("ZapfDingbats");
        return 14;
    }

    public FontSet getFontSet() {
        return this.fontSet;
    }

    public String getDefaultEncoding(FontProgram fontProgram) {
        if (fontProgram instanceof Type1Font) {
            return "Cp1252";
        }
        return "Identity-H";
    }

    public boolean getDefaultCacheFlag() {
        return true;
    }

    public boolean getDefaultEmbeddingFlag() {
        return true;
    }

    public FontSelectorStrategy getStrategy(String text, List<String> fontFamilies, FontCharacteristics fc, FontSet additonalFonts) {
        return new ComplexFontSelectorStrategy(text, this.getFontSelector(fontFamilies, fc, additonalFonts), this, additonalFonts);
    }

    public FontSelectorStrategy getStrategy(String text, List<String> fontFamilies, FontCharacteristics fc) {
        return this.getStrategy(text, fontFamilies, fc, null);
    }

    public FontSelectorStrategy getStrategy(String text, List<String> fontFamilies) {
        return this.getStrategy(text, fontFamilies, null);
    }

    public final FontSelector getFontSelector(List<String> fontFamilies, FontCharacteristics fc) {
        FontSelectorKey key = new FontSelectorKey(fontFamilies, fc);
        FontSelector fontSelector = this.fontSelectorCache.get(key);
        if (fontSelector == null) {
            fontSelector = this.createFontSelector(this.fontSet.getFonts(), fontFamilies, fc);
            this.fontSelectorCache.put(key, fontSelector);
        }
        return fontSelector;
    }

    public final FontSelector getFontSelector(List<String> fontFamilies, FontCharacteristics fc, FontSet tempFonts) {
        FontSelectorKey key = new FontSelectorKey(fontFamilies, fc);
        FontSelector fontSelector = this.fontSelectorCache.get(key, tempFonts);
        if (fontSelector == null) {
            fontSelector = this.createFontSelector(this.fontSet.getFonts(tempFonts), fontFamilies, fc);
            this.fontSelectorCache.put(key, fontSelector, tempFonts);
        }
        return fontSelector;
    }

    protected FontSelector createFontSelector(Collection<FontInfo> fonts, List<String> fontFamilies, FontCharacteristics fc) {
        return new FontSelector(fonts, fontFamilies, fc);
    }

    public PdfFont getPdfFont(FontInfo fontInfo) {
        return this.getPdfFont(fontInfo, null);
    }

    public PdfFont getPdfFont(FontInfo fontInfo, FontSet tempFonts) {
        PdfFont pdfFont;
        if (this.pdfFonts.containsKey(fontInfo)) {
            return this.pdfFonts.get(fontInfo);
        }
        FontProgram fontProgram = null;
        if (tempFonts != null) {
            fontProgram = tempFonts.getFontProgram(fontInfo);
        }
        if (fontProgram == null) {
            fontProgram = this.fontSet.getFontProgram(fontInfo);
        }
        try {
            String encoding;
            if (fontProgram == null) {
                fontProgram = fontInfo.getFontData() != null ? FontProgramFactory.createFont(fontInfo.getFontData(), this.getDefaultCacheFlag()) : FontProgramFactory.createFont(fontInfo.getFontName(), this.getDefaultCacheFlag());
            }
            if ((encoding = fontInfo.getEncoding()) == null || encoding.length() == 0) {
                encoding = this.getDefaultEncoding(fontProgram);
            }
            pdfFont = PdfFontFactory.createFont(fontProgram, encoding, this.getDefaultEmbeddingFlag());
        }
        catch (IOException e) {
            throw new PdfException("I/O exception while creating Font", e);
        }
        this.pdfFonts.put(fontInfo, pdfFont);
        return pdfFont;
    }
}

