/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.font;

import com.itextpdf.io.font.FontCacheKey;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramDescriptor;
import com.itextpdf.io.font.FontProgramDescriptorFactory;
import com.itextpdf.io.util.ArrayUtil;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.layout.font.FontProvider;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class FontInfo {
    private static final Map<FontCacheKey, FontProgramDescriptor> fontNamesCache = new ConcurrentHashMap<FontCacheKey, FontProgramDescriptor>();
    private final String fontName;
    private final byte[] fontData;
    private final FontProgramDescriptor descriptor;
    private final int hash;
    private final String encoding;
    private final String alias;

    private FontInfo(String fontName, byte[] fontData, String encoding, FontProgramDescriptor descriptor, String alias) {
        this.fontName = fontName;
        this.fontData = fontData;
        this.encoding = encoding;
        this.descriptor = descriptor;
        this.alias = alias != null ? alias.toLowerCase() : null;
        this.hash = FontInfo.calculateHashCode(fontName, fontData, encoding);
    }

    static FontInfo create(FontInfo fontInfo, String alias) {
        return new FontInfo(fontInfo.fontName, fontInfo.fontData, fontInfo.encoding, fontInfo.descriptor, alias);
    }

    static FontInfo create(FontProgram fontProgram, String encoding, String alias) {
        FontProgramDescriptor descriptor = FontProgramDescriptorFactory.fetchDescriptor(fontProgram);
        return new FontInfo(descriptor.getFontName(), null, encoding, descriptor, alias);
    }

    static FontInfo create(String fontName, String encoding, String alias) {
        FontCacheKey cacheKey = FontCacheKey.create(fontName);
        FontProgramDescriptor descriptor = FontInfo.getFontNamesFromCache(cacheKey);
        if (descriptor == null) {
            descriptor = FontProgramDescriptorFactory.fetchDescriptor(fontName);
            FontInfo.putFontNamesToCache(cacheKey, descriptor);
        }
        return descriptor != null ? new FontInfo(fontName, null, encoding, descriptor, alias) : null;
    }

    static FontInfo create(byte[] fontProgram, String encoding, String alias) {
        FontCacheKey cacheKey = FontCacheKey.create(fontProgram);
        FontProgramDescriptor descriptor = FontInfo.getFontNamesFromCache(cacheKey);
        if (descriptor == null) {
            descriptor = FontProgramDescriptorFactory.fetchDescriptor(fontProgram);
            FontInfo.putFontNamesToCache(cacheKey, descriptor);
        }
        return descriptor != null ? new FontInfo(null, fontProgram, encoding, descriptor, alias) : null;
    }

    @Deprecated
    public PdfFont getPdfFont(FontProvider fontProvider) {
        return fontProvider.getPdfFont(this);
    }

    public FontProgramDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getFontName() {
        return this.fontName;
    }

    @Deprecated
    public byte[] getFontProgram() {
        return this.fontData;
    }

    public byte[] getFontData() {
        return this.fontData;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FontInfo)) {
            return false;
        }
        FontInfo that = (FontInfo)o;
        return (this.fontName != null ? this.fontName.equals(that.fontName) : that.fontName == null) && Arrays.equals(this.fontData, that.fontData) && (this.encoding != null ? this.encoding.equals(that.encoding) : that.encoding == null);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        String name = this.descriptor.getFontName();
        if (name.length() > 0) {
            if (this.encoding != null) {
                return String.format("%s+%s", name, this.encoding);
            }
            return name;
        }
        return super.toString();
    }

    private static int calculateHashCode(String fontName, byte[] bytes, String encoding) {
        int result = fontName != null ? fontName.hashCode() : 0;
        result = 31 * result + ArrayUtil.hashCode(bytes);
        result = 31 * result + (encoding != null ? encoding.hashCode() : 0);
        return result;
    }

    private static FontProgramDescriptor getFontNamesFromCache(FontCacheKey key) {
        return fontNamesCache.get(key);
    }

    private static void putFontNamesToCache(FontCacheKey key, FontProgramDescriptor descriptor) {
        if (descriptor != null) {
            fontNamesCache.put(key, descriptor);
        }
    }
}

