/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.border;

import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.property.TransparentColor;

public abstract class Border {
    public static final Border NO_BORDER = null;
    public static final int SOLID = 0;
    public static final int DASHED = 1;
    public static final int DOTTED = 2;
    public static final int DOUBLE = 3;
    public static final int ROUND_DOTS = 4;
    public static final int _3D_GROOVE = 5;
    public static final int _3D_INSET = 6;
    public static final int _3D_OUTSET = 7;
    public static final int _3D_RIDGE = 8;
    @Deprecated
    protected Color color;
    protected TransparentColor transparentColor;
    protected float width;
    protected int type;
    private int hash;
    @Deprecated
    private Side tmpSide = Side.NONE;

    protected Border(float width) {
        this(Color.BLACK, width);
    }

    protected Border(Color color, float width) {
        this.color = color;
        this.transparentColor = new TransparentColor(color);
        this.width = width;
    }

    protected Border(Color color, float width, float opacity) {
        this.color = color;
        this.transparentColor = new TransparentColor(color, opacity);
        this.width = width;
    }

    @Deprecated
    public abstract void draw(PdfCanvas var1, float var2, float var3, float var4, float var5, float var6, float var7);

    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, Side side, float borderWidthBefore, float borderWidthAfter) {
        this.tmpSide = side;
        this.draw(canvas, x1, y1, x2, y2, borderWidthBefore, borderWidthAfter);
        this.tmpSide = Side.NONE;
    }

    public abstract void draw(PdfCanvas var1, float var2, float var3, float var4, float var5, float var6, Side var7, float var8, float var9);

    public abstract void drawCellBorder(PdfCanvas var1, float var2, float var3, float var4, float var5);

    public abstract int getType();

    public Color getColor() {
        return this.transparentColor.getColor();
    }

    public float getOpacity() {
        return this.transparentColor.getOpacity();
    }

    public float getWidth() {
        return this.width;
    }

    public void setColor(Color color) {
        this.color = color;
        this.transparentColor = new TransparentColor(color, this.transparentColor.getOpacity());
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof Border) {
            Border anotherBorder = (Border)anObject;
            return anotherBorder.getType() == this.getType() && anotherBorder.getColor().equals(this.getColor()) && anotherBorder.getWidth() == this.getWidth() && anotherBorder.transparentColor.getOpacity() == this.transparentColor.getOpacity();
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = (int)this.getWidth() * 31 + this.getColor().hashCode();
            this.hash = h = h * 31 + (int)this.transparentColor.getOpacity();
        }
        return h;
    }

    @Deprecated
    protected Side getBorderSide(float x1, float y1, float x2, float y2) {
        return this.getBorderSide(x1, y1, x2, y2, this.tmpSide);
    }

    protected Side getBorderSide(float x1, float y1, float x2, float y2, Side tempSide) {
        boolean isLeft = false;
        boolean isRight = false;
        if (Math.abs(y2 - y1) > 5.0E-4f) {
            isLeft = y2 - y1 > 0.0f;
            isRight = y2 - y1 < 0.0f;
        }
        boolean isTop = false;
        boolean isBottom = false;
        if (Math.abs(x2 - x1) > 5.0E-4f) {
            isTop = x2 - x1 > 0.0f;
            boolean bl = isBottom = x2 - x1 < 0.0f;
        }
        if (isTop) {
            return isLeft ? Side.LEFT : Side.TOP;
        }
        if (isRight) {
            return Side.RIGHT;
        }
        if (isBottom) {
            return Side.BOTTOM;
        }
        if (isLeft) {
            return Side.LEFT;
        }
        return tempSide;
    }

    protected Point getIntersectionPoint(Point lineBeg, Point lineEnd, Point clipLineBeg, Point clipLineEnd) {
        double A1 = lineBeg.getY() - lineEnd.getY();
        double A2 = clipLineBeg.getY() - clipLineEnd.getY();
        double B1 = lineEnd.getX() - lineBeg.getX();
        double B2 = clipLineEnd.getX() - clipLineBeg.getX();
        double C1 = lineBeg.getX() * lineEnd.getY() - lineBeg.getY() * lineEnd.getX();
        double C2 = clipLineBeg.getX() * clipLineEnd.getY() - clipLineBeg.getY() * clipLineEnd.getX();
        double M = B1 * A2 - B2 * A1;
        return new Point((B2 * C1 - B1 * C2) / M, (C2 * A1 - C1 * A2) / M);
    }

    public static enum Side {
        NONE,
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }
}

