/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import java.util.Collection;

public class PdfTextArray
extends PdfArray {
    private static final long serialVersionUID = 2555632135770071680L;
    private float lastNumber = Float.NaN;
    private StringBuilder lastString;

    @Override
    public void add(PdfObject pdfObject) {
        if (pdfObject.isNumber()) {
            this.add(((PdfNumber)pdfObject).floatValue());
        } else if (pdfObject instanceof PdfString) {
            this.add(((PdfString)pdfObject).getValueBytes());
        }
    }

    @Override
    public void addAll(PdfArray a) {
        if (a != null) {
            this.addAll(a.list);
        }
    }

    @Override
    public void addAll(Collection<PdfObject> c) {
        for (PdfObject obj : c) {
            this.add(obj);
        }
    }

    public boolean add(float number) {
        if (number != 0.0f) {
            if (!Float.isNaN(this.lastNumber)) {
                this.lastNumber = number + this.lastNumber;
                if (this.lastNumber != 0.0f) {
                    this.set(this.size() - 1, new PdfNumber(this.lastNumber));
                } else {
                    this.remove(this.size() - 1);
                }
            } else {
                this.lastNumber = number;
                super.add(new PdfNumber(this.lastNumber));
            }
            this.lastString = null;
            return true;
        }
        return false;
    }

    public boolean add(String text, PdfFont font) {
        return this.add(font.convertToBytes(text));
    }

    public boolean add(byte[] text) {
        return this.add(new PdfString(text).getValue());
    }

    protected boolean add(String text) {
        if (text.length() > 0) {
            if (this.lastString != null) {
                this.lastString.append(text);
                this.set(this.size() - 1, new PdfString(this.lastString.toString()));
            } else {
                this.lastString = new StringBuilder(text);
                super.add(new PdfString(this.lastString.toString()));
            }
            this.lastNumber = Float.NaN;
            return true;
        }
        return false;
    }
}

