/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.html;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.extra.flyingpdf.NoOpProgressMonitor;
import com.atlassian.confluence.extra.flyingpdf.PdfExportProgressMonitor;
import com.atlassian.confluence.extra.flyingpdf.PdfResourceManager;
import com.atlassian.confluence.extra.flyingpdf.config.PdfExportSettingsManager;
import com.atlassian.confluence.extra.flyingpdf.html.AutoFontScaleUtils;
import com.atlassian.confluence.extra.flyingpdf.html.BookmarksBuilder;
import com.atlassian.confluence.extra.flyingpdf.html.ExportHtmlService;
import com.atlassian.confluence.extra.flyingpdf.html.HtmlConverterUtils;
import com.atlassian.confluence.extra.flyingpdf.html.HtmlToDomParser;
import com.atlassian.confluence.extra.flyingpdf.html.LinkFixer;
import com.atlassian.confluence.extra.flyingpdf.html.TocBuilder;
import com.atlassian.confluence.extra.flyingpdf.html.XhtmlBuilder;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.impl.ExportFileNameGenerator;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.ContentNode;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RenderedXhtmlBuilder
implements XhtmlBuilder {
    public static final String MAIN_STYLE_ID = "confluence.flyingpdf.styleId";
    private static final int CHARACTER_PER_LINE = Integer.getInteger("confluence.flyingpdf.default.characters.per.line", 80);
    private static final Logger LOG = Logger.getLogger(RenderedXhtmlBuilder.class);
    private static final Pattern HEADING_PATTERN = Pattern.compile("\\</?h(\\d)(\\>|\\s)");
    private static final String PAGE_TEMPLATE_NAME = "templates/extra/pdfexport/pagehtml.vm";
    private static final String COMPLETE_EXPORT_PAGE_TEMPLATE_NAME = "templates/extra/pdfexport/completeexport.vm";
    private static final String CONFLUENCE_BASE_STYLES = RenderedXhtmlBuilder.loadResource("master.css");
    private Renderer xhtmlRenderer;
    private ExportFileNameGenerator htmlExportFileNameGenerator;
    private SettingsManager settingsManager;
    private PdfExportSettingsManager pdfSettings;
    private PdfResourceManager pdfResourceManager;
    private ExportHtmlService exportHtmlService;

    @Override
    public Document buildHtml(ContentTree contentTree, Space space) throws ImportExportException {
        return this.buildHtml(contentTree, space, false);
    }

    @Override
    public Document buildHtml(ContentTree contentTree, Space space, boolean decorate) throws ImportExportException {
        return this.buildHtml(contentTree, space, decorate, new NoOpProgressMonitor());
    }

    @Override
    public Document buildHtml(ContentTree contentTree, Space space, boolean decorate, PdfExportProgressMonitor progress) throws ImportExportException {
        TocBuilder tocBuilder = new TocBuilder();
        BookmarksBuilder bookmarksBuilder = new BookmarksBuilder();
        List<String> pageHtml = this.renderContentTreeNodes(contentTree.getRootNodes(), tocBuilder, bookmarksBuilder, 0, contentTree, progress);
        LinkFixer linkFixer = new LinkFixer(space.getKey(), this.settingsManager.getGlobalSettings().getBaseUrl());
        this.populateLinkFixer(contentTree, linkFixer);
        return this.buildHtml(pageHtml, space, decorate, tocBuilder, bookmarksBuilder, linkFixer);
    }

    @Override
    public Document buildHtml(BlogPost blogPost, boolean decorate) throws ImportExportException {
        String content = this.renderToHtml((AbstractPage)blogPost, null);
        ImmutableList pageHtml = ImmutableList.of((Object)this.renderPageTemplate(blogPost.getTitle(), 1, content));
        LinkFixer linkFixer = new LinkFixer(blogPost.getSpace().getKey(), this.settingsManager.getGlobalSettings().getBaseUrl());
        return this.buildHtml((List<String>)pageHtml, blogPost.getSpace(), decorate, new TocBuilder(), new BookmarksBuilder(), linkFixer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document buildHtml(List<String> pageHtml, Space space, boolean decorate, TocBuilder tocBuilder, BookmarksBuilder bookmarksBuilder, LinkFixer linkFixer) throws ImportExportException {
        Reader htmlReader = this.createCompleteExportHtml(pageHtml, tocBuilder, space, decorate);
        try {
            HtmlToDomParser domParser = HtmlConverterUtils.getHtmlToXhtmlParser(linkFixer);
            Document xhtmlDocument = domParser.parse(htmlReader);
            this.addTableLayout(xhtmlDocument);
            this.insertBookmarkElement(xhtmlDocument, bookmarksBuilder);
            AutoFontScaleUtils.applyTableScalingLogic(xhtmlDocument);
            Document document = xhtmlDocument;
            return document;
        }
        finally {
            try {
                htmlReader.close();
            }
            catch (IOException ex) {
                LOG.warn((Object)"Exception while closing the intermediate HTML file for reading.");
            }
        }
    }

    private void addTableLayout(Document xhtmlDocument) {
        NodeList tables = xhtmlDocument.getElementsByTagName("table");
        if (tables.getLength() == 0) {
            return;
        }
        for (int tableIndex = 0; tableIndex < tables.getLength(); ++tableIndex) {
            Element table = (Element)tables.item(tableIndex);
            this.fixTableLayout(table);
        }
    }

    private void fixTableLayout(Element table) {
        NodeList headRow = this.getTableHeader(table);
        if (headRow != null && this.rowIsTooLong(headRow)) {
            this.fixTableStyle(table);
            return;
        }
        this.fixTableByBody(table);
    }

    private void fixTableByBody(Element table) {
        Element body = this.getFirstElementByTagName(table, "tbody");
        if (null != body) {
            NodeList children = body.getElementsByTagName("tr");
            for (int index = 0; index < children.getLength(); ++index) {
                Node row = children.item(index);
                if (!this.rowIsTooLong(row.getChildNodes())) continue;
                this.fixTableStyle(table);
                return;
            }
        }
    }

    private Element getFirstElementByTagName(Element element, String tag) {
        NodeList elements = element.getElementsByTagName(tag);
        if (elements.getLength() > 0) {
            return (Element)elements.item(0);
        }
        return null;
    }

    private void fixTableStyle(Element table) {
        table.setAttribute("class", table.getAttribute("class") + " fixedTableLayout");
        Element colGroup = this.getFirstElementByTagName(table, "colgroup");
        if (null != colGroup) {
            NodeList cols = colGroup.getElementsByTagName("col");
            for (int index = 0; index < cols.getLength(); ++index) {
                Element col = (Element)cols.item(index);
                col.removeAttribute("style");
            }
        }
    }

    private boolean rowIsTooLong(NodeList row) {
        int characterCount = 0;
        for (int col = 0; col < row.getLength(); ++col) {
            characterCount += this.getColLength(row.item(col));
        }
        return characterCount > CHARACTER_PER_LINE;
    }

    private int getColLength(Node col) {
        String content = col.getTextContent();
        return content == null ? 0 : content.length();
    }

    private NodeList getTableHeader(Element table) {
        Element header = this.getFirstElementByTagName(table, "thead");
        if (null != header) {
            Element row = this.getFirstElementByTagName(header, "tr");
            return row == null ? null : row.getChildNodes();
        }
        return null;
    }

    private void populateLinkFixer(ContentTree contentTree, LinkFixer linkFixer) {
        List contentNodes = contentTree.getAllContentNodes();
        for (ContentNode node : contentNodes) {
            Page p = node.getPage();
            linkFixer.addPage(p.getIdAsString(), p.getTitle());
        }
    }

    private Reader createCompleteExportHtml(List<String> renderedPages, TocBuilder tocBuilder, Space space, boolean decorate) throws ImportExportException {
        Writer writer;
        RenderOutput output = renderedPages.size() > 1 ? new FileRenderOutput(this.htmlExportFileNameGenerator, "export", "intermediate") : new StringRenderOutput();
        VelocityContext context = this.createCompleteVelocityContext(renderedPages, tocBuilder, space, decorate);
        try {
            writer = output.getOutputWriter();
        }
        catch (IOException ex) {
            throw new ImportExportException("Failed to open output writer for the intermediate HTML file.", (Throwable)ex);
        }
        try {
            this.exportHtmlService.renderTemplateWithoutSwallowingErrors(COMPLETE_EXPORT_PAGE_TEMPLATE_NAME, (Context)context, writer);
        }
        catch (Exception ex) {
            throw new ImportExportException("Failure while rendering the templates/extra/pdfexport/completeexport.vm", (Throwable)ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ex) {
                LOG.warn((Object)"Failed to close the intermediate HTML file during PDF export.", (Throwable)ex);
            }
        }
        try {
            return output.getResultReader();
        }
        catch (IOException ex) {
            throw new ImportExportException("Failed to open the intermediate HTML file for reading.");
        }
    }

    private VelocityContext createCompleteVelocityContext(List<String> renderedPages, TocBuilder tocBuilder, Space currentSpace, boolean decorate) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>(8);
        if (decorate) {
            String header = this.getHeader(currentSpace);
            String footer = this.getFooter(currentSpace);
            String titlePage = this.getTitlePage(currentSpace);
            if (!StringUtils.isEmpty((CharSequence)header)) {
                contextMap.put("headerHtml", header);
            }
            if (!StringUtils.isEmpty((CharSequence)footer)) {
                contextMap.put("footerHtml", footer);
            }
            if (!StringUtils.isEmpty((CharSequence)titlePage)) {
                contextMap.put("titleHtml", titlePage);
            }
        }
        String customStyles = this.getUserStyles(currentSpace);
        String userStyle = CONFLUENCE_BASE_STYLES;
        if (customStyles != null) {
            userStyle = userStyle + customStyles;
        }
        if (!StringUtils.isEmpty((CharSequence)userStyle)) {
            contextMap.put("userStyleHtml", userStyle);
        }
        contextMap.put("styleId", MAIN_STYLE_ID);
        contextMap.put("tocEntries", tocBuilder.getEntries());
        contextMap.put("pdfResourceManager", this.pdfResourceManager);
        contextMap.put("pages", renderedPages);
        return new VelocityContext(contextMap);
    }

    private String getUserStyles(Space currentSpace) {
        String customStyles = this.pdfSettings.getStyle((BandanaContext)new ConfluenceBandanaContext(currentSpace));
        if (StringUtils.isEmpty((CharSequence)customStyles)) {
            customStyles = this.pdfSettings.getStyle((BandanaContext)new ConfluenceBandanaContext());
        }
        if (StringUtils.isNotEmpty((CharSequence)customStyles)) {
            return customStyles;
        }
        return "";
    }

    private String getTitlePage(Space currentSpace) {
        String titlePage = this.pdfSettings.getTitlePage((BandanaContext)new ConfluenceBandanaContext(currentSpace));
        if (StringUtils.isEmpty((CharSequence)titlePage)) {
            titlePage = this.pdfSettings.getTitlePage((BandanaContext)new ConfluenceBandanaContext());
        }
        return titlePage;
    }

    private String getFooter(Space currentSpace) {
        String footer = this.pdfSettings.getFooter((BandanaContext)new ConfluenceBandanaContext(currentSpace));
        if (StringUtils.isEmpty((CharSequence)footer)) {
            footer = this.pdfSettings.getFooter((BandanaContext)new ConfluenceBandanaContext());
        }
        return footer;
    }

    private String getHeader(Space currentSpace) {
        String header = this.pdfSettings.getHeader((BandanaContext)new ConfluenceBandanaContext(currentSpace));
        if (StringUtils.isEmpty((CharSequence)header)) {
            header = this.pdfSettings.getHeader((BandanaContext)new ConfluenceBandanaContext());
        }
        return header;
    }

    private List<String> renderContentTreeNodes(List<ContentNode> nodes, TocBuilder tocBuilder, BookmarksBuilder bookmarksBuilder, int level, ContentTree fullContentTree, PdfExportProgressMonitor progress) throws ImportExportException {
        ArrayList<String> renderedPagesContent = new ArrayList<String>();
        for (ContentNode node : nodes) {
            Page page = node.getPage();
            String renderedHtml = this.renderToHtml(page, level, fullContentTree);
            renderedPagesContent.add(renderedHtml);
            progress.completedExportedHtmlConversionForPage(String.valueOf(page.getId()), page.getTitle());
            tocBuilder.addEntry(level, page.getTitle());
            bookmarksBuilder.beginEntry(page.getTitle());
            List children = node.getChildren();
            if (children != null && !children.isEmpty()) {
                renderedPagesContent.addAll(this.renderContentTreeNodes(children, tocBuilder, bookmarksBuilder, level + 1, fullContentTree, progress));
            }
            bookmarksBuilder.endEntry();
        }
        return renderedPagesContent;
    }

    String renderToHtml(Page page, int currentLevel, ContentTree fullContentTree) throws ImportExportException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Rendering to exported XHTML page id=" + page.getId() + " (" + page.getTitle() + ")"));
        }
        int pageLevel = currentLevel + 1;
        String html = this.renderToHtml((AbstractPage)page, fullContentTree);
        StringBuilder builder = new StringBuilder();
        if (!StringUtils.isBlank((CharSequence)html)) {
            Matcher matcher = HEADING_PATTERN.matcher(html);
            int index = 0;
            while (matcher.find()) {
                builder.append(html.substring(index, matcher.start(1)));
                String levelStr = matcher.group(1);
                int level = Integer.parseInt(levelStr);
                builder.append(level += pageLevel);
                index = matcher.end(1);
            }
            builder.append(html, index, html.length());
        }
        return this.renderPageTemplate(page.getTitle(), pageLevel, builder.toString());
    }

    private String renderToHtml(AbstractPage page, ContentTree fullContentTree) {
        PageContext context = page.toPageContext();
        context.setBaseUrl(this.settingsManager.getGlobalSettings().getBaseUrl());
        context.setOutputType("pdf");
        DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)context);
        if (fullContentTree != null) {
            conversionContext.setContentTree(fullContentTree);
        }
        return this.xhtmlRenderer.render((ContentEntityObject)page, (ConversionContext)conversionContext);
    }

    private String renderPageTemplate(String title, int pageLevel, String content) throws ImportExportException {
        HashMap<String, String> contextMap = new HashMap<String, String>(3);
        contextMap.put("pageTitle", title);
        contextMap.put("pageLevel", String.valueOf(pageLevel));
        contextMap.put("contentHtml", content);
        return VelocityUtils.getRenderedTemplate((String)PAGE_TEMPLATE_NAME, contextMap);
    }

    private void insertBookmarkElement(Document document, BookmarksBuilder builder) {
        List<BookmarksBuilder.BookmarkEntry> topLevelBookmarks = builder.getEntries();
        if (topLevelBookmarks.isEmpty()) {
            return;
        }
        Element bookmarksElement = document.createElement("bookmarks");
        NodeList headList = document.getElementsByTagName("head");
        if (headList.getLength() < 1) {
            return;
        }
        Node headNode = headList.item(0);
        headNode.appendChild(bookmarksElement);
        this.appendBookmarksElement(document, bookmarksElement, topLevelBookmarks);
    }

    private void appendBookmarksElement(Document document, Node parentNode, List<BookmarksBuilder.BookmarkEntry> bookmarkEntries) {
        for (BookmarksBuilder.BookmarkEntry entry : bookmarkEntries) {
            Element bookmarkElement = document.createElement("bookmark");
            bookmarkElement.setAttribute("name", entry.getTitle());
            bookmarkElement.setAttribute("href", "#" + entry.getTitle());
            parentNode.appendChild(bookmarkElement);
            if (!entry.hasChildEntries()) continue;
            this.appendBookmarksElement(document, bookmarkElement, entry.getChildEntries());
        }
    }

    public void setViewRenderer(Renderer xhtmlRenderer) {
        this.xhtmlRenderer = xhtmlRenderer;
    }

    public void setHtmlExportFileNameGenerator(ExportFileNameGenerator htmlExportFileNameGenerator) {
        this.htmlExportFileNameGenerator = htmlExportFileNameGenerator;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setPdfExportSettingsManager(PdfExportSettingsManager pdfSettings) {
        this.pdfSettings = pdfSettings;
    }

    public void setPdfResourceManager(PdfResourceManager pdfResourceManager) {
        this.pdfResourceManager = pdfResourceManager;
    }

    public void setExportHtmlService(ExportHtmlService exportHtmlService) {
        this.exportHtmlService = exportHtmlService;
    }

    private static String loadResource(String masterCSSResourceName) {
        try {
            InputStream in = RenderedXhtmlBuilder.class.getResourceAsStream("/templates/extra/pdfexport/" + masterCSSResourceName);
            String ret = IOUtils.toString((InputStream)in, (String)"ASCII");
            IOUtils.closeQuietly((InputStream)in);
            return ret;
        }
        catch (Throwable t) {
            LOG.error((Object)"Unable to load the default styles for PDF export", t);
            return "";
        }
    }

    private static class StringRenderOutput
    implements RenderOutput {
        private final StringWriter writer = new StringWriter();

        private StringRenderOutput() {
        }

        @Override
        public Writer getOutputWriter() throws IOException {
            return this.writer;
        }

        @Override
        public Reader getResultReader() throws IOException {
            return new StringReader(this.writer.getBuffer().toString());
        }
    }

    private static class FileRenderOutput
    implements RenderOutput {
        private final File outputFile;

        FileRenderOutput(ExportFileNameGenerator fileNameGenerator, String ... distinguishers) throws ImportExportException {
            try {
                this.outputFile = fileNameGenerator.getExportFile(distinguishers);
            }
            catch (IOException ex) {
                throw new ImportExportException("Failed to create output file during PDF export.");
            }
        }

        @Override
        public Writer getOutputWriter() throws IOException {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "UTF8"));
        }

        @Override
        public Reader getResultReader() throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.outputFile), "UTF8"));
        }
    }

    private static interface RenderOutput {
        public Writer getOutputWriter() throws IOException;

        public Reader getResultReader() throws IOException;
    }
}

