/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.html;

import com.atlassian.renderer.util.UrlUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class LinkFixer {
    private HashMap<String, String> pageIdMap;
    private HashSet<String> pageSet;
    private String baseUrl;
    private String spaceKey;
    private Pattern displayPattern = Pattern.compile("/display/([a-zA-Z0-9]+)/([^/\\?]+)(\\?|\\z)");

    public LinkFixer(String spaceKey, String baseUrl) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        this.spaceKey = spaceKey;
        this.pageIdMap = new HashMap();
        this.pageSet = new HashSet();
    }

    public void addPage(String pageId, String pageTitle) {
        this.pageIdMap.put(pageId, pageTitle);
        this.pageSet.add(pageTitle);
    }

    public String convertLink(String url) {
        boolean isOnThisServer;
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        boolean isRelative = url.trim().charAt(0) == '/';
        boolean bl = isOnThisServer = isRelative || url.startsWith(this.baseUrl);
        if (!isOnThisServer) {
            return null;
        }
        Matcher matcher = this.displayPattern.matcher(url);
        matcher.reset();
        if (matcher.find()) {
            String key = matcher.group(1);
            String pageTitle = this.decodeTitle(matcher.group(2));
            if (key != null && key.equalsIgnoreCase(this.spaceKey) && pageTitle != null && this.pageSet.contains(pageTitle)) {
                return "#" + pageTitle;
            }
        } else {
            int pagesIdx = url.indexOf("/pages/viewpage.action?");
            if (pagesIdx != -1) {
                Map queryParams = UrlUtil.getQueryParameters((String)url);
                String key = (String)queryParams.get("spaceKey");
                String title = this.decodeTitle((String)queryParams.get("pageTitle"));
                String pageId = (String)queryParams.get("pageId");
                if (pageId != null ? (title = this.pageIdMap.get(pageId)) != null : key != null && key.equalsIgnoreCase(this.spaceKey) && title != null && this.pageSet.contains(title)) {
                    return "#" + title;
                }
            }
        }
        return null;
    }

    private String decodeTitle(String title) {
        if (title == null) {
            return title;
        }
        try {
            return URLDecoder.decode(title, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return title;
        }
    }
}

