/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.config;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.extra.flyingpdf.config.PdfExportSettingsManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class DefaultPdfExportSettingsManager
implements PdfExportSettingsManager {
    private static final String STYLESHEET_KEY = "com.atlassian.confluence.extra.flyingpdf.config.style";
    private static final String TITLEPAGE_KEY = "com.atlassian.confluence.extra.flyingpdf.config.titlepage";
    private static final String HEADER_KEY = "com.atlassian.confluence.extra.flyingpdf.config.header";
    private static final String FOOTER_KEY = "com.atlassian.confluence.extra.flyingpdf.config.footer";
    private static final Logger log = Logger.getLogger(DefaultPdfExportSettingsManager.class);
    private BandanaManager bandanaManager;

    @Override
    public String getStyle(BandanaContext context) {
        return (String)this.bandanaManager.getValue(context, STYLESHEET_KEY);
    }

    @Override
    public void setStyle(BandanaContext context, String value) {
        value = this.nullOutIfEmpty(value);
        this.bandanaManager.setValue(context, STYLESHEET_KEY, (Object)value);
    }

    @Override
    public String getFooter(BandanaContext context) {
        return (String)this.bandanaManager.getValue(context, FOOTER_KEY);
    }

    @Override
    public String getHeader(BandanaContext context) {
        return (String)this.bandanaManager.getValue(context, HEADER_KEY);
    }

    @Override
    public String getTitlePage(BandanaContext context) {
        return (String)this.bandanaManager.getValue(context, TITLEPAGE_KEY);
    }

    @Override
    public void setFooter(BandanaContext context, String value) {
        value = this.nullOutIfEmpty(value);
        this.bandanaManager.setValue(context, FOOTER_KEY, (Object)value);
    }

    @Override
    public void setHeader(BandanaContext context, String value) {
        value = this.nullOutIfEmpty(value);
        this.bandanaManager.setValue(context, HEADER_KEY, (Object)value);
    }

    @Override
    public void setTitlePage(BandanaContext context, String value) {
        value = this.nullOutIfEmpty(value);
        this.bandanaManager.setValue(context, TITLEPAGE_KEY, (Object)value);
    }

    public void setBandanaManager(BandanaManager bandana) {
        this.bandanaManager = bandana;
    }

    private String nullOutIfEmpty(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = null;
        }
        return value;
    }
}

