/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf;

import com.google.common.base.Supplier;
import com.itextpdf.text.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.IOUtils;
import org.xhtmlrenderer.pdf.ITextFSImage;

public class LightITextFSImage
extends ITextFSImage {
    private final Supplier<InputStream> imgStreamSupplier;
    private int width;
    private int height;

    public LightITextFSImage(Supplier<InputStream> imgStreamSupplier, float dotsPerPixel) throws IOException {
        super(null);
        this.imgStreamSupplier = imgStreamSupplier;
        this.updateMeasurements(dotsPerPixel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMeasurements(float dotsPerPixel) throws IOException {
        block11: {
            InputStream imgStream = (InputStream)this.imgStreamSupplier.get();
            try (ImageInputStream in = ImageIO.createImageInputStream(imgStream);){
                Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
                if (readers.hasNext()) {
                    ImageReader reader = readers.next();
                    try {
                        reader.setInput(in);
                        this.width = (int)(dotsPerPixel * (float)reader.getWidth(0));
                        this.height = (int)(dotsPerPixel * (float)reader.getHeight(0));
                        break block11;
                    }
                    finally {
                        reader.dispose();
                    }
                }
                throw new IOException("Unknown image format");
            }
            finally {
                IOUtils.closeQuietly((InputStream)imgStream);
            }
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void scale(int width, int height) {
        int targetWidth = width;
        int targetHeight = height;
        if (targetWidth == -1) {
            targetWidth = (int)((double)this.getWidth() * ((double)targetHeight / (double)this.getHeight()));
        }
        if (targetHeight == -1) {
            targetHeight = (int)((double)this.getHeight() * ((double)targetWidth / (double)this.getWidth()));
        }
        this.width = targetWidth;
        this.height = targetHeight;
    }

    @Override
    public Image getImage() {
        InputStream imgStream = (InputStream)this.imgStreamSupplier.get();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)imgStream, (OutputStream)out);
            byte[] imgBuf = out.toByteArray();
            Image image = Image.getInstance(imgBuf);
            image.scaleAbsolute(this.width, this.height);
            Image image2 = image;
            return image2;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read image", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)imgStream);
        }
    }
}

