/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf;

import com.atlassian.confluence.api.impl.service.content.factory.SpaceFactory;
import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.core.service.NotAuthorizedException;
import com.atlassian.confluence.extra.flyingpdf.NoOpProgressMonitor;
import com.atlassian.confluence.extra.flyingpdf.PdfExportProgressMonitor;
import com.atlassian.confluence.extra.flyingpdf.PdfExporterService;
import com.atlassian.confluence.extra.flyingpdf.XmlToPdfConverter;
import com.atlassian.confluence.extra.flyingpdf.html.XhtmlBuilder;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.ContentNode;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.User;
import com.atlassian.util.profiling.UtilTimerStack;
import java.io.File;
import java.io.FileNotFoundException;
import org.w3c.dom.Document;

public class FlyingSaucerPdfExporterService
implements PdfExporterService {
    private ImportExportManager importExportManager;
    private XhtmlBuilder intermediateHtmlBuilder;
    private XmlToPdfConverter flyingPdfDocumentConverter;
    private PermissionManager permissionManager;
    private SpaceService apiSpaceService;
    private SpaceFactory spaceFactory;

    @Override
    public File createPdfForSpace(User user, Space space, ContentTree contentTree, String contextPath) throws ImportExportException {
        return this.createPdfForSpace(user, space, contentTree, this.newNoOpProgressMonitor(), contextPath);
    }

    protected NoOpProgressMonitor newNoOpProgressMonitor() {
        return new NoOpProgressMonitor();
    }

    @Override
    public File createPdfForSpace(User user, Space space, ContentTree contentTree, PdfExportProgressMonitor progress, String contextPath) throws ImportExportException {
        this.checkAuthorization(user, space);
        UtilTimerStack.push((String)"intermediateHtmlBuilder.buildHtml");
        Document xhtml = this.intermediateHtmlBuilder.buildHtml(contentTree, space, true, progress);
        UtilTimerStack.pop((String)"intermediateHtmlBuilder.buildHtml");
        contentTree = null;
        String spaceKey = this.getSpaceKeyForExportFileName(space.getKey());
        progress.beginHtmlToPdfConversion();
        return this.flyingPdfDocumentConverter.convertXhtmlToPdf(spaceKey, xhtml, progress, contextPath);
    }

    @Override
    public File createPdfForPage(User user, Page page, String contextPath) throws ImportExportException {
        return this.createPdfForPage(user, (AbstractPage)page, contextPath);
    }

    @Override
    public File createPdfForPage(User user, AbstractPage page, String contextPath) throws ImportExportException {
        File pdf;
        Document xhtml;
        this.checkAuthorization(user, page);
        if (page instanceof Page) {
            ContentTree tree = this.newContentTree();
            tree.addRootNode(new ContentNode((Page)page));
            xhtml = this.intermediateHtmlBuilder.buildHtml(tree, page.getSpace(), false);
        } else if (page instanceof BlogPost) {
            xhtml = this.intermediateHtmlBuilder.buildHtml((BlogPost)page, false);
        } else {
            throw new IllegalArgumentException("Only pages and blog post are supported");
        }
        String spaceKey = this.getSpaceKeyForExportFileName(page.getSpaceKey());
        try {
            String filename = spaceKey + "-" + (page.getTitle() == null ? Long.valueOf(page.getId()) : page.getTitle().replaceAll("\\s", ""));
            if (!GeneralUtil.isSafeTitleForFilesystem((String)filename)) {
                filename = spaceKey + "-" + page.getId();
            }
            pdf = this.flyingPdfDocumentConverter.convertXhtmlToPdf(filename, xhtml, contextPath);
        }
        catch (ImportExportException e) {
            if (e.getCause() instanceof FileNotFoundException) {
                String filename = spaceKey + "-" + page.getId();
                pdf = this.flyingPdfDocumentConverter.convertXhtmlToPdf(filename, xhtml, contextPath);
            }
            throw e;
        }
        return pdf;
    }

    protected ContentTree newContentTree() {
        return new ContentTree();
    }

    @Override
    public ContentTree getContentTree(User user, Space space) {
        return this.importExportManager.getContentTree(user, space);
    }

    @Override
    public boolean isPermitted(User user, AbstractPage page) {
        if (this.isSuperUser(user)) {
            return true;
        }
        return this.permissionManager.hasPermission(user, Permission.VIEW, (Object)page);
    }

    @Override
    public boolean isPermitted(User user, Space space) {
        if (this.isSuperUser(user)) {
            return true;
        }
        return this.permissionManager.hasPermission(user, Permission.EXPORT, (Object)space);
    }

    @Override
    public boolean exportableContentExists(Space space) {
        return space != null && this.apiSpaceService.findContent(this.spaceFactory.buildFrom(space, Expansions.EMPTY), new Expansion[0]).withDepth(Depth.ROOT).fetchMany(ContentType.PAGE, (PageRequest)new SimplePageRequest(0, 10)).size() > 0;
    }

    protected boolean isSuperUser(User user) {
        return GeneralUtil.isSuperUser((User)user);
    }

    private void checkAuthorization(User user, Object target) {
        boolean permitted = false;
        if (target instanceof Space) {
            permitted = this.isPermitted(user, (Space)target);
        } else if (target instanceof AbstractPage) {
            permitted = this.isPermitted(user, (AbstractPage)target);
        }
        if (!permitted) {
            String username = user == null ? "anonymous" : user.getName();
            throw new NotAuthorizedException("The user " + username + " is not permitted to perform this export");
        }
    }

    private String getSpaceKeyForExportFileName(String spaceKey) {
        if (spaceKey.startsWith("~")) {
            spaceKey = spaceKey.substring(1);
        }
        return spaceKey;
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public void setIntermediateHtmlBuilder(XhtmlBuilder intermediateHtmlBuilder) {
        this.intermediateHtmlBuilder = intermediateHtmlBuilder;
    }

    public void setFlyingPdfDocumentConverter(XmlToPdfConverter flyingPdfDocumentConverter) {
        this.flyingPdfDocumentConverter = flyingPdfDocumentConverter;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setApiSpaceService(SpaceService apiSpaceService) {
        this.apiSpaceService = apiSpaceService;
    }

    public void setSpaceFactory(SpaceFactory spaceFactory) {
        this.spaceFactory = spaceFactory;
    }
}

