/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf;

import com.atlassian.confluence.core.persistence.confluence.SessionFactoryTypeEnum;
import com.atlassian.confluence.core.persistence.confluence.SessionFactoryTypeThreadLocal;
import com.atlassian.confluence.extra.flyingpdf.PdfExportSemaphore;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.importexport.impl.ExportFileNameGenerator;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.core.task.longrunning.AbstractLongRunningTask;
import com.atlassian.user.User;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.context.Context;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class ContentTreeLongRunningTask
extends ConfluenceAbstractLongRunningTask {
    private final ImportExportManager importExportManager;
    private final PlatformTransactionManager transactionManager;
    private final I18NBean i18NBean;
    private final Space space;
    private final User user;
    private final GateKeeper gateKeeper;
    private final String contextPath;
    private final ExportFileNameGenerator pdfExportFileNameGenerator;
    private final PdfExportSemaphore pdfExportSemaphore;
    private String downloadPath;

    public ContentTreeLongRunningTask(ImportExportManager importExportManager, PlatformTransactionManager transactionManager, I18NBean i18NBean, Space space, User user, GateKeeper gateKeeper, String contextPath, ExportFileNameGenerator pdfExportFileNameGenerator, PdfExportSemaphore pdfExportSemaphore) {
        this.importExportManager = importExportManager;
        this.transactionManager = transactionManager;
        this.i18NBean = i18NBean;
        this.space = space;
        this.user = user;
        this.gateKeeper = gateKeeper;
        this.contextPath = contextPath;
        this.pdfExportFileNameGenerator = pdfExportFileNameGenerator;
        this.pdfExportSemaphore = pdfExportSemaphore;
    }

    protected void runInternal() {
        if (this.pdfExportSemaphore.acquire()) {
            try {
                this.doRunInternal();
            }
            finally {
                this.pdfExportSemaphore.release();
            }
        } else {
            throw new IllegalStateException(String.format("Too many concurrent exports. %s is max allowed.", PdfExportSemaphore.PERMITS_SIZE));
        }
    }

    private void doRunInternal() {
        SessionFactoryTypeThreadLocal.set((SessionFactoryTypeEnum)SessionFactoryTypeEnum.NON_CACHING);
        try {
            TransactionTemplate tt = new TransactionTemplate();
            tt.setTransactionManager(this.transactionManager);
            tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    try {
                        ContentTreeLongRunningTask.this.initProgress();
                        ContentTree contentTree = ContentTreeLongRunningTask.this.importExportManager.getContentTree(ContentTreeLongRunningTask.this.user, ContentTreeLongRunningTask.this.space);
                        Context context = MacroUtils.createDefaultVelocityContext();
                        context.put("contentTree", (Object)contentTree);
                        File file = ContentTreeLongRunningTask.this.pdfExportFileNameGenerator.getExportFile(new String[]{"confluence.extra.content-tree-builder-"});
                        try (FileWriter writer = new FileWriter(file);){
                            VelocityUtils.writeRenderedTemplate((Writer)writer, (String)"/templates/extra/pdfexport/export-space-common-tree.vm", (Context)context);
                        }
                        ContentTreeLongRunningTask.this.downloadPath = ContentTreeLongRunningTask.this.importExportManager.prepareDownloadPath(file.getAbsolutePath());
                        ContentTreeLongRunningTask.this.gateKeeper.addKey(ContentTreeLongRunningTask.this.downloadPath, ContentTreeLongRunningTask.this.user);
                        ContentTreeLongRunningTask.this.downloadPath = ContentTreeLongRunningTask.this.contextPath + ContentTreeLongRunningTask.this.downloadPath;
                        ContentTreeLongRunningTask.this.updateProgress(ContentTreeLongRunningTask.this.downloadPath);
                    }
                    catch (Exception e) {
                        AbstractLongRunningTask.log.error((Object)"Error during building content tree for PDF export", (Throwable)e);
                        ContentTreeLongRunningTask.this.updateProgress(e);
                    }
                }
            });
        }
        finally {
            SessionFactoryTypeThreadLocal.clear();
        }
    }

    private void updateProgress(Exception e) {
        String exceptionMessage = e.getMessage();
        if (StringUtils.isBlank((CharSequence)exceptionMessage)) {
            exceptionMessage = e.getClass().getName();
        }
        this.progress.setPercentage(100);
        this.progress.setCompletedSuccessfully(false);
        this.progress.setStatus(this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.contenttreeerrored", Arrays.asList(exceptionMessage)));
    }

    private void updateProgress(String downloadPath) {
        this.progress.setPercentage(100);
        this.progress.setCompletedSuccessfully(true);
        this.progress.setStatus(downloadPath);
    }

    private void initProgress() {
        this.progress.setPercentage(0);
        this.progress.setStatus("");
    }

    public String getName() {
        return "Content tree build for PDF export";
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }
}

