/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf;

import com.atlassian.confluence.extra.flyingpdf.LightITextFSImage;
import com.atlassian.confluence.importexport.resource.DownloadResourceManager;
import com.atlassian.confluence.importexport.resource.DownloadResourceNotFoundException;
import com.atlassian.confluence.importexport.resource.DownloadResourceReader;
import com.atlassian.confluence.importexport.resource.UnauthorizedDownloadResourceException;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.renderer.util.UrlUtil;
import com.google.common.base.Supplier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.net.URLCodec;
import org.apache.log4j.Logger;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.ITextUserAgent;
import org.xhtmlrenderer.resource.ImageResource;

public class ConfluenceExportUserAgent
extends ITextUserAgent {
    private static final Logger LOG = Logger.getLogger(ConfluenceExportUserAgent.class);
    private static final String FILE_PREFIX = "file:";
    private static final String DATA_PREFIX = "data:";
    private static final Pattern RESOURCE_PATH_PATTERN = Pattern.compile("/s/(.*)/_/");
    private DownloadResourceManager resourceManager;
    private PluginResourceLocator pluginResourceLocator;
    private final String baseUrl;

    public ConfluenceExportUserAgent(ITextOutputDevice device, String baseUrl, DownloadResourceManager resourceManager, PluginResourceLocator pluginResourceLocator) {
        super(device);
        this.resourceManager = resourceManager;
        this.pluginResourceLocator = pluginResourceLocator;
        this.baseUrl = baseUrl;
    }

    @Override
    public ImageResource getImageResource(final String uri) {
        try {
            return new ImageResource(uri, new LightITextFSImage(new Supplier<InputStream>(){

                public InputStream get() {
                    return ConfluenceExportUserAgent.this.resolveAndOpenStream(uri);
                }
            }, this.getSharedContext().getDotsPerPixel()));
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not retrieve image resource " + uri + " during Confluence export"));
            return new ImageResource(null, null);
        }
    }

    @Override
    protected InputStream resolveAndOpenStream(String uri) {
        String relativeUri = uri;
        if (relativeUri.startsWith(FILE_PREFIX)) {
            relativeUri = relativeUri.substring(FILE_PREFIX.length());
        } else if (relativeUri.startsWith(this.baseUrl)) {
            relativeUri = relativeUri.substring(this.baseUrl.length());
        }
        Matcher matcher = RESOURCE_PATH_PATTERN.matcher(relativeUri);
        String decodedUri = relativeUri = matcher.replaceFirst("/");
        try {
            decodedUri = URLDecoder.decode(relativeUri, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)("Can't decode uri" + uri), (Throwable)e);
        }
        if (this.pluginResourceLocator.matches(decodedUri)) {
            Map queryParams = UrlUtil.getQueryParameters((String)decodedUri);
            decodedUri = this.stripQueryString(decodedUri);
            DownloadableResource resource = this.pluginResourceLocator.getDownloadableResource(decodedUri, queryParams);
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                resource.streamResource((OutputStream)outputStream);
                return new ByteArrayInputStream(outputStream.toByteArray());
            }
            catch (DownloadException ex) {
                LOG.error((Object)"Unable to serve plugin resource to pdf export", (Throwable)ex);
            }
        } else if (this.resourceManager.matches(decodedUri)) {
            String userName = AuthenticatedUserThreadLocal.getUsername();
            DownloadResourceReader downloadResourceReader = null;
            String strippedUri = this.stripQueryString(decodedUri);
            downloadResourceReader = this.getResourceReader(decodedUri, userName, strippedUri);
            if (downloadResourceReader == null) {
                strippedUri = this.stripQueryString(relativeUri);
                downloadResourceReader = this.getResourceReader(relativeUri, userName, strippedUri);
            }
            if (downloadResourceReader != null) {
                try {
                    return downloadResourceReader.getStreamForReading();
                }
                catch (Exception e) {
                    LOG.warn((Object)("Could retrieve image resource " + decodedUri + " during Confluence export"));
                }
            }
        } else if (uri.startsWith(DATA_PREFIX)) {
            return this.streamDataUrl(uri);
        }
        return super.resolveAndOpenStream(uri);
    }

    private InputStream streamDataUrl(String dataUrl) {
        byte[] bytes;
        int dataIndex = dataUrl.indexOf(44);
        String data = dataUrl.substring(dataIndex + 1);
        if (dataUrl.substring(0, dataIndex).endsWith(";base64")) {
            bytes = Base64.decodeBase64((String)data);
        } else {
            try {
                bytes = URLCodec.decodeUrl((byte[])StringUtils.getBytesUsAscii((String)data));
            }
            catch (DecoderException e) {
                throw new IllegalArgumentException("Invalid data URL: \"" + dataUrl + "\".", e);
            }
        }
        return new ByteArrayInputStream(bytes);
    }

    private DownloadResourceReader getResourceReader(String uri, String userName, String strippedUri) {
        DownloadResourceReader downloadResourceReader = null;
        try {
            downloadResourceReader = this.resourceManager.getResourceReader(userName, strippedUri, UrlUtil.getQueryParameters((String)uri));
        }
        catch (UnauthorizedDownloadResourceException ex) {
            LOG.debug((Object)("Not authorized to download resource " + uri), (Throwable)ex);
        }
        catch (DownloadResourceNotFoundException ex) {
            LOG.debug((Object)("No resource found for url " + uri), (Throwable)ex);
        }
        return downloadResourceReader;
    }

    private String stripQueryString(String uri) {
        int queryIndex = uri.indexOf(63);
        if (queryIndex > 0) {
            uri = uri.substring(0, queryIndex);
        }
        return uri;
    }
}

