/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf;

import com.atlassian.confluence.extra.flyingpdf.PdfExportLongRunningTask;
import com.atlassian.confluence.extra.flyingpdf.PdfExportLongRunningTaskFactory;
import com.atlassian.confluence.extra.flyingpdf.PdfExporterService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.user.User;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.collect.Lists;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class BetterExportSpaceAction
extends AbstractSpaceAction
implements ServletRequestAware {
    protected HttpServletRequest servletRequest;
    protected PdfExportLongRunningTaskFactory pdfExportLongRunningTaskFactory;
    protected PdfExporterService flyingPdfExporterService;
    protected LongRunningTaskId taskId;
    protected LongRunningTaskManager longRunningTaskManager;
    protected String downloadPath;
    private List<String> contentToBeExported = Lists.newArrayList();
    private ServletContext servletContext;
    private PermissionManager permissionManager;

    public String doExport() throws Exception {
        PdfExportLongRunningTask task = this.pdfExportLongRunningTaskFactory.createNewLongRunningTask(this.getI18n(), this.getContentToBeExported(), this.getSpace(), (User)this.getAuthenticatedUser(), this.servletRequest.getContextPath());
        this.taskId = this.longRunningTaskManager.startLongRunningTask((User)this.getAuthenticatedUser(), (LongRunningTask)task);
        return "success";
    }

    public String execute() throws Exception {
        return this.doExport();
    }

    public boolean isPermitted() {
        UtilTimerStack.push((String)"BetterExportSpaceAction.isPermitted");
        boolean isPermitted = this.flyingPdfExporterService.isPermitted(this.getRemoteUser(), this.getSpace());
        UtilTimerStack.pop((String)"BetterExportSpaceAction.isPermitted");
        return isPermitted;
    }

    public boolean exportableContentExists() {
        UtilTimerStack.push((String)"BetterExportSpaceAction.exportableContentExists");
        boolean containsStuff = this.flyingPdfExporterService.exportableContentExists(this.getSpace());
        UtilTimerStack.pop((String)"BetterExportSpaceAction.exportableContentExists");
        return containsStuff;
    }

    public String getSpaceAdvancedUrl() {
        return "/spaces/viewspacesummary.action?key=" + this.getHelper().getSpaceKey();
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public List<String> getContentToBeExported() {
        return this.contentToBeExported;
    }

    public void setContentToBeExported(List<String> contentToBeExported) {
        this.contentToBeExported = contentToBeExported;
    }

    public boolean isSpaceAdmin() {
        if (GeneralUtil.isSuperUser((User)this.getRemoteUser())) {
            return true;
        }
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, (Object)this.getSpace());
    }

    public ServletContext getServletContext() {
        if (this.servletContext != null) {
            return this.servletContext;
        }
        return ServletActionContext.getServletContext();
    }

    public LongRunningTaskId getTaskId() {
        return this.taskId;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setPdfExportLongRunningTaskFactory(PdfExportLongRunningTaskFactory pdfExportLongRunningTaskFactory) {
        this.pdfExportLongRunningTaskFactory = pdfExportLongRunningTaskFactory;
    }

    public void setServletRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public void setFlyingPdfExporterService(PdfExporterService flyingPdfExporterService) {
        this.flyingPdfExporterService = flyingPdfExporterService;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setLongRunningTaskManager(LongRunningTaskManager longRunningTaskManager) {
        this.longRunningTaskManager = longRunningTaskManager;
    }
}

