/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfWriter;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.parser.FSColor;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.AbstractFormField;
import org.xhtmlrenderer.pdf.ITextFSFont;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.RenderingContext;

public class TextFormField
extends AbstractFormField {
    private static final String FIELD_TYPE = "Text";
    private static final int DEFAULT_SIZE = 15;
    private int _baseline;

    public TextFormField(LayoutContext c, BlockBox box, int cssWidth, int cssHeight) {
        this.initDimensions(c, box, cssWidth, cssHeight);
        float fontSize = box.getStyle().getFSFont(c).getSize2D();
        this._baseline = (int)((float)(this.getHeight() / 2) + fontSize * 0.3f);
    }

    protected void initDimensions(LayoutContext c, BlockBox box, int cssWidth, int cssHeight) {
        if (cssWidth != -1) {
            this.setWidth(cssWidth);
        } else {
            this.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), box.getStyle().getFSFont(c), this.spaces(this.getSize(box.getElement()))));
        }
        if (cssHeight != -1) {
            this.setHeight(cssHeight);
        } else {
            this.setHeight((int)box.getStyle().getLineHeight(c));
        }
    }

    protected String getFieldType() {
        return FIELD_TYPE;
    }

    public void paint(RenderingContext c, ITextOutputDevice outputDevice, BlockBox box) {
        PdfWriter writer = outputDevice.getWriter();
        Element elem = box.getElement();
        PdfFormField field = PdfFormField.createTextField(writer, false, false, this.getMaxLength(elem));
        Rectangle targetArea = outputDevice.createLocalTargetArea(c, box);
        field.setWidget(targetArea, PdfAnnotation.HIGHLIGHT_INVERT);
        field.setFieldName(this.getFieldName(outputDevice, elem));
        field.setBorderStyle(new PdfBorderDictionary(0.0f, 0));
        String value = this.getValue(elem);
        field.setDefaultValueAsString(value);
        field.setValueAsString(value);
        this.createAppearance(c, outputDevice, box, field, value);
        if (this.isReadOnly(elem)) {
            field.setFieldFlags(1);
        }
        writer.addAnnotation(field);
    }

    private void createAppearance(RenderingContext c, ITextOutputDevice outputDevice, BlockBox box, PdfFormField field, String value) {
        PdfWriter writer = outputDevice.getWriter();
        ITextFSFont font = (ITextFSFont)box.getStyle().getFSFont(c);
        PdfContentByte cb = writer.getDirectContent();
        float width = outputDevice.getDeviceLength(this.getWidth());
        float height = outputDevice.getDeviceLength(this.getHeight());
        float fontSize = outputDevice.getDeviceLength(font.getSize2D());
        PdfAppearance tp = cb.createAppearance(width, height);
        PdfAppearance tp2 = (PdfAppearance)tp.getDuplicate();
        tp2.setFontAndSize(font.getFontDescription().getFont(), fontSize);
        FSColor color = box.getStyle().getColor();
        this.setFillColor(tp2, color);
        field.setDefaultAppearanceString(tp2);
        tp.beginVariableText();
        tp.saveState();
        tp.beginText();
        tp.setFontAndSize(font.getFontDescription().getFont(), fontSize);
        this.setFillColor(tp, color);
        tp.setTextMatrix(0.0f, height / 2.0f - fontSize * 0.3f);
        tp.showText(value);
        tp.endText();
        tp.restoreState();
        tp.endVariableText();
        field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, tp);
    }

    private int getSize(Element elem) {
        String sSize = elem.getAttribute("size");
        if (sSize.equals("")) {
            return 15;
        }
        try {
            return Integer.parseInt(sSize.trim());
        }
        catch (NumberFormatException e) {
            return 15;
        }
    }

    private int getMaxLength(Element elem) {
        String sMaxLen = elem.getAttribute("maxlength");
        if (sMaxLen.equals("")) {
            return 0;
        }
        try {
            return Integer.parseInt(sMaxLen.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    protected String getValue(Element e) {
        String result = e.getAttribute("value");
        if (result.trim().equals("")) {
            return "";
        }
        return result;
    }

    public int getBaseline() {
        return this._baseline;
    }

    public boolean hasBaseline() {
        return true;
    }
}

