/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.html;

import com.atlassian.confluence.extra.flyingpdf.NoOpProgressMonitor;
import com.atlassian.confluence.extra.flyingpdf.PdfExportProgressMonitor;
import com.atlassian.confluence.extra.flyingpdf.config.PdfExportSettingsManager;
import com.atlassian.confluence.extra.flyingpdf.html.BookmarksBuilder;
import com.atlassian.confluence.extra.flyingpdf.html.HtmlConverterUtils;
import com.atlassian.confluence.extra.flyingpdf.html.HtmlToDomParser;
import com.atlassian.confluence.extra.flyingpdf.html.LinkFixer;
import com.atlassian.confluence.extra.flyingpdf.html.PdfExportLinkFormatter;
import com.atlassian.confluence.extra.flyingpdf.html.TocBuilder;
import com.atlassian.confluence.extra.flyingpdf.html.XhtmlBuilder;
import com.atlassian.confluence.importexport.DefaultExportContext;
import com.atlassian.confluence.importexport.ExportContext;
import com.atlassian.confluence.importexport.ExportLinkFormatter;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.impl.ExportFileNameGenerator;
import com.atlassian.confluence.importexport.impl.ExportLinkRenderer;
import com.atlassian.confluence.pages.ContentNode;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.renderer.IconManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.links.LinkRenderer;
import com.atlassian.renderer.v2.SubRenderer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderedXhtmlBuilder
implements XhtmlBuilder {
    public static String MAIN_STYLE_ID = "confluence.flyingpdf.styleId";
    private static final Logger LOG = Logger.getLogger(RenderedXhtmlBuilder.class);
    private static final Pattern HEADING_PATTERN = Pattern.compile("\\</?h(\\d)(\\>|\\s)");
    private static final String PAGE_TEMPLATE_NAME = "templates/extra/pdfexport/pagehtml.vm";
    private static final String COMPLETE_EXPORT_PAGE_TEMPLATE_NAME = "templates/extra/pdfexport/completeexport.vm";
    private static String CONFLUENCE_BASE_STYLES = "";
    private WikiStyleRenderer wikiStyleRenderer;
    private IconManager iconManager;
    private PageManager pageManager;
    private SubRenderer subRenderer;
    private WebResourceManager webResourceManager;
    private ExportFileNameGenerator htmlExportFileNameGenerator;
    private SettingsManager settingsManager;
    private PdfExportSettingsManager pdfSettings;

    @Override
    public Document buildHtml(ContentTree contentTree, Space space) throws ImportExportException {
        return this.buildHtml(contentTree, space, false);
    }

    @Override
    public Document buildHtml(ContentTree contentTree, Space space, boolean decorate) throws ImportExportException {
        return this.buildHtml(contentTree, space, decorate, new NoOpProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document buildHtml(ContentTree contentTree, Space space, boolean decorate, PdfExportProgressMonitor progress) throws ImportExportException {
        TocBuilder tocBuilder = new TocBuilder();
        BookmarksBuilder bookmarksBuilder = new BookmarksBuilder();
        List<String> pageHtml = this.renderContentTreeNodes(contentTree.getRootNodes(), tocBuilder, bookmarksBuilder, 0, contentTree, progress);
        LinkFixer linkFixer = new LinkFixer(space.getKey(), this.settingsManager.getGlobalSettings().getBaseUrl());
        this.populateLinkFixer(contentTree, linkFixer);
        Reader htmlReader = this.createCompleteExportHtml(pageHtml, tocBuilder, bookmarksBuilder, space, decorate);
        try {
            HtmlToDomParser domParser = HtmlConverterUtils.getHtmlToXhtmlParser(linkFixer);
            Document document = domParser.parse(htmlReader);
            return document;
        }
        finally {
            try {
                htmlReader.close();
            }
            catch (IOException ex) {
                LOG.warn((Object)"Exception while closing the intermediate HTML file for reading.");
            }
        }
    }

    private void populateLinkFixer(ContentTree contentTree, LinkFixer linkFixer) {
        List contentNodes = contentTree.getAllContentNodes();
        for (Object object : contentNodes) {
            ContentNode node = (ContentNode)object;
            Page p = node.getPage();
            linkFixer.addPage(p.getIdAsString(), p.getTitle());
        }
    }

    private Reader createCompleteExportHtml(List<String> renderedPages, TocBuilder tocBuilder, BookmarksBuilder bookmarksBuilder, Space space, boolean decorate) throws ImportExportException {
        Writer writer;
        RenderOutput output = renderedPages.size() > 1 ? new FileRenderOutput(this.htmlExportFileNameGenerator, "export", "intermediate") : new StringRenderOutput();
        VelocityContext context = this.createCompleteVelocityContext(renderedPages, tocBuilder, bookmarksBuilder, space, decorate);
        try {
            writer = output.getOutputWriter();
        }
        catch (IOException ex) {
            throw new ImportExportException("Failed to open output writer for the intermediate HTML file.", (Throwable)ex);
        }
        try {
            VelocityUtils.renderTemplateWithoutSwallowingErrors((String)COMPLETE_EXPORT_PAGE_TEMPLATE_NAME, (Context)context, (Writer)writer);
        }
        catch (Exception ex) {
            throw new ImportExportException("Failure while rendering the templates/extra/pdfexport/completeexport.vm", (Throwable)ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ex) {
                LOG.warn((Object)"Failed to close the intermediate HTML file during PDF export.", (Throwable)ex);
            }
        }
        try {
            return output.getResultReader();
        }
        catch (IOException ex) {
            throw new ImportExportException("Failed to open the intermediate HTML file for reading.");
        }
    }

    private VelocityContext createCompleteVelocityContext(List<String> renderedPages, TocBuilder tocBuilder, BookmarksBuilder bookmarksBuilder, Space currentSpace, boolean decorate) {
        String userStyle;
        HashMap<String, Object> contextMap = new HashMap<String, Object>(7);
        if (decorate) {
            String header = this.pdfSettings.getHeader(currentSpace);
            String footer = this.pdfSettings.getFooter(currentSpace);
            String titlePage = this.pdfSettings.getTitlePage(currentSpace);
            if (!StringUtils.isEmpty((String)header)) {
                contextMap.put("header", this.pdfSettings.getHeader(currentSpace));
            }
            if (!StringUtils.isEmpty((String)footer)) {
                contextMap.put("footer", footer);
            }
            if (!StringUtils.isEmpty((String)titlePage)) {
                contextMap.put("title", titlePage);
            }
        }
        if (!StringUtils.isEmpty((String)(userStyle = CONFLUENCE_BASE_STYLES + this.pdfSettings.getStyle(currentSpace)))) {
            contextMap.put("userStyle", userStyle);
        }
        contextMap.put("styleId", MAIN_STYLE_ID);
        contextMap.put("tocEntries", tocBuilder.getEntries());
        contextMap.put("webResourceManager", this.webResourceManager);
        contextMap.put("bookmarkEntries", bookmarksBuilder.getEntries());
        contextMap.put("pages", renderedPages);
        return new VelocityContext(contextMap);
    }

    private List<String> renderContentTreeNodes(List nodes, TocBuilder tocBuilder, BookmarksBuilder bookmarksBuilder, int level, ContentTree fullContentTree, PdfExportProgressMonitor progress) throws ImportExportException {
        ArrayList<String> renderedPagesContent = new ArrayList<String>();
        for (int x = 0; x < nodes.size(); ++x) {
            ContentNode node = (ContentNode)nodes.get(x);
            Page page = node.getPage();
            String renderedHtml = this.renderToHtml(page, level, fullContentTree);
            renderedPagesContent.add(renderedHtml);
            progress.completedWikiToHtmlConversionForPage(String.valueOf(page.getId()), page.getTitle());
            tocBuilder.addEntry(level, page.getTitle());
            bookmarksBuilder.beginEntry(page.getTitle());
            List children = node.getChildren();
            if (children != null && !children.isEmpty()) {
                renderedPagesContent.addAll(this.renderContentTreeNodes(children, tocBuilder, bookmarksBuilder, level + 1, fullContentTree, progress));
            }
            bookmarksBuilder.endEntry();
        }
        return renderedPagesContent;
    }

    String renderToHtml(Page page, int currentLevel, ContentTree fullContentTree) throws ImportExportException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Rendering to XHTML page id=" + page.getId() + " (" + page.getTitle() + ")"));
        }
        String wikiTxt = page.getContent();
        PageContext context = page.toPageContext();
        context.setBaseUrl(this.settingsManager.getGlobalSettings().getBaseUrl());
        DefaultExportContext exportContext = new DefaultExportContext();
        exportContext.setContentTree(fullContentTree);
        context.setLinkRenderer((LinkRenderer)new ExportLinkRenderer(this.subRenderer, (ExportContext)exportContext, this.iconManager, this.pageManager, (ExportLinkFormatter)PdfExportLinkFormatter.getInstance()));
        context.setOutputType("pdf");
        int pageLevel = currentLevel + 1;
        String wikiHtml = this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, wikiTxt);
        StringBuilder builder = new StringBuilder();
        if (!StringUtils.isBlank((String)wikiHtml)) {
            Matcher matcher = HEADING_PATTERN.matcher(wikiHtml);
            int index = 0;
            while (matcher.find()) {
                builder.append(wikiHtml.substring(index, matcher.start(1)));
                String levelStr = matcher.group(1);
                int level = Integer.parseInt(levelStr);
                builder.append(level += pageLevel);
                index = matcher.end(1);
            }
            builder.append(wikiHtml, index, wikiHtml.length());
        }
        return this.renderPageTemplate(page.getTitle(), pageLevel, builder.toString());
    }

    private String renderPageTemplate(String title, int pageLevel, String content) throws ImportExportException {
        HashMap<String, String> contextMap = new HashMap<String, String>(3);
        contextMap.put("pageTitle", title);
        contextMap.put("pageLevel", String.valueOf(pageLevel));
        contextMap.put("content", content);
        return VelocityUtils.getRenderedTemplate((String)PAGE_TEMPLATE_NAME, contextMap);
    }

    public void setPageManager(PageManager manager) {
        this.pageManager = manager;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setSubRenderer(SubRenderer renderer) {
        this.subRenderer = renderer;
    }

    public void setIconManager(IconManager iconManager) {
        this.iconManager = iconManager;
    }

    public void setWebResourceManager(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    public void setHtmlExportFileNameGenerator(ExportFileNameGenerator htmlExportFileNameGenerator) {
        this.htmlExportFileNameGenerator = htmlExportFileNameGenerator;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setPdfExportSettingsManager(PdfExportSettingsManager pdfSettings) {
        this.pdfSettings = pdfSettings;
    }

    static {
        try {
            InputStream in = RenderedXhtmlBuilder.class.getResourceAsStream("/templates/extra/pdfexport/master.css");
            CONFLUENCE_BASE_STYLES = IOUtils.toString((InputStream)in, (String)"ASCII");
            IOUtils.closeQuietly((InputStream)in);
        }
        catch (Throwable t) {
            LOG.error((Object)"Unable to load the default styles for PDF export", t);
        }
    }

    private static class StringRenderOutput
    implements RenderOutput {
        private final StringWriter writer = new StringWriter();

        private StringRenderOutput() {
        }

        public Writer getOutputWriter() throws IOException {
            return this.writer;
        }

        public Reader getResultReader() throws IOException {
            return new StringReader(this.writer.getBuffer().toString());
        }
    }

    private static class FileRenderOutput
    implements RenderOutput {
        private final File outputFile;

        FileRenderOutput(ExportFileNameGenerator fileNameGenerator, String ... distinguishers) throws ImportExportException {
            try {
                this.outputFile = fileNameGenerator.getExportFile(distinguishers);
            }
            catch (IOException ex) {
                throw new ImportExportException("Failed to create output file during PDF export.");
            }
        }

        public Writer getOutputWriter() throws IOException {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "UTF8"));
        }

        public Reader getResultReader() throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.outputFile), "UTF8"));
        }
    }

    private static interface RenderOutput {
        public Writer getOutputWriter() throws IOException;

        public Reader getResultReader() throws IOException;
    }
}

