/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf;

import com.atlassian.confluence.extra.flyingpdf.PdfExportProgressMonitor;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.core.util.ProgressMeter;

public class ProgressMeterWrappingProgressMonitor
implements PdfExportProgressMonitor {
    private static final int CONTENT_TREE_CALCULATION_PERCENTAGE = 4;
    private static final int HTML_CONVERSION_PERCENTAGE = 46;
    private final I18NBean i18NBean;
    private final ProgressMeter progressMeter;
    private int numberOfPages;
    private int convertedPageCount = 0;

    public ProgressMeterWrappingProgressMonitor(I18NBean bean, ProgressMeter progressMeter) {
        this.i18NBean = bean;
        this.progressMeter = progressMeter;
    }

    public void started() {
        this.progressMeter.setPercentage(0);
        this.progressMeter.setStatus(this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.started"));
    }

    public void beginCalculationOfContentTree() {
        this.progressMeter.setStatus(this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.calculatecontenttree"));
    }

    public void completedCalculationOfContentTree(int numberOfPages) {
        this.numberOfPages = numberOfPages;
        this.progressMeter.setStatus(this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.contenttreecalculated"));
        this.progressMeter.setPercentage(4);
    }

    public void completedWikiToHtmlConversionForPage(String pageId, String pageTitle) {
        ++this.convertedPageCount;
        float percentageComplete = (float)(this.convertedPageCount * 100) / (float)this.numberOfPages;
        float weightedPercentageComplete = 0.46f * percentageComplete + 4.0f;
        this.progressMeter.setPercentage((int)weightedPercentageComplete);
        String message = this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.pageConvertedToHtml", (Object[])new String[]{String.valueOf(this.convertedPageCount), String.valueOf(this.numberOfPages)});
        this.progressMeter.setStatus(message);
    }

    public void beginHtmlToPdfConversion() {
        this.convertedPageCount = 0;
        this.progressMeter.setPercentage(50);
        this.progressMeter.setStatus(this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.beginhtmltopdf"));
    }

    public void performingHtmlToPdfConversionForPage(String pageTitle) {
        ++this.convertedPageCount;
        float percentageComplete = (float)(this.convertedPageCount * 100) / (float)this.numberOfPages;
        float weightedPercentageComplete = 0.5f * percentageComplete + 4.0f + 46.0f;
        int calculatedPercentage = (int)weightedPercentageComplete;
        if (calculatedPercentage == 100) {
            calculatedPercentage = 99;
        }
        this.progressMeter.setPercentage(calculatedPercentage);
        String message = this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.pageConvertedToPdf", (Object[])new String[]{String.valueOf(this.convertedPageCount), String.valueOf(this.numberOfPages)});
        this.progressMeter.setStatus(message);
    }

    public void completed(String downloadPath) {
        this.progressMeter.setCompletedSuccessfully(true);
        this.progressMeter.setStatus(this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.completed", (Object[])new String[]{downloadPath}));
        this.progressMeter.setPercentage(100);
    }

    public void errored(String exceptionMessage) {
        this.progressMeter.setCompletedSuccessfully(false);
        this.progressMeter.setStatus(this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.errored", (Object[])new String[]{exceptionMessage}));
    }
}

