/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf;

import com.atlassian.confluence.extra.flyingpdf.ConfluenceExportUserAgent;
import com.atlassian.confluence.extra.flyingpdf.PdfExportProgressMonitor;
import com.atlassian.confluence.extra.flyingpdf.ProgressMonitoringReplacedElementFactory;
import com.atlassian.confluence.extra.flyingpdf.XmlToPdfConverter;
import com.atlassian.confluence.extra.flyingpdf.config.FontManager;
import com.atlassian.confluence.extra.flyingpdf.html.ConfluenceNamespaceHandler;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.impl.ExportFileNameGenerator;
import com.atlassian.confluence.importexport.resource.DownloadResourceManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.lowagie.text.DocumentException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.springframework.core.io.FileSystemResource;
import org.w3c.dom.Document;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class FlyingSaucerXmlToPdfConverter
implements XmlToPdfConverter {
    public static final String INSTALLED_FONT_FAMILY = "ConfluenceInstalledFont";
    private SettingsManager settingsManager;
    private DownloadResourceManager downloadResourceManager;
    private PluginResourceLocator pluginResourceLocator;
    private FontManager pdfExportFontManager;
    private ExportFileNameGenerator pdfExportFileNameGenerator;

    public File convertXhtmlToPdf(String filenamePrefix, Document xhtml, String contextPath) throws ImportExportException {
        return this.convertXhtmlToPdf(filenamePrefix, xhtml, null, contextPath);
    }

    public File convertXhtmlToPdf(String filenamePrefix, Document xhtml, PdfExportProgressMonitor progress, String contextPath) throws ImportExportException {
        File exportFile;
        try {
            exportFile = this.pdfExportFileNameGenerator.getExportFile(new String[]{filenamePrefix});
        }
        catch (IOException ex) {
            throw new ImportExportException("Failed to create a location and file for the PDF export.", (Throwable)ex);
        }
        File tempDir = exportFile.getParentFile();
        ITextRenderer renderer = this.newITextRenderer();
        ConfluenceExportUserAgent callback = this.newConfluenceExportUserAgent(renderer);
        this.useCustomFontIfConfigured(renderer.getFontResolver());
        renderer.getSharedContext().setUserAgentCallback(callback);
        ProgressMonitoringReplacedElementFactory monitoringFactory = null;
        if (progress != null) {
            ReplacedElementFactory currentFactory = renderer.getSharedContext().getReplacedElementFactory();
            monitoringFactory = new ProgressMonitoringReplacedElementFactory(currentFactory, progress);
            renderer.getSharedContext().setReplacedElementFactory(monitoringFactory);
        }
        callback.setSharedContext(renderer.getSharedContext());
        BufferedOutputStream outstr = null;
        try {
            outstr = new BufferedOutputStream(new FileOutputStream(exportFile));
        }
        catch (FileNotFoundException ex) {
            throw new ImportExportException("Failed to created the output file " + exportFile.getAbsolutePath(), (Throwable)ex);
        }
        String baseUrl = this.getBaseUrl(contextPath);
        ConfluenceNamespaceHandler nsh = new ConfluenceNamespaceHandler(baseUrl);
        try {
            renderer.setDocument(xhtml, null);
            renderer.getSharedContext().setNamespaceHandler(nsh);
            renderer.layout();
            renderer.createPDF(outstr);
        }
        catch (Exception ex) {
            String pageTitle = null;
            if (monitoringFactory != null) {
                pageTitle = monitoringFactory.getLastPageTitle();
            }
            String msg = pageTitle != null ? "Exception thrown while rendering the page '" + pageTitle + "' to the PDF document " + exportFile.getAbsolutePath() : "Exception while rendering the PDF document " + exportFile.getAbsolutePath();
            throw new ImportExportException(msg, (Throwable)ex);
        }
        finally {
            try {
                ((OutputStream)outstr).close();
            }
            catch (IOException ex) {
                throw new ImportExportException("Could not close the export file " + exportFile.getAbsolutePath(), (Throwable)ex);
            }
        }
        return exportFile;
    }

    protected ConfluenceExportUserAgent newConfluenceExportUserAgent(ITextRenderer renderer) {
        return new ConfluenceExportUserAgent(renderer.getOutputDevice(), this.settingsManager.getGlobalSettings().getBaseUrl(), this.downloadResourceManager, this.pluginResourceLocator);
    }

    protected ITextRenderer newITextRenderer() {
        return new ITextRenderer();
    }

    private String getBaseUrl(String contextPath) {
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        int contextIdx = baseUrl.indexOf(contextPath);
        baseUrl = contextIdx != -1 ? baseUrl.substring(0, contextIdx) : "";
        return baseUrl;
    }

    private void useCustomFontIfConfigured(ITextFontResolver fontResolver) throws ImportExportException {
        FileSystemResource fontResource = this.pdfExportFontManager.getInstalledFont();
        if (fontResource == null) {
            return;
        }
        try {
            fontResolver.addFont(fontResource.getPath(), INSTALLED_FONT_FAMILY, "Identity-H", true, null);
        }
        catch (DocumentException ex) {
            throw new ImportExportException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new ImportExportException((Throwable)ex);
        }
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setDownloadResourceManager(DownloadResourceManager downloadResourceManager) {
        this.downloadResourceManager = downloadResourceManager;
    }

    public void setPluginResourceLocator(PluginResourceLocator pluginResourceLocator) {
        this.pluginResourceLocator = pluginResourceLocator;
    }

    public void setPdfExportFontManager(FontManager pdfExportFontManager) {
        this.pdfExportFontManager = pdfExportFontManager;
    }

    public void setPdfExportFileNameGenerator(ExportFileNameGenerator pdfExportFileNameGenerator) {
        this.pdfExportFileNameGenerator = pdfExportFileNameGenerator;
    }
}

