/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf;

import com.atlassian.confluence.extra.flyingpdf.PdfExporterService;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;

public class ExportPageAsPdfAction
extends AbstractPageAwareAction {
    private GateKeeper gateKeeper;
    private String downloadPath;
    private PdfExporterService flyingPdfExporterService;

    public String execute() throws Exception {
        String contextPath = this.getServletRequest().getContextPath();
        File exportedDocument = this.flyingPdfExporterService.createPdfForPage(this.getRemoteUser(), (Page)this.getPage(), contextPath);
        this.downloadPath = this.prepareDownloadPath(exportedDocument.getAbsolutePath());
        if (TextUtils.stringSet((String)this.downloadPath)) {
            this.downloadPath = this.downloadPath.replaceAll("\\\\", "/");
        }
        this.gateKeeper.addKey(this.downloadPath, this.getRemoteUser());
        return "download";
    }

    protected HttpServletRequest getServletRequest() {
        return ServletContextThreadLocal.getRequest();
    }

    public boolean isPermitted() {
        return this.flyingPdfExporterService.isPermitted(this.getRemoteUser(), (Page)this.getPage());
    }

    private String prepareDownloadPath(String path) throws IOException {
        String homeDir = new File(this.getBootstrapManager().getConfluenceHome()).getCanonicalPath();
        String canonicalPath = new File(path).getCanonicalPath();
        int homeDirIndex = canonicalPath.indexOf(homeDir);
        if (homeDirIndex != -1) {
            path = canonicalPath.substring(homeDirIndex + homeDir.length() + 1);
        }
        return "/download/" + path;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public void setFlyingPdfExporterService(PdfExporterService flyingPdfExporterService) {
        this.flyingPdfExporterService = flyingPdfExporterService;
    }
}

