/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.io.PrintWriter;
import java.util.Vector;
import org.xml.sax.helpers.AttributesImpl;
import tdm.lib.BaseNode;
import tdm.lib.BranchNode;
import tdm.lib.Matching;
import tdm.lib.Node;
import tdm.lib.NodeFactory;
import tdm.lib.PathTracker;
import tdm.lib.XMLElementNode;
import tdm.lib.XMLNode;
import tdm.lib.XMLPrinter;
import tdm.lib.XMLTextNode;

public class XMLInlinedMatching
implements Matching {
    protected BaseNode baseRoot = null;
    protected BranchNode branchRoot = null;
    private static NodeFactory baseNodeFactory = new NodeFactory(){

        @Override
        public Node makeNode(XMLNode content) {
            return new BaseNode(content);
        }
    };
    private static NodeFactory branchNodeFactory = new NodeFactory(){

        @Override
        public Node makeNode(XMLNode content) {
            return new BranchNode(content);
        }
    };
    private static final String MATCHING_NS = "m:";
    private static final String MATCHING_ATT_MATCH = "m:match";
    private static final String MATCHING_ATT_TYPE = "m:type";
    private static final String MATCHING_TAG_TEXT = "m:text";
    private static final String[] MATCHING_ATT_TYPES = new String[]{"n", "c", "s", "f"};

    public XMLInlinedMatching() {
    }

    public XMLInlinedMatching(BaseNode abase, BranchNode abranch) {
        this.buildMatching(abase, abranch);
    }

    @Override
    public void buildMatching(BaseNode base, BranchNode branch) {
        this.baseRoot = base;
        this.branchRoot = branch;
        this.doBuildMatching(branch.getChild(0));
        this.branchRoot.setBaseMatch(this.baseRoot, 3);
        this.baseRoot.debugTree(new PrintWriter(System.out), 0);
    }

    protected void doBuildMatching(BranchNode n) {
        XMLNode c = n.getContent();
        if (c instanceof XMLTextNode) {
            throw new RuntimeException("Malformed pre-matched XML document");
        }
        XMLElementNode ce = (XMLElementNode)c;
        String mTypeStr = ce.getAttributes().getValue(MATCHING_ATT_TYPE);
        String path = null;
        int type = -1;
        for (int i = 0; i < MATCHING_ATT_TYPES.length && type == -1; ++i) {
            if (!MATCHING_ATT_TYPES[i].equals(mTypeStr)) continue;
            type = i;
        }
        if (type == -1) {
            throw new RuntimeException("Malformed pre-matched XML document: invalid type " + mTypeStr);
        }
        if (MATCHING_TAG_TEXT.equals(ce.getQName())) {
            path = ce.getAttributes().getValue(MATCHING_ATT_MATCH);
            BranchNode parent = n.getParent();
            if (n.getChildCount() != 1) {
                throw new RuntimeException("Asset failed");
            }
            n.setContent(n.getChild(0).getContent());
            n.removeChildren();
        } else {
            path = ce.getAttributes().getValue(MATCHING_ATT_MATCH);
            AttributesImpl atts = (AttributesImpl)ce.getAttributes();
            atts.removeAttribute(atts.getIndex(MATCHING_ATT_TYPE));
            if (type > 0) {
                atts.removeAttribute(atts.getIndex(MATCHING_ATT_MATCH));
            }
            ce.rehash();
        }
        if (type > 0) {
            BaseNode baseMatch = (BaseNode)PathTracker.followPath(this.baseRoot, path);
            n.setBaseMatch(baseMatch, type);
            baseMatch.getLeft().addMatch(n);
        }
        for (int i = 0; i < n.getChildCount(); ++i) {
            this.doBuildMatching(n.getChild(i));
        }
    }

    @Override
    public void getAreaStopNodes(Vector stopNodes, BranchNode n) {
        throw new NoSuchMethodError("Not implemented");
    }

    @Override
    public BaseNode getBaseRoot() {
        return this.baseRoot;
    }

    @Override
    public BranchNode getBranchRoot() {
        return this.branchRoot;
    }

    @Override
    public NodeFactory getBaseNodeFactory() {
        return baseNodeFactory;
    }

    @Override
    public NodeFactory getBranchNodeFactory() {
        return branchNodeFactory;
    }

    public static void dumpXMLWithMatchings(BranchNode root, XMLPrinter p) {
        XMLInlinedMatching.dumpXMLWithMatchings(root, p, Integer.MAX_VALUE);
    }

    public static void dumpXMLWithMatchings(BranchNode root, XMLPrinter p, int levels) {
        p.startDocument();
        XMLInlinedMatching.doDumpXMLWithMatchings(root, p, levels);
        p.endDocument();
    }

    protected static void doDumpXMLWithMatchings(BranchNode n, XMLPrinter p, int levels) {
        XMLNode c = n.getContent();
        AttributesImpl atts = new AttributesImpl();
        if (c instanceof XMLTextNode) {
            XMLInlinedMatching.setMatchAttribs(n, atts);
            XMLTextNode ct = (XMLTextNode)c;
            p.startElement("", "", MATCHING_TAG_TEXT, atts);
            p.characters(ct.getText(), 0, ct.getText().length);
            p.endElement("", "", MATCHING_TAG_TEXT);
        } else {
            XMLElementNode ce = (XMLElementNode)c;
            if (ce.getAttributes().getLength() > 0) {
                atts.setAttributes(ce.getAttributes());
            }
            XMLInlinedMatching.setMatchAttribs(n, atts);
            p.startElement(ce.getNamespaceURI(), ce.getLocalName(), ce.getQName(), atts);
            for (int i = 0; levels > 0 && i < n.getChildCount(); ++i) {
                XMLInlinedMatching.doDumpXMLWithMatchings(n.getChild(i), p, levels - 1);
            }
            p.endElement(ce.getNamespaceURI(), ce.getLocalName(), ce.getQName());
        }
    }

    private static void setMatchAttribs(BranchNode n, AttributesImpl a) {
        if (n.hasBaseMatch()) {
            a.addAttribute("", "", MATCHING_ATT_MATCH, "CDATA", PathTracker.getPathString(n.getBaseMatch()));
            a.addAttribute("", "", MATCHING_ATT_TYPE, "CDATA", MATCHING_ATT_TYPES[n.getBaseMatchType()]);
        } else {
            a.addAttribute("", "", MATCHING_ATT_TYPE, "CDATA", MATCHING_ATT_TYPES[0]);
        }
    }
}

