/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.io.PrintWriter;
import java.util.Vector;
import tdm.lib.MatchArea;
import tdm.lib.XMLNode;

public abstract class Node {
    protected Vector children = new Vector(1);
    protected XMLNode content = null;
    protected Node parent = null;
    protected int childPos = -1;
    protected MatchArea area = null;

    protected Node() {
    }

    public void addChild(Node n) {
        n.parent = this;
        n.childPos = this.children.size();
        this.children.add(n);
    }

    public void setContent(XMLNode aContent) {
        this.content = aContent;
    }

    public void replaceChild(int ix, Node n) {
        this.children.setElementAt(n, ix);
    }

    public void addChild(int ix, Node n) {
        n.parent = this;
        this.children.add(ix, n);
        n.childPos = ix;
        for (int i = ix + 1; i < this.getChildCount(); ++i) {
            this.getChildAsNode((int)i).childPos = i;
        }
    }

    public void removeChildren() {
        this.children.clear();
    }

    public void removeChild(int ix) {
        this.children.remove(ix);
        for (int i = ix; i < this.getChildCount(); ++i) {
            this.getChildAsNode((int)i).childPos = i;
        }
    }

    public Node getParentAsNode() {
        return this.parent;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Node getChildAsNode(int ix) {
        return (Node)this.children.elementAt(ix);
    }

    public boolean hasLeftSibling() {
        return this.childPos > 0;
    }

    public boolean hasRightSibling() {
        return this.parent != null && this.childPos < this.parent.children.size() - 1;
    }

    public Node getLeftSibling() {
        if (this.parent == null || this.childPos == 0) {
            return null;
        }
        return this.parent.getChildAsNode(this.childPos - 1);
    }

    public Node getRightSibling() {
        if (this.parent == null || this.childPos == this.parent.children.size() - 1) {
            return null;
        }
        return this.parent.getChildAsNode(this.childPos + 1);
    }

    public XMLNode getContent() {
        return this.content;
    }

    public int getChildPos() {
        return this.childPos;
    }

    public MatchArea getMatchArea() {
        return this.area;
    }

    public void setMatchArea(MatchArea anArea) {
        this.area = anArea;
    }

    public void debug(PrintWriter pw, int indent) {
        String ind = "                                                   ".substring(0, indent + 1);
        pw.println(ind + this.content);
    }

    public void debugTree(PrintWriter pw, int indent) {
        this.debug(pw, indent);
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((Node)this.children.elementAt(i)).debugTree(pw, indent + 1);
        }
    }
}

