/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import com.ctc.wstx.stax.WstxEventFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import tdm.lib.BaseNode;
import tdm.lib.BranchNode;
import tdm.lib.ConflictLog;
import tdm.lib.EditLog;
import tdm.lib.MatchedNodes;
import tdm.lib.Node;
import tdm.lib.PathTracker;
import tdm.lib.TriMatching;
import tdm.lib.XMLElementNode;
import tdm.lib.XMLNode;
import tdm.lib.XMLTextNode;

public class Merge
implements XMLNode.Merger {
    private TriMatching m = null;
    private PathTracker pt = new PathTracker();
    private ConflictLog clog = new ConflictLog(this.pt);
    private EditLog elog = new EditLog(this.pt);
    private Set treeMergeCallStack = new HashSet();
    int debug = 0;
    protected static final int NOP = 1;
    protected static final int MOVE_I = 2;
    protected static final int MOVE_F = 3;
    protected static final int DELETE = 4;
    static BranchNode START = new BranchNode(new XMLTextNode("__START__"));
    static BranchNode END = new BranchNode(new XMLTextNode("__END__"));

    public Merge(TriMatching am) {
        this.m = am;
    }

    public ConflictLog getConflictLog() {
        return this.clog;
    }

    public EditLog getEditLog() {
        return this.elog;
    }

    public void merge(ContentHandler ch) throws SAXException {
        this.pt.resetContext();
        ch.startDocument();
        try {
            this.treeMerge(this.m.getLeftRoot(), this.m.getRightRoot(), new SAXExternalizer(ch), this, this.treeMergeCallStack);
        }
        catch (IOException x) {
            throw new SAXException("Externalizer threw IOException: " + x.getMessage());
        }
        ch.endDocument();
    }

    public void merge(XMLEventWriter eventWriter) throws XMLStreamException {
        this.pt.resetContext();
        WstxEventFactory eventFactory = new WstxEventFactory();
        try {
            this.treeMerge(this.m.getLeftRoot(), this.m.getRightRoot(), new StaxExternalizer(eventWriter, eventFactory), this, this.treeMergeCallStack);
            eventWriter.flush();
        }
        catch (SAXException ex) {
            throw new XMLStreamException(ex);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public void treeMerge(BranchNode a, BranchNode b, XMLNode.Externalizer ex, XMLNode.Merger nodeMerger, Set treeMergeCallStack) throws SAXException, IOException {
        if (this.insideTreeMergeCallStack(a, b, treeMergeCallStack)) {
            throw new RuntimeException("ASSERTION FAILED: Merge.treeMerge(). Infinitive recursive loop.");
        }
        if (a != null && (a.getBaseMatchType() | 2) == 0 || b != null && (b.getBaseMatchType() | 2) == 0) {
            throw new RuntimeException("mergeNode: match type should be match children, otherwise the node should be null!");
        }
        MergeList mlistA = a != null ? this.makeMergeList(a) : null;
        MergeList mlistB = b != null ? this.makeMergeList(b) : null;
        MergePairList merged = null;
        this.pt.enterSubtree();
        merged = mlistA != null && mlistB != null ? this.makeMergePairList(mlistA, mlistB) : this.mergeListToPairList(mlistA == null ? mlistB : mlistA, null);
        for (int i = 0; i < merged.getPairCount(); ++i) {
            MergePair mergePair = merged.getPair(i);
            XMLNode mergedNode = this.mergeNodeContent(mergePair, nodeMerger);
            if (mergedNode instanceof XMLTextNode) {
                XMLTextNode text = (XMLTextNode)mergedNode;
                ex.startNode(text);
                ex.endNode(text);
            } else {
                XMLNode mergedElement = mergedNode;
                ex.startNode(mergedElement);
                MergePair recursionPartners = this.getRecursionPartners(mergePair);
                this.treeMerge(recursionPartners.getFirstNode(), recursionPartners.getSecondNode(), ex, nodeMerger, treeMergeCallStack);
                ex.endNode(mergedElement);
            }
            this.pt.nextChild();
        }
        this.pt.exitSubtree();
    }

    protected XMLNode mergeNodeContent(MergePair mp, XMLNode.Merger nodeMerger) {
        BranchNode n1 = mp.getFirstNode();
        BranchNode n2 = mp.getSecondNode();
        if (n1 == null || n2 == null) {
            return (n1 == null ? n2 : n1).getContent();
        }
        if (n1.isMatch(1)) {
            if (!n2.isMatch(1)) {
                this.logUpdateOperation(n2);
                return n2.getContent();
            }
            return this.cmerge(n1, n2, nodeMerger);
        }
        if (n2.isMatch(1)) {
            this.logUpdateOperation(n1);
            return n1.getContent();
        }
        return this.cmerge(n1, n2, nodeMerger);
    }

    protected MergePair getRecursionPartners(MergePair mp) {
        BranchNode n1 = mp.getFirstNode();
        BranchNode n2 = mp.getSecondNode();
        if (n1 == null || n2 == null) {
            return mp;
        }
        if (n1.isMatch(2) && n2.isMatch(2)) {
            return mp;
        }
        if (n1.isMatch(2) && n2.isMatch(1)) {
            return new MergePair(n2, null);
        }
        if (n1.isMatch(1) && n2.isMatch(2)) {
            return new MergePair(n1, null);
        }
        return mp;
    }

    private XMLNode cmerge(BranchNode a, BranchNode b, XMLNode.Merger nodeMerger) {
        boolean bUpdated;
        boolean aUpdated = !this.matches(a, a.getBaseMatch());
        boolean bl = bUpdated = !this.matches(b, b.getBaseMatch());
        if (aUpdated && bUpdated) {
            if (!a.isLeftTree()) {
                BranchNode tmp = a;
                a = b;
                b = tmp;
            }
            if (this.matches(a, b)) {
                this.clog.addNodeWarning(1, "Node updated in both branches, but updates are equal", a.getBaseMatch(), a, b);
                this.logUpdateOperation(a);
                return a.getContent();
            }
            XMLNode merged = nodeMerger.merge(a.getBaseMatch().getContent(), a.getContent(), b.getContent());
            if (merged != null) {
                return merged;
            }
            this.clog.addNodeConflict(1, "Node updated in both branches, using branch 1", a.getBaseMatch(), a, b);
            this.logUpdateOperation(a);
            return a.getContent();
        }
        if (bUpdated) {
            this.logUpdateOperation(b);
            return b.getContent();
        }
        if (aUpdated) {
            this.logUpdateOperation(a);
            return a.getContent();
        }
        return a.getContent();
    }

    @Override
    public XMLNode merge(XMLNode baseNode, XMLNode aNode, XMLNode bNode) {
        int i;
        if (!(baseNode instanceof XMLElementNode && aNode instanceof XMLElementNode && bNode instanceof XMLElementNode)) {
            return null;
        }
        XMLElementNode baseN = (XMLElementNode)baseNode;
        XMLElementNode aN = (XMLElementNode)aNode;
        XMLElementNode bN = (XMLElementNode)bNode;
        String tagName = "";
        if (baseN.getQName().equals(bN.getQName())) {
            tagName = aN.getQName();
        } else if (baseN.getQName().equals(aN.getQName())) {
            tagName = bN.getQName();
        } else {
            return null;
        }
        Attributes base = baseN.getAttributes();
        Attributes a = aN.getAttributes();
        Attributes b = bN.getAttributes();
        HashSet<String> deletia = new HashSet<String>();
        for (int i2 = 0; i2 < base.getLength(); ++i2) {
            int ixa = a.getIndex(base.getQName(i2));
            int ixb = b.getIndex(base.getQName(i2));
            if (ixa == -1 && ixb != -1 && !base.getValue(i2).equals(b.getValue(ixb)) || ixb == -1 && ixa != -1 && !base.getValue(i2).equals(a.getValue(ixa))) {
                return null;
            }
            if (ixa != -1 && ixb != -1) continue;
            deletia.add(base.getQName(i2));
        }
        AttributesImpl merged = new AttributesImpl();
        for (i = 0; i < a.getLength(); ++i) {
            String valueBase;
            String qName = a.getQName(i);
            String value = a.getValue(i);
            if (deletia.contains(qName)) continue;
            int ixb = b.getIndex(qName);
            if (ixb == -1) {
                merged.addAttribute("", "", qName, a.getType(i), value);
                continue;
            }
            String valueB = b.getValue(ixb);
            if (valueB.equals(valueBase = base.getValue(qName))) {
                merged.addAttribute("", "", qName, a.getType(i), value);
                continue;
            }
            if (value.equals(valueBase)) {
                merged.addAttribute("", "", qName, b.getType(ixb), valueB);
                continue;
            }
            return null;
        }
        for (i = 0; i < b.getLength(); ++i) {
            String qName = b.getQName(i);
            if (deletia.contains(qName) || a.getIndex(qName) != -1) continue;
            merged.addAttribute("", "", qName, b.getType(i), b.getValue(i));
        }
        return new XMLElementNode(tagName, merged);
    }

    protected MergeList makeMergeList(BranchNode parent) {
        MergeList ml = new MergeList(parent);
        if (parent.getBaseMatch() == null) {
            ml.add(START);
            for (int i = 0; i < parent.getChildCount(); ++i) {
                ml.addHangOn(parent.getChild(i));
            }
            ml.lockNeighborhood(0, 1);
            ml.add(END);
            return ml;
        }
        HashMap<BaseNode, Integer> baseMatches = new HashMap<BaseNode, Integer>();
        int prevChildPos = -1;
        int childPos = -1;
        ml.add(START);
        for (int i = 0; i < parent.getChildCount(); ++i) {
            BranchNode current = parent.getChild(i);
            BaseNode match = current.getBaseMatch();
            if (match == null) {
                ml.addHangOn(current);
                ml.lockNeighborhood(0, 1);
                continue;
            }
            if (match.getParent() != parent.getBaseMatch()) {
                ml.addHangOn(current);
                ml.lockNeighborhood(0, 1);
                continue;
            }
            if (baseMatches.containsKey(match)) {
                ml.addHangOn(current);
                Integer firstPos = (Integer)baseMatches.get(match);
                if (firstPos != null) {
                    ml.lockNeighborhood(firstPos, 1, 1);
                    baseMatches.put(match, null);
                }
                ml.lockNeighborhood(0, 1);
                continue;
            }
            ml.add(current);
            baseMatches.put(match, new Integer(ml.tailPos));
            childPos = match.getChildPos();
            int n = childPos = childPos == -1 ? -2 : childPos;
            if (prevChildPos + 1 != childPos) {
                boolean moved = false;
                if (prevChildPos != -2 && childPos != -2 && prevChildPos < childPos) {
                    for (int j = 0; !moved && j < parent.getChildCount(); ++j) {
                        int basePos;
                        BaseNode aBase = parent.getChild(j).getBaseMatch();
                        int n2 = basePos = aBase == null ? -1 : aBase.getChildPos();
                        if (basePos == -1 || basePos <= prevChildPos || basePos >= childPos) continue;
                        moved = true;
                    }
                } else {
                    moved = true;
                }
                if (moved) {
                    ml.lockNeighborhood(1, 0);
                    ml.setMoved(true);
                } else {
                    ml.setMoved(false);
                }
            }
            prevChildPos = childPos;
        }
        ml.add(END);
        if (prevChildPos + 1 != parent.getBaseMatch().getChildCount()) {
            ml.lockNeighborhood(1, 0);
        }
        return ml;
    }

    protected MergePairList mergeListToPairList(MergeList mlistA, MergeList mlistB) {
        MergePairList merged = new MergePairList();
        for (int i = 0; i < mlistA.getEntryCount() - 1; ++i) {
            MergeEntry pair;
            MergeEntry me = mlistA.getEntry(i);
            if (i > 0) {
                merged.append(me.getNode(), me.getNode().getFirstPartner(3));
                this.logHangonStructOps(me.getNode(), merged.getPairCount() - 1);
            }
            for (int ih = 0; ih < me.getHangonCount(); ++ih) {
                BranchNode hangon = me.getHangon(ih).getNode();
                merged.append(hangon, hangon.getFirstPartner(3));
                this.logHangonStructOps(hangon, merged.getPairCount() - 1);
            }
            if (mlistB == null || (pair = mlistB.getEntry(mlistB.findPartner(me))) == null || this.checkHangonCombine(me, pair, mlistA, mlistB)) continue;
            for (int ih = 0; ih < pair.getHangonCount(); ++ih) {
                BranchNode hangon = pair.getHangon(ih).getNode();
                merged.append(hangon, hangon.getFirstPartner(3));
                this.logHangonStructOps(hangon, merged.getPairCount() - 1);
            }
        }
        return merged;
    }

    protected void logHangonStructOps(BranchNode n, int childPos) {
        if (!n.hasBaseMatch()) {
            this.elog.insert(n, childPos);
        } else if (n.isLeftTree() && n.getBaseMatch().getLeft().getMatchCount() > 1 || !n.isLeftTree() && n.getBaseMatch().getRight().getMatchCount() > 1) {
            this.elog.copy(n, childPos);
        } else {
            this.elog.move(n, childPos);
        }
    }

    protected void logEntryStructOps(MergeEntry m1, MergeEntry m2, int childPos) {
        if (m1.moved) {
            this.elog.move(m1.getNode(), childPos);
        } else if (m2.moved) {
            this.elog.move(m2.getNode(), childPos);
        }
    }

    protected void logUpdateOperation(BranchNode n) {
        this.elog.update(n);
    }

    protected MergePairList makeMergePairList(MergeList mlistA, MergeList mlistB) {
        MergePairList merged;
        block13: {
            merged = new MergePairList();
            this.removeDeletedOrMoved(mlistA, mlistB);
            this.elog.checkPoint();
            if (mlistA.getEntryCount() != mlistB.getEntryCount()) {
                throw new RuntimeException("ASSERTION FAILED: MergeList.merge(): lists different lengths!");
            }
            int entryCount = mlistA.getEntryCount();
            int iEntryCount = 0;
            int posA = 0;
            int posB = 0;
            MergeEntry ea = mlistA.getEntry(posA);
            MergeEntry eb = mlistB.getEntry(posB);
            do {
                int i;
                for (i = 0; i < ea.getHangonCount(); ++i) {
                    BranchNode na = ea.getHangon(i).getNode();
                    merged.append(na, na.getFirstPartner(3));
                    this.logHangonStructOps(na, merged.getPairCount() - 1);
                }
                if (eb.getHangonCount() > 0 && !this.checkHangonCombine(ea, eb, mlistA, mlistB)) {
                    for (i = 0; i < eb.getHangonCount(); ++i) {
                        BranchNode nb = eb.getHangon(i).getNode();
                        merged.append(nb, nb.getFirstPartner(3));
                        this.logHangonStructOps(nb, merged.getPairCount() - 1);
                    }
                }
                int nextA = -1;
                int nextB = -1;
                nextA = ea.locked && mlistA.getEntry((int)(posA + 1)).locked ? posA + 1 : -1;
                int n = nextB = eb.locked && mlistB.getEntry((int)(posB + 1)).locked ? posB + 1 : -1;
                if (nextA == -1 && nextB == -1) {
                    nextA = posA + 1;
                    nextB = posB + 1;
                }
                if (nextB == -1) {
                    nextB = mlistB.findPartner(mlistA.getEntry(nextA));
                } else if (nextA == -1) {
                    nextA = mlistA.findPartner(mlistB.getEntry(nextB));
                } else if (nextB != mlistB.findPartner(mlistA.getEntry(nextA))) {
                    this.clog.addListConflict(4, "Conflicting moves inside child list, using the sequencing of branch 1", ea.getNode() != START ? ea.getNode().getBaseMatch() : null, ea.getNode() != START ? ea.getNode() : null, eb.getNode() != START ? eb.getNode() : null);
                    this.elog.rewind();
                    return this.mergeListToPairList(mlistA.getEntryParent().isLeftTree() ? mlistA : mlistB, mlistA.getEntryParent().isLeftTree() ? mlistB : mlistA);
                }
                posA = nextA;
                posB = nextB;
                ea = mlistA.getEntry(posA);
                eb = mlistB.getEntry(posB);
                if (ea.node == END || eb.node == END) {
                    if (ea.node != eb.node) {
                        throw new RuntimeException("ASSERTION FAILED: Merge.mergeLists(). Both cursors not at end");
                    }
                    break block13;
                }
                merged.append(ea.getNode(), eb.getNode());
                this.logEntryStructOps(ea, eb, merged.getPairCount() - 1);
            } while (++iEntryCount < entryCount);
            throw new RuntimeException("ASSERTION FAILED: Merge.mergeLists(). Both cursors not at end after looping many times that equal the size of both list.");
        }
        this.elog.commit();
        return merged;
    }

    protected boolean checkHangonCombine(MergeEntry ea, MergeEntry eb, MergeList mla, MergeList mlb) {
        boolean hangonsAreEqual = false;
        if (ea.getHangonCount() > 0) {
            if (eb.getHangonCount() == ea.getHangonCount()) {
                hangonsAreEqual = true;
                for (int i = 0; hangonsAreEqual && i < ea.getHangonCount(); ++i) {
                    hangonsAreEqual = this.treeMatches(eb.getHangon(i).getNode(), ea.getHangon(i).getNode());
                }
            }
            if (hangonsAreEqual) {
                this.clog.addListWarning(3, "Equal insertions/copies in both branches after the context nodes.", ea.getNode().getBaseMatch() != null ? ea.getNode().getBaseMatch() : eb.getNode().getBaseMatch(), ea.getNode() != START ? ea.getNode() : null, eb.getNode() != START ? eb.getNode() : null);
            } else {
                this.clog.addListWarning(3, "Insertions/copies in both branches after the context nodes. Sequencing the insertions.", ea.getNode().getBaseMatch() != null ? ea.getNode().getBaseMatch() : eb.getNode().getBaseMatch(), ea.getNode() != START ? ea.getNode() : null, eb.getNode() != START ? eb.getNode() : null);
            }
        }
        return hangonsAreEqual;
    }

    protected int getOperation(BaseNode bn, MergeList ml) {
        int mlPos = ml.matchInList(bn);
        if (mlPos == -1) {
            MatchedNodes copiesInThisTree = null;
            copiesInThisTree = ml.getEntryParent().isLeftTree() ? bn.getLeft() : bn.getRight();
            if (copiesInThisTree.getMatches().isEmpty()) {
                return 4;
            }
            return 3;
        }
        if (ml.getEntry(mlPos).isMoved()) {
            return 2;
        }
        return 1;
    }

    private void removeDeletedOrMoved(MergeList mlistA, MergeList mlistB) {
        BaseNode baseParent = mlistA.getEntryParent().getBaseMatch();
        for (int i = 0; i < baseParent.getChildCount(); ++i) {
            int op2;
            BaseNode bn = baseParent.getChild(i);
            int op1 = this.getOperation(bn, mlistA);
            if (op1 > (op2 = this.getOperation(bn, mlistB))) {
                int t = op1;
                op1 = op2;
                op2 = t;
                MergeList tl = mlistA;
                mlistA = mlistB;
                mlistB = tl;
            }
            if (op1 == 1 && op2 == 1 || op1 == 1 && op2 == 2 || op1 == 2 && op2 == 2 || op1 == 4 && op2 == 4) continue;
            if (op1 == 1 && (op2 == 3 || op2 == 4)) {
                int ix = mlistA.matchInList(bn);
                if (op2 == 4 && this.isDeletiaModified(mlistA.getEntry(ix).getNode(), mlistA)) {
                    this.clog.addListConflict(2, "Modifications in deleted subtree.", bn, mlistA.getEntry(ix).getNode(), null);
                }
                if (mlistA.getEntry(ix).getHangonCount() > 0) {
                    for (int ih = 0; ih < mlistA.getEntry(ix).getHangonCount(); ++ih) {
                        mlistA.getEntry(ix - 1).addHangon(mlistA.getEntry(ix).getHangon(ih));
                    }
                }
                int matchIx = mlistA.matchInList(bn);
                if (op2 == 4) {
                    this.elog.delete(mlistA.getEntry(matchIx).getNode().getBaseMatch(), mlistB.getEntryParent());
                }
                if (op2 == 4 && mlistA.getEntry((int)matchIx).locked) {
                    this.clog.addListConflict(2, "Moved or copied node deleted. Moving on by allowing the delete.", bn, mlistA.getEntry(ix).getNode(), null);
                }
                mlistA.removeEntryAt(matchIx);
                continue;
            }
            if (op1 == 2 && op2 == 3) {
                BranchNode op1node = mlistA.getEntry(mlistA.matchInList(bn)).getNode();
                this.clog.addListConflict(4, "Node moved to different locations - trying to recover by ignoring move inside childlist (copies and inserts immediately following the node may have been deleted)", bn, op1node, op1node.getFirstPartner(3));
                mlistA.removeEntryAt(mlistA.matchInList(bn));
                continue;
            }
            if (op1 == 2 && op2 == 4) {
                this.clog.addListConflict(4, "Node moved and deleted - trying to recover by deleting the node (copies and inserts immediately following the node may also have been deleted)", bn, mlistA.getEntry(mlistA.matchInList(bn)).getNode(), null);
                int matchIx = mlistA.matchInList(bn);
                this.elog.delete(mlistA.getEntry(matchIx).getNode().getBaseMatch(), mlistB.getEntryParent());
                mlistA.removeEntryAt(matchIx);
                continue;
            }
            if (op1 == 3 && op2 == 3) {
                if (!this.isMovefMovefConflict(bn)) continue;
                this.clog.addListConflict(4, "The node was moved to different locations. It will appear at each location.", bn, bn.getLeft().getFullMatch(), bn.getRight().getFullMatch());
                continue;
            }
            if (op1 != 3 || op2 != 4) continue;
            this.clog.addListConflict(4, "The node was moved and deleted. Ignoring the deletion.", bn, bn.getLeft().getFullMatch(), bn.getRight().getFullMatch());
        }
    }

    private boolean isDeletiaModified(BranchNode n, MergeList ml) {
        BaseNode m = n.getBaseMatch();
        if (m == null) {
            return true;
        }
        if (this.getOperation(m, ml) != 1) {
            return true;
        }
        if (n.getBaseMatchType() != 3) {
            return true;
        }
        boolean deletedInOther = n.getPartners().getMatches().isEmpty();
        if (deletedInOther) {
            if (!this.matches(n, m)) {
                return true;
            }
            MergeList mlistN = this.makeMergeList(n);
            for (int i = 0; i < n.getChildCount(); ++i) {
                if (!this.isDeletiaModified(n.getChild(i), mlistN)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isMovefMovefConflict(BaseNode n) {
        return this._isMovefMovefConflict(n, n.getRight().getMatches(), n.getLeft().getMatches()) || this._isMovefMovefConflict(n, n.getLeft().getMatches(), n.getRight().getMatches());
    }

    private boolean _isMovefMovefConflict(BaseNode n, Set matchesA, Set matchesB) {
        for (BranchNode bnA : matchesB) {
            BranchNode bnAparent = bnA.getParent();
            if ((bnAparent.getBaseMatchType() & 2) == 0) {
                return true;
            }
            for (BranchNode bnBparent : bnAparent.getPartners().getMatches()) {
                boolean hasNasChild = false;
                for (int ic = 0; ic < bnBparent.getChildCount() && !hasNasChild; ++ic) {
                    hasNasChild = matchesA.contains(bnBparent.getChild(ic));
                }
                if (!hasNasChild || (bnBparent.getBaseMatchType() & 2) != 0) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean matches(Node a, Node b) {
        if (a == null || b == null) {
            return false;
        }
        return a.getContent().contentEquals(b.getContent()) && a.children.size() == b.children.size();
    }

    protected boolean treeMatches(Node a, Node b) {
        if (!this.matches(a, b)) {
            return false;
        }
        if (a.getChildCount() != b.getChildCount()) {
            return false;
        }
        boolean matches = true;
        for (int i = 0; i < a.getChildCount() && matches; matches &= this.treeMatches(a.getChildAsNode(i), b.getChildAsNode(i)), ++i) {
        }
        return matches;
    }

    private boolean insideTreeMergeCallStack(BranchNode a, BranchNode b, Set treeMergeCallStack) {
        return !treeMergeCallStack.add(new MergePair(a, b));
    }

    private static class StaxExternalizer
    implements XMLNode.Externalizer {
        private XMLEventWriter eventWriter;
        private WstxEventFactory eventFactory;

        private StaxExternalizer(XMLEventWriter eventWriter, WstxEventFactory eventFactory) {
            this.eventWriter = eventWriter;
            this.eventFactory = eventFactory;
        }

        @Override
        public void endNode(XMLNode n) throws IOException, SAXException {
            try {
                if (n instanceof XMLElementNode) {
                    XMLElementNode node = (XMLElementNode)n;
                    this.eventWriter.add(this.eventFactory.createEndElement(node.getQname(), null));
                }
            }
            catch (XMLStreamException e) {
                throw new SAXException(e);
            }
        }

        @Override
        public void startNode(XMLNode n) throws IOException, SAXException {
            try {
                if (n instanceof XMLElementNode) {
                    XMLElementNode node = (XMLElementNode)n;
                    this.eventWriter.add(this.eventFactory.createStartElement(node.getQname(), node.getAttributesIterator(this.eventFactory), null));
                } else if (n instanceof XMLTextNode) {
                    XMLTextNode node = (XMLTextNode)n;
                    if (node.isCdata()) {
                        this.eventWriter.add(this.eventFactory.createCData(node.getTextAsString()));
                    } else {
                        this.eventWriter.add(this.eventFactory.createCharacters(node.getTextAsString()));
                    }
                }
            }
            catch (XMLStreamException e) {
                throw new SAXException(e);
            }
        }
    }

    private class SAXExternalizer
    implements XMLNode.Externalizer {
        private ContentHandler ch;

        public SAXExternalizer(ContentHandler ch) {
            this.ch = ch;
        }

        @Override
        public void startNode(XMLNode n) throws SAXException {
            if (n instanceof XMLTextNode) {
                this.ch.characters(((XMLTextNode)n).getText(), 0, ((XMLTextNode)n).getText().length);
            } else {
                XMLElementNode e = (XMLElementNode)n;
                this.ch.startElement(e.getNamespaceURI(), e.getLocalName(), e.getQName(), e.getAttributes());
            }
        }

        @Override
        public void endNode(XMLNode n) throws SAXException {
            if (n instanceof XMLTextNode) {
                return;
            }
            XMLElementNode e = (XMLElementNode)n;
            this.ch.endElement(e.getNamespaceURI(), e.getLocalName(), e.getQName());
        }
    }

    class MergeList {
        private Vector list = new Vector();
        private Map index = new HashMap();
        private int tailPos = -1;
        private BranchNode entryParent = null;
        private MergeEntry currentEntry = null;

        public MergeList(BranchNode anEntryParent) {
            this.entryParent = anEntryParent;
        }

        public BranchNode getEntryParent() {
            return this.entryParent;
        }

        public void add(MergeEntry n) {
            ++this.tailPos;
            this.ensureCapacity(this.tailPos + 1, false);
            if (this.list.elementAt(this.tailPos) != null) {
                n.locked = ((MergeEntry)this.list.elementAt((int)this.tailPos)).locked;
            }
            this.list.setElementAt(n, this.tailPos);
            this.index.put(n.node.getBaseMatch(), new Integer(this.tailPos));
            this.currentEntry = n;
        }

        void add(BranchNode n) {
            this.add(new MergeEntry(n));
        }

        void addHangOn(BranchNode n) {
            this.getEntry(this.tailPos).addHangon(n);
            this.currentEntry = null;
        }

        public void setMoved(boolean moved) {
            this.currentEntry.setMoved(moved);
        }

        public int getEntryCount() {
            return this.tailPos + 1;
        }

        public MergeEntry getEntry(int ix) {
            return (MergeEntry)this.list.elementAt(ix);
        }

        public void removeEntryAt(int ix) {
            this.list.removeElementAt(ix);
            --this.tailPos;
            this.index.clear();
            for (int i = 0; i < this.getEntryCount(); ++i) {
                this.index.put(this.getEntry((int)i).node.getBaseMatch(), new Integer(i));
            }
        }

        public void lockNeighborhood(int left, int right) {
            this.lockNeighborhood(this.tailPos, left, right);
        }

        public void lockNeighborhood(int acurrentPos, int left, int right) {
            this.ensureCapacity(acurrentPos + right + 1, true);
            for (int i = acurrentPos - left; i <= acurrentPos + right; ++i) {
                ((MergeEntry)this.list.elementAt((int)i)).locked = true;
            }
        }

        public int findPartner(MergeEntry b) {
            if (b.node == START) {
                return 0;
            }
            if (b.node == END) {
                return this.getEntryCount() - 1;
            }
            return (Integer)this.index.get(b.node.getBaseMatch());
        }

        public int matchInList(BaseNode n) {
            Integer i = (Integer)this.index.get(n);
            if (i == null) {
                return -1;
            }
            return i;
        }

        private void ensureCapacity(int size, boolean fill) {
            for (int i = this.list.size(); i < size; ++i) {
                this.list.add(fill ? new MergeEntry() : null);
            }
        }

        void print() {
            int pos = 0;
            MergeEntry me = null;
            do {
                me = (MergeEntry)this.list.elementAt(pos);
                me.print(pos);
                ++pos;
            } while (me.node != END);
        }
    }

    class MergeEntry
    extends HangonEntry {
        Vector inserts;
        boolean locked;
        private BranchNode mergePartner;
        private boolean moved;

        MergeEntry(BranchNode n) {
            super(n);
            this.inserts = new Vector();
            this.locked = false;
            this.mergePartner = null;
            this.moved = false;
        }

        MergeEntry() {
            this.inserts = new Vector();
            this.locked = false;
            this.mergePartner = null;
            this.moved = false;
        }

        public boolean isMoved() {
            return this.moved;
        }

        public void setMoved(boolean amoved) {
            this.moved = amoved;
        }

        public void setMergePartner(BranchNode n) {
            this.mergePartner = n;
        }

        public BranchNode getMergePartner() {
            return this.mergePartner;
        }

        void print(int pos) {
            System.out.print(pos + ": ");
            System.out.print(this.isMoved() ? (char)'m' : '-');
            System.out.print(this.locked ? (char)'*' : '-');
            System.out.print(this.mergePartner != null ? (char)'p' : '-');
            System.out.print(' ' + this.node.getContent().toString() + " |");
            if (this.node.getChildCount() > 0) {
                System.out.print(' ' + this.node.getChild(0).getContent().toString() + " | ");
            } else {
                System.out.print(" - | ");
            }
            System.out.println(this.inserts.toString());
        }

        int getHangonCount() {
            return this.inserts.size();
        }

        HangonEntry getHangon(int ix) {
            return (HangonEntry)this.inserts.elementAt(ix);
        }

        void addHangon(BranchNode n) {
            this.addHangon(new HangonEntry(n));
        }

        void addHangon(HangonEntry e) {
            this.inserts.add(e);
        }
    }

    private class HangonEntry {
        BranchNode node = null;

        HangonEntry(BranchNode an) {
            this.node = an;
        }

        HangonEntry() {
        }

        public BranchNode getNode() {
            return this.node;
        }

        public String toString() {
            return this.node.getContent().toString();
        }
    }

    class MergePairList {
        Vector list = new Vector();

        MergePairList() {
        }

        public void append(BranchNode a, BranchNode b) {
            this.list.add(new MergePair(a, b));
        }

        public int getPairCount() {
            return this.list.size();
        }

        public MergePair getPair(int ix) {
            return (MergePair)this.list.elementAt(ix);
        }

        public void print() {
            for (int i = 0; i < this.list.size(); ++i) {
                MergePair mp = (MergePair)this.list.elementAt(i);
                System.out.println("<" + (mp.first != null ? mp.first.getContent().toString() : ".") + "," + (mp.second != null ? mp.second.getContent().toString() : ".") + ">");
            }
        }
    }

    class MergePair {
        BranchNode first;
        BranchNode second;

        MergePair(BranchNode aFirst, BranchNode aSecond) {
            this.first = aFirst;
            this.second = aSecond;
        }

        public BranchNode getFirstNode() {
            return this.first;
        }

        public BranchNode getSecondNode() {
            return this.second;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MergePair mergePair = (MergePair)o;
            return this.first == mergePair.first && this.second == mergePair.second;
        }

        public int hashCode() {
            int result = this.first != null ? this.first.hashCode() : 0;
            result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
            return result;
        }
    }
}

