/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import tdm.lib.BaseNode;
import tdm.lib.BranchNode;
import tdm.lib.InterruptedRuntimeException;
import tdm.lib.MatchArea;
import tdm.lib.Matching;
import tdm.lib.Measure;
import tdm.lib.Node;
import tdm.lib.NodeFactory;
import tdm.lib.XMLElementNode;
import tdm.lib.XMLNode;
import tdm.lib.XMLTextNode;

public class HeuristicMatching
implements Matching {
    protected BaseNode baseRoot = null;
    protected BranchNode branchRoot = null;
    private static NodeFactory baseNodeFactory = new NodeFactory(){

        @Override
        public Node makeNode(XMLNode content) {
            return new BaseNode(content);
        }
    };
    private static NodeFactory branchNodeFactory = new NodeFactory(){

        @Override
        public Node makeNode(XMLNode content) {
            return new BranchNode(content);
        }
    };
    private Set removedMatchings = new HashSet();
    public static int COPY_THRESHOLD = 128;
    private static final int EDGE_BYTES = 4;
    private static final double DFS_MATCH_THRESHOLD = 0.2;
    private static final double MAX_FUZZY_MATCH = 0.2;
    private static final double END_MATCH = 1.0;
    private Measure measure = new Measure();
    private Comparator candComp = new Comparator(){

        public int compare(Object o1, Object o2) {
            double diff = ((CandidateEntry)o1).distance - ((CandidateEntry)o2).distance;
            return diff < 0.0 ? -1 : (diff > 0.0 ? 1 : 0);
        }
    };
    private Comparator candlrdComp = new Comparator(){

        public int compare(Object o1, Object o2) {
            double diff = ((CandidateEntry)o1).leftRightDown - ((CandidateEntry)o2).leftRightDown;
            return diff < 0.0 ? -1 : (diff > 0.0 ? 1 : 0);
        }
    };

    public HeuristicMatching() {
    }

    public HeuristicMatching(BaseNode abase, BranchNode abranch) {
        this.buildMatching(abase, abranch);
    }

    @Override
    public void buildMatching(BaseNode abase, BranchNode abranch) {
        this.baseRoot = abase;
        this.branchRoot = abranch;
        this.matchSubtrees(this.baseRoot, this.branchRoot);
        this.removeSmallCopies(this.branchRoot);
        this.matchSimilarUnmatched(this.baseRoot, this.branchRoot);
        this.setMatchTypes(this.baseRoot);
        this.branchRoot.setBaseMatch(this.baseRoot, 3);
    }

    @Override
    public BaseNode getBaseRoot() {
        return this.baseRoot;
    }

    @Override
    public BranchNode getBranchRoot() {
        return this.branchRoot;
    }

    @Override
    public NodeFactory getBaseNodeFactory() {
        return baseNodeFactory;
    }

    @Override
    public NodeFactory getBranchNodeFactory() {
        return branchNodeFactory;
    }

    protected void matchSubtrees(BaseNode base, BranchNode branch) {
        Vector candidates = this.findCandidates(base, branch);
        int bestCount = 0;
        CandidateEntry best = null;
        Vector<CandidateEntry> bestCandidates = new Vector<CandidateEntry>();
        for (CandidateEntry candidate : candidates) {
            int initCount = 0;
            int thisCount = this.dfsMatch(candidate.candidate, branch, initCount);
            if (thisCount == bestCount) {
                bestCandidates.add(candidate);
                continue;
            }
            if (thisCount <= bestCount) continue;
            bestCount = thisCount;
            bestCandidates.clear();
            bestCandidates.add(candidate);
        }
        best = this.getBestCandidate(branch, bestCandidates, bestCount);
        Vector<BranchNode> stopNodes = new Vector<BranchNode>();
        if (best != null) {
            this.dfsMatch(best.candidate, branch, 0, stopNodes, new MatchArea(branch));
        } else {
            for (int i = 0; i < branch.getChildCount(); ++i) {
                stopNodes.add(branch.getChild(i));
            }
        }
        Iterator i = stopNodes.iterator();
        while (i.hasNext()) {
            this.matchSubtrees(base, (BranchNode)i.next());
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new InterruptedRuntimeException();
        }
    }

    protected CandidateEntry getBestCandidate(BranchNode branch, Vector bestCandidates, int bestCount) {
        CandidateEntry best = null;
        if (bestCandidates.size() > 1) {
            for (CandidateEntry candidate : bestCandidates) {
                BranchNode left = (BranchNode)branch.getLeftSibling();
                if (left == null || !left.hasBaseMatch() || left.getBaseMatch() != candidate.candidate.getLeftSibling()) continue;
                return candidate;
            }
            for (CandidateEntry candidate : bestCandidates) {
                if (!(candidate.leftRightDown < 0.0)) continue;
                candidate.leftRightDown = Math.min(this.measure.childListDistance(candidate.candidate, branch), Math.min(this.getDistanceOfRight(candidate.candidate, branch), this.getDistanceOfLeft(candidate.candidate, branch)));
            }
            Collections.sort(bestCandidates, this.candlrdComp);
        }
        CandidateEntry candidateEntry = best = bestCandidates.isEmpty() ? null : (CandidateEntry)bestCandidates.elementAt(0);
        if (best != null && bestCount == 1 && Math.min(best.leftRightDown, best.distance) > 0.1) {
            best = null;
        }
        return best;
    }

    private void matchSimilarUnmatched(BaseNode base, BranchNode branch) {
        for (int i = 0; i < branch.getChildCount(); ++i) {
            this.matchSimilarUnmatched(base, branch.getChild(i));
        }
        BaseNode baseMatch = branch.getBaseMatch();
        if (baseMatch != null && baseMatch.getChildCount() > 0) {
            for (int i = 0; i < branch.getChildCount(); ++i) {
                BaseNode x;
                BranchNode n = branch.getChild(i);
                Object leftcand = null;
                Object rightcand = null;
                int lastBaseChild = baseMatch.getChildCount() - 1;
                if (n.getBaseMatch() != null) continue;
                if (i == 0 && !this.isMatched(baseMatch.getChild(0))) {
                    this.addMatchingIfSameType(n, baseMatch.getChild(0));
                    continue;
                }
                if (i == branch.getChildCount() - 1 && !this.isMatched(baseMatch.getChild(lastBaseChild))) {
                    this.addMatchingIfSameType(n, baseMatch.getChild(lastBaseChild));
                    continue;
                }
                if (i > 0 && (x = branch.getChild(i - 1).getBaseMatch()) != null && x.hasRightSibling() && !this.isMatched((BaseNode)x.getRightSibling())) {
                    this.addMatchingIfSameType(n, (BaseNode)x.getRightSibling());
                    continue;
                }
                if (i >= branch.getChildCount() - 1 || (x = branch.getChild(i + 1).getBaseMatch()) == null || !x.hasLeftSibling() || this.isMatched((BaseNode)x.getLeftSibling())) continue;
                this.addMatchingIfSameType(n, (BaseNode)x.getLeftSibling());
            }
        }
    }

    private void setMatchTypes(BaseNode base) {
        for (int i = 0; i < base.getChildCount(); ++i) {
            this.setMatchTypes(base.getChild(i));
        }
        if (base.getLeft().getMatches().size() > 1) {
            int minDist = Integer.MAX_VALUE;
            double minContentDist = Double.MAX_VALUE;
            BranchNode master = null;
            for (BranchNode cand : base.getLeft().getMatches()) {
                int dist;
                int n = dist = this.exactChildListMatch(base, cand) ? 0 : this.measure.matchedChildListDistance(base, cand);
                if (dist < minDist) {
                    minDist = dist;
                    master = cand;
                    continue;
                }
                if (dist != minDist) continue;
                minContentDist = this.measure.getDistance(base, master);
                double cDist = this.measure.getDistance(base, cand);
                if (!(cDist < minContentDist)) continue;
                minContentDist = cDist;
                master = cand;
            }
            this.removedMatchings.clear();
            for (BranchNode cand : base.getLeft().getMatches()) {
                if (cand == master) continue;
                boolean structMatch = this.exactChildListMatch(base, cand);
                boolean contMatch = cand.getContent().contentEquals(base.getContent());
                if (!structMatch && !contMatch) {
                    this.removedMatchings.add(cand);
                    continue;
                }
                cand.setMatchType((contMatch ? 1 : 0) + (structMatch ? 2 : 0));
            }
            for (BranchNode cand : this.removedMatchings) {
                this.delMatching(cand, cand.getBaseMatch());
            }
        }
    }

    private boolean exactChildListMatch(BaseNode base, BranchNode a) {
        if (a.getChildCount() != base.getChildCount()) {
            return false;
        }
        for (int i = 0; i < a.getChildCount(); ++i) {
            if (base.getChild(i) == a.getChild(i).getBaseMatch()) continue;
            return false;
        }
        return true;
    }

    private void removeSmallCopies(BranchNode root) {
        BaseNode base = root.getBaseMatch();
        if (base != null && base.getLeft().getMatches().size() > 1) {
            HashSet<BranchNode> deletia = new HashSet<BranchNode>();
            for (BranchNode copy : base.getLeft().getMatches()) {
                if (copy.getMatchArea().getInfoBytes() >= COPY_THRESHOLD) continue;
                deletia.add(copy);
            }
            if (base.getLeft().getMatches().size() == deletia.size()) {
                int maxcopybytes = 0;
                int mincopybytes = Integer.MAX_VALUE;
                Node origInstance = null;
                for (BranchNode copy : base.getLeft().getMatches()) {
                    int copybytes;
                    Node copyRoot = copy.getMatchArea().getRoot();
                    Node copyBase = ((BranchNode)copyRoot).getBaseMatch();
                    for (copybytes = copy.getMatchArea().getInfoBytes(); (copyRoot = copyRoot.getLeftSibling()) != null && (copyBase = copyBase.getLeftSibling()) != null && ((BranchNode)copyRoot).getBaseMatch() == copyBase && copybytes < COPY_THRESHOLD; copybytes += ((BranchNode)copyRoot).getMatchArea().getInfoBytes()) {
                    }
                    copyRoot = copy.getMatchArea().getRoot();
                    copyBase = ((BranchNode)copyRoot).getBaseMatch();
                    while ((copyRoot = (BranchNode)copyRoot.getRightSibling()) != null && (copyBase = (BaseNode)copyBase.getRightSibling()) != null && ((BranchNode)copyRoot).getBaseMatch() == copyBase && copybytes < COPY_THRESHOLD) {
                        copybytes += copyRoot.getMatchArea().getInfoBytes();
                    }
                    if (copybytes > maxcopybytes) {
                        origInstance = copy;
                        maxcopybytes = copybytes;
                    }
                    if (copybytes >= mincopybytes) continue;
                    mincopybytes = copybytes;
                }
                if (maxcopybytes > mincopybytes) {
                    deletia.remove(origInstance);
                    origInstance.getMatchArea().addInfoBytes(COPY_THRESHOLD + 1);
                }
            }
            if (!deletia.isEmpty()) {
                Iterator i = deletia.iterator();
                while (i.hasNext()) {
                    this.delMatchArea(((BranchNode)i.next()).getMatchArea());
                }
            }
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.removeSmallCopies(root.getChild(i));
        }
    }

    protected Vector findCandidates(BaseNode tree, BranchNode key) {
        Vector candidates = new Vector();
        this.findExactMatches(tree, key, candidates);
        if (candidates.isEmpty()) {
            this.findFuzzyMatches(tree, key, candidates);
        }
        return candidates;
    }

    protected int dfsMatch(BaseNode a, BranchNode b, int count) {
        return this.dfsMatch(a, b, count, null, null);
    }

    protected int dfsMatch(BaseNode a, BranchNode b, int count, Vector stopNodes, MatchArea ma) {
        int i;
        if (stopNodes != null) {
            this.addMatching(b, a);
            ma.addInfoBytes(a.getContent().getInfoSize());
            b.setMatchArea(ma);
        }
        boolean childrenMatch = true;
        if (a.getChildCount() == b.getChildCount()) {
            for (i = 0; childrenMatch && i < a.getChildCount(); ++i) {
                childrenMatch = a.getChild(i).getContent().contentEquals(b.getChild(i).getContent());
            }
        } else {
            childrenMatch = false;
        }
        if (!childrenMatch) {
            for (i = 0; stopNodes != null && i < b.getChildCount(); ++i) {
                stopNodes.add(b.getChild(i));
            }
        } else {
            if (ma != null) {
                ma.addInfoBytes(a.getChildCount() * 4);
            }
            for (i = 0; i < a.getChildCount(); ++i) {
                count += this.dfsMatch(a.getChild(i), b.getChild(i), 0, stopNodes, ma);
            }
        }
        return count + 1;
    }

    @Override
    public void getAreaStopNodes(Vector stopNodes, BranchNode n) {
        int i;
        boolean childrenInSameArea = true;
        MatchArea parentArea = n.getMatchArea();
        if (parentArea == null) {
            throw new RuntimeException("ASSERT FAILED");
        }
        for (i = 0; i < n.getChildCount() && childrenInSameArea; childrenInSameArea &= n.getChild(i).getMatchArea() == parentArea, ++i) {
        }
        if (n.getChildCount() == 0 && n.getBaseMatch().getChildCount() != 0) {
            childrenInSameArea = false;
        }
        if (!childrenInSameArea) {
            stopNodes.add(n);
            return;
        }
        for (i = 0; i < n.getChildCount(); ++i) {
            this.getAreaStopNodes(stopNodes, n.getChild(i));
        }
    }

    protected boolean dfsTryFuzzyMatch(Node a, Node b) {
        double distance = this.measure.getDistance(a, b);
        return distance < 0.2;
    }

    protected void findExactMatches(BaseNode tree, BranchNode key, Vector candidates) {
        DFSTreeIterator i = new DFSTreeIterator(tree);
        while (i.hasNext()) {
            BaseNode cand = (BaseNode)i.next();
            if (!cand.getContent().contentEquals(key.getContent())) continue;
            candidates.add(new CandidateEntry(cand, 0.0, -1.0));
        }
    }

    protected void findFuzzyMatches(BaseNode tree, BranchNode key, Vector candidates) {
        TreeSet<CandidateEntry> cset = new TreeSet<CandidateEntry>(this.candComp);
        double cutoff = 0.4;
        Iterator i = new DFSTreeIterator(tree);
        while (i.hasNext()) {
            double discount = 1.0;
            BaseNode cand = (BaseNode)i.next();
            double lrdDist = discount * Math.min(Math.min(this.getDistanceOfLeft(key, cand), this.getDistanceOfRight(key, cand)), this.measure.childListDistance(key, cand));
            double minDist = discount * Math.min(lrdDist, this.measure.getDistance(cand, key));
            if (!(minDist < 0.4)) continue;
            cset.add(new CandidateEntry(cand, minDist, lrdDist));
            cutoff = cutoff < 2.0 * minDist ? cutoff : 2.0 * minDist;
        }
        for (CandidateEntry en : cset) {
            if (en.distance > cutoff) break;
            candidates.add(en);
        }
    }

    protected double getDistanceOfLeft(Node a, Node b) {
        if (a.parent == null || b.parent == null) {
            return 1.0;
        }
        if (a.getChildPos() > 0 && b.getChildPos() > 0) {
            return this.measure.getDistance(a.getLeftSibling(), b.getLeftSibling());
        }
        return 1.0;
    }

    protected double getDistanceOfRight(Node a, Node b) {
        if (a.parent == null || b.parent == null) {
            return 1.0;
        }
        if (a.getChildPos() < a.parent.getChildCount() - 1 && b.getChildPos() < b.parent.getChildCount() - 1) {
            return this.measure.getDistance(a.getRightSibling(), b.getRightSibling());
        }
        return 1.0;
    }

    protected void addMatchingIfSameType(BranchNode a, BaseNode b) {
        if (a.getContent() instanceof XMLTextNode && b.getContent() instanceof XMLTextNode || a.getContent() instanceof XMLElementNode && b.getContent() instanceof XMLElementNode) {
            this.addMatching(a, b);
        }
    }

    protected void addMatching(BranchNode a, BaseNode b) {
        a.setBaseMatch(b, 3);
        b.getLeft().addMatch(a);
    }

    protected void delMatching(BranchNode a, BaseNode b) {
        a.delBaseMatch();
        b.getLeft().delMatch(a);
    }

    protected void delMatchArea(MatchArea m) {
        this.delMatchArea(m.getRoot(), m);
    }

    private void delMatchArea(BranchNode n, MatchArea m) {
        if (n.getMatchArea() == m) {
            n.setMatchArea(null);
            this.delMatching(n, n.getBaseMatch());
            for (int i = 0; i < n.getChildCount(); ++i) {
                this.delMatchArea(n.getChild(i), m);
            }
        }
    }

    private boolean isMatched(BaseNode n) {
        return n.getLeft().getMatchCount() > 0;
    }

    class DFSTreeIterator
    implements Iterator {
        Node currentNode = null;
        int currentChild = 0;

        public DFSTreeIterator(Node root) {
            this.currentNode = root;
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != null;
        }

        public Object next() {
            Node result = this.currentNode;
            if (this.currentNode.getChildCount() > 0) {
                this.currentNode = this.currentNode.getChildAsNode(0);
            } else {
                while (this.currentNode != null && (this.currentNode.parent == null || this.currentNode.childPos == this.currentNode.parent.getChildCount() - 1)) {
                    this.currentNode = this.currentNode.parent;
                }
                if (this.currentNode != null) {
                    this.currentNode = this.currentNode.parent.getChildAsNode(this.currentNode.childPos + 1);
                }
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class CandidateEntry {
        BaseNode candidate = null;
        double leftRightDown = 0.0;
        double distance = 0.0;

        CandidateEntry(BaseNode n, double d, double lrd) {
            this.candidate = n;
            this.distance = d;
            this.leftRightDown = lrd;
        }
    }
}

