/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import tdm.lib.BranchNode;
import tdm.lib.DiffAlgorithm;
import tdm.lib.IdIndex;
import tdm.lib.Matching;
import tdm.lib.Node;
import tdm.lib.NodeIndex;
import tdm.lib.XMLElementNode;
import tdm.lib.XMLNode;
import tdm.lib.XMLTextNode;

public class Diff
extends DiffAlgorithm {
    private Configuration cf = DEFAULT_CONFIG;
    private Object branchRoot;
    private ContentHandler ch = null;
    private NodeIndex index = null;
    private Matching m = null;
    private static final Attributes EMPTY_ATTS = new AttributesImpl();
    static final Configuration DEFAULT_CONFIG = new Configuration();
    static final String DIFF_NS = Diff.DEFAULT_CONFIG.DIFF_NS;
    public static final String DIFF_COPY_TAG = DIFF_NS + "copy";
    public static final String DIFF_INS_TAG = DIFF_NS + "insert";
    public static final String DIFF_ESC_TAG = DIFF_NS + "esc";
    public static final String DIFF_ROOT_TAG = "diff";
    public static final String DIFF_CPYSRC_ATTR = "src";
    public static final String DIFF_CPYDST_ATTR = "dst";
    public static final String DIFF_CPYRUN_ATTR = "run";
    public static final String DIFF_ROOTOP_ATTR = "op";
    public static final String DIFF_ROOTOP_INS = "insert";

    public Diff(Matching am) {
        this(am, new BFSIndex(am.getBaseRoot()));
    }

    public Diff(Matching am, NodeIndex aIx) {
        this.index = aIx;
        this.m = am;
        this.branchRoot = am.getBranchRoot();
    }

    public Diff(Configuration aCf, Object aBranchRoot) {
        this.cf = aCf;
        this.branchRoot = aBranchRoot;
    }

    public void diff(ContentHandler ch) throws SAXException {
        this.ch = ch;
        try {
            this.diff(this.branchRoot);
        }
        catch (IOException x) {
            throw new SAXException(x);
        }
    }

    @Override
    public List getStopNodes(Object changeNode) {
        Vector v = new Vector();
        this.m.getAreaStopNodes(v, (BranchNode)changeNode);
        return v;
    }

    @Override
    public Object lookupBase(Object changeNode) {
        return ((BranchNode)changeNode).getBaseMatch();
    }

    public Object getChangeRoot() {
        return this.m.getBranchRoot();
    }

    @Override
    protected void content(Object branch, boolean open) throws IOException {
        try {
            if (branch instanceof DiffAlgorithm.DiffOperation) {
                DiffAlgorithm.DiffOperation op = (DiffAlgorithm.DiffOperation)branch;
                AttributesImpl rootAtts = new AttributesImpl();
                switch (op.getOperation()) {
                    case 2: {
                        this.addAttribute(rootAtts, this.cf.DIFF_ROOTOP_ATTR, this.cf.DIFF_ROOTOP_INS);
                    }
                    case 1: {
                        boolean hasNamespace;
                        boolean bl = hasNamespace = this.cf.DIFF_NS != null && this.cf.DIFF_NS.length() > 0;
                        if (open) {
                            this.ch.startDocument();
                            if (hasNamespace) {
                                this.ch.startPrefixMapping(DIFF_ROOT_TAG, this.cf.DIFF_NS);
                            }
                            this.startElem(this.ch, this.cf.DIFF_ROOT_TAG, rootAtts);
                            break;
                        }
                        this.endElem(this.ch, this.cf.DIFF_ROOT_TAG);
                        if (hasNamespace) {
                            this.ch.endPrefixMapping(DIFF_ROOT_TAG);
                        }
                        this.ch.endDocument();
                        break;
                    }
                    case 3: {
                        if (open) {
                            this.openCopy(op.getSource(), op.getDestination(), op.getRun(), this.ch);
                            break;
                        }
                        this.endElem(this.ch, this.cf.DIFF_COPY_TAG);
                        break;
                    }
                    case 4: {
                        if (open) {
                            AttributesImpl atts = new AttributesImpl();
                            if (op.getDestination() != null) {
                                this.addAttribute(atts, this.cf.DIFF_CPYDST_ATTR, this.identify(op.getDestination()));
                            }
                            this.startElem(this.ch, this.cf.DIFF_INS_TAG, atts);
                            break;
                        }
                        this.endElem(this.ch, this.cf.DIFF_INS_TAG);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown diffop: " + op.getOperation());
                    }
                }
                return;
            }
            XMLNode content = ((BranchNode)branch).getContent();
            if (content instanceof XMLTextNode) {
                if (!open) {
                    return;
                }
                XMLTextNode ct = (XMLTextNode)content;
                this.ch.characters(ct.getText(), 0, ct.getText().length);
            } else {
                XMLElementNode ce = (XMLElementNode)content;
                if (open) {
                    this.ch.startElement(ce.getNamespaceURI(), ce.getLocalName(), ce.getQName(), ce.getAttributes());
                } else {
                    this.ch.endElement(ce.getNamespaceURI(), ce.getLocalName(), ce.getQName());
                }
            }
        }
        catch (SAXException x) {
            throw new IOException(x.getMessage());
        }
    }

    protected void addAttribute(AttributesImpl a, String name, String value) {
        if (this.cf.useQName) {
            a.addAttribute("", "", name, "CDATA", value);
        } else {
            a.addAttribute("", name, "", "CDATA", value);
        }
    }

    protected void startElem(ContentHandler c, String name, Attributes atts) throws SAXException {
        if (this.cf.useQName) {
            c.startElement("", "", name, atts);
        } else {
            c.startElement(this.cf.DIFF_NS, name, "", atts);
        }
    }

    protected void endElem(ContentHandler c, String name) throws SAXException {
        if (this.cf.useQName) {
            c.endElement("", "", name);
        } else {
            c.endElement(this.cf.DIFF_NS, name, "");
        }
    }

    protected void openCopy(Object src, Object dst, Long run, ContentHandler ch) throws SAXException {
        AttributesImpl copyAtts = new AttributesImpl();
        this.addAttribute(copyAtts, this.cf.DIFF_CPYSRC_ATTR, this.identify(src));
        if (dst != DiffAlgorithm.DiffOperation.NO_VALUE) {
            this.addAttribute(copyAtts, this.cf.DIFF_CPYDST_ATTR, this.identify(dst));
        }
        if (run != DiffAlgorithm.DiffOperation.NO_VALUE) {
            this.addAttribute(copyAtts, this.cf.DIFF_CPYRUN_ATTR, run.toString());
        }
        this.startElem(ch, this.cf.DIFF_COPY_TAG, copyAtts);
    }

    protected void closeCopy(ContentHandler ch) throws SAXException {
        this.endElem(ch, this.cf.DIFF_COPY_TAG);
    }

    public boolean needsEscape(Object changeNode) {
        XMLNode content = ((BranchNode)changeNode).getContent();
        return content instanceof XMLElementNode && Diff.DEFAULT_CONFIG.RESERVED.contains(((XMLElementNode)content).getQName());
    }

    @Override
    public Iterator getChildIterator(Object changeNode) {
        return ((BranchNode)changeNode).children.listIterator();
    }

    @Override
    public boolean appends(Object tail, Object next) {
        return ((Number)this.index.getId(next)).longValue() == ((Number)this.index.getId(tail)).longValue() + 1L;
    }

    public String identify(Object node) {
        return this.index.getId(node).toString();
    }

    public static class Configuration {
        protected Set RESERVED = null;
        protected String DIFF_NS = "";
        protected String DIFF_COPY_TAG = this.DIFF_NS + "copy";
        protected String DIFF_INS_TAG = this.DIFF_NS + "insert";
        protected String DIFF_ESC_TAG = this.DIFF_NS + "esc";
        protected String DIFF_ROOT_TAG = "diff";
        protected String DIFF_CPYSRC_ATTR = "src";
        protected String DIFF_CPYDST_ATTR = "dst";
        protected String DIFF_CPYRUN_ATTR = "run";
        protected String DIFF_ROOTOP_ATTR = "op";
        protected final String DIFF_ROOTOP_INS = "insert";
        protected boolean useQName = true;

        public Configuration() {
            this.init();
        }

        public Configuration(String aNameSpace, String aCopyTag, String aInsTag, String aEscTag, String aRootTag, String aCopySrcAttr, String aCopyDstAttr, String aCopyRunAttr, String aRootOpAttr, boolean aUseQNames) {
            this.DIFF_NS = aNameSpace;
            this.DIFF_COPY_TAG = aCopyTag;
            this.DIFF_INS_TAG = aInsTag;
            this.DIFF_ESC_TAG = aEscTag;
            this.DIFF_ROOT_TAG = aRootTag;
            this.DIFF_CPYSRC_ATTR = aCopySrcAttr;
            this.DIFF_CPYDST_ATTR = aCopyDstAttr;
            this.DIFF_CPYRUN_ATTR = aCopyRunAttr;
            this.DIFF_ROOTOP_ATTR = aRootOpAttr;
            this.useQName = aUseQNames;
            this.init();
        }

        protected void init() {
            this.RESERVED = new HashSet();
            this.RESERVED.add(this.DIFF_COPY_TAG);
            this.RESERVED.add(this.DIFF_INS_TAG);
            this.RESERVED.add(this.DIFF_ESC_TAG);
        }
    }

    static class BFSIndex
    implements NodeIndex,
    IdIndex {
        protected Map nodeToNumber = new HashMap();
        protected Map numberToNode = new HashMap();
        private Object rootId = null;

        public BFSIndex(Node root) {
            int id = 0;
            LinkedList<Node> queue = new LinkedList<Node>();
            queue.add(root);
            while (!queue.isEmpty()) {
                Node n = (Node)queue.removeFirst();
                this.nodeToNumber.put(n, new Long(id));
                this.numberToNode.put(String.valueOf(id), n);
                for (int i = 0; i < n.getChildCount(); ++i) {
                    queue.add(n.getChildAsNode(i));
                }
                ++id;
            }
            this.rootId = this.getId(root).toString();
        }

        @Override
        public Object getId(Object n) {
            return this.nodeToNumber.get(n);
        }

        @Override
        public Node lookup(Object id) {
            return (Node)this.numberToNode.get(id.toString());
        }

        @Override
        public Object getRootId() {
            return this.rootId;
        }
    }
}

