/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package tdm.lib;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/**
 *
 * @author dkjellin
 */
public class StaxWrapperParser {
    
    
    public static Node parse(NodeFactory nodefactory, XMLEventReader delegate) throws ParseException
    {
        try{
            XMLParser parser = new XMLParser(nodefactory);
             parser.startDocument();
             while(delegate.hasNext())
        {
            
            XMLEvent nextElement = delegate.nextEvent();
            if(nextElement.isStartElement())
            {
               StartElement start = ((StartElement)nextElement);
               List<Attribute> attrlist = new ArrayList<Attribute>();
                for (Iterator<Attribute> i=start.getAttributes();i.hasNext();) {
                    attrlist.add(i.next());
                }
                String prefix =((StartElement)nextElement).getName().getPrefix();
                String qname = prefix +(prefix.length()>0?":":"") +((StartElement)nextElement).getName().getLocalPart();
                
               parser.startElement("","",qname, attrlist);                 
               
            }
            else if(nextElement.isEndElement())
            {
                parser.endElement();
            } 
            else if(nextElement.isCharacters())
            {
                Characters c = nextElement.asCharacters();
                    String data = c.getData();
                    parser.characters(data,c.isCData());
            }
            else
            {
//                System.out.println("Missed event: " +nextElement);
            }
            
        }
            parser.endDocument();
            return parser.getRoot();
        }
        catch(Exception FIXME)
        {
           FIXME.printStackTrace();
           return null;
        }
    }
    
}
