AJS.toInit(function ($) {

    $('#supporting-site-search-form').append($('#query-string')).append('&nbsp;').append($('#search-query-submit-button')).append('&nbsp;').append($('#search-filter-reset-span'));
    $('#site-search-form').prepend('<input type="hidden" id="hidden-query-string" name="queryString">');

    /* Transfers the search query from the top form over to the actual search form */
    function transferQueryStringValue() {
        $("#hidden-query-string").val($("#query-string").val());
    };

    $("#supporting-site-search-form").submit(function (e) {
        transferQueryStringValue();
        $("#site-search-form").submit();

		e.preventDefault();
		return false; 
	});

	$("#search-filter-by-space").change(function (e) {
		$("#site-search-form").submit();
	});
	
	$("#search-filter-by-type").change(function (e) {
		$("#site-search-form").submit();
	});

	$("#search-filter-by-lastmodified").change(function (e) {
		$("#site-search-form").submit();
	});

	// set timeout on ajax json requests to 15s
	$.ajaxSetup({timeout: 15000});
	
	$("#search-filter-by-contributor-autocomplete").autocomplete(contextPath + "/json/usersearch.action?query=", 2, function (data) {
		$("#search-filter-by-contributor-hidden").val(data.username); 
	});

	$("#site-search-form").submit(function(e) {
        transferQueryStringValue();
		// decide on whether the last selection made in the autocomplete list has since been over-typed
		// and if it has use the content of the field instead of the hidden field populated by the last selection.
		if ($("#search-filter-by-contributor-autocomplete")[0].lastSelectedValue != $("#search-filter-by-contributor-autocomplete").val()) {
			$("#search-filter-by-contributor-hidden").val("");
		}
	});
});

