/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.collections;

import java.util.Map;
import java.util.Objects;

class MapBackedEntry<K, V>
implements Map.Entry<K, V> {
    private final Map<K, V> map;
    private final K key;

    MapBackedEntry(K key, Map<K, V> map) {
        this.map = map;
        this.key = key;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.map.get(this.key);
    }

    @Override
    public V setValue(V value) {
        return this.map.put(this.key, value);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry e = (Map.Entry)o;
        return Objects.equals(this.getKey(), e.getKey()) && Objects.equals(this.getValue(), e.getValue());
    }

    @Override
    public int hashCode() {
        return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
    }
}

