/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import bucket.core.persistence.hibernate.schema.SchemaHelper;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.upgrade.BuildNumComparator;
import com.atlassian.confluence.upgrade.DatabaseUpgradeTask;
import com.atlassian.confluence.upgrade.UpgradeError;
import com.atlassian.confluence.upgrade.UpgradeException;
import com.atlassian.confluence.upgrade.UpgradeManager;
import com.atlassian.confluence.upgrade.UpgradeTask;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUpgradeManager
implements UpgradeManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractUpgradeManager.class);
    private ApplicationConfiguration applicationConfig;
    private SchemaHelper schemaHelper;
    private List<UpgradeTask> upgradeTasks = new ArrayList<UpgradeTask>();
    private List<UpgradeTask> preSchemaUpgradeTasks = new ArrayList<UpgradeTask>();
    private List<UpgradeTask> schemaUpgradeTasks = new ArrayList<UpgradeTask>();
    private final List<UpgradeError> errors = new ArrayList<UpgradeError>();
    private AtomicBoolean upgraded = new AtomicBoolean(true);
    protected final Comparator<String> buildNumberComp = new BuildNumComparator();

    public void setApplicationConfig(ApplicationConfiguration applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public void setSchemaHelper(SchemaHelper schemaHelper) {
        this.schemaHelper = schemaHelper;
    }

    @Override
    public void upgrade(JohnsonEventContainer agentJohnson) throws UpgradeException {
        List<UpgradeError> upgradePreReqErrors = this.runUpgradePrerequisites();
        if (upgradePreReqErrors.size() > 0) {
            this.upgraded.set(false);
            this.errors.addAll(upgradePreReqErrors);
            this.addJohnsonEvent(agentJohnson);
            return;
        }
        boolean needUpgrade = this.needUpgrade();
        boolean needSchemaUpgrade = Boolean.getBoolean("atlassian.forceSchemaUpdate") || needUpgrade;
        try {
            if (needSchemaUpgrade) {
                this.validateSchemaUpgradeTasks(this.getPreSchemaUpgradeTasks());
                this.schemaHelper.validateSchemaUpdateIfNeeded();
                this.validateSchemaUpgradeTasks(this.getSchemaUpgradeTasks());
            }
            if (needUpgrade) {
                this.validateUpgradeTasks(this.getUpgradeTasks());
            }
        }
        catch (UpgradeException e) {
            this.upgraded.set(false);
            this.addJohnsonValidationEvent(agentJohnson);
            throw e;
        }
        catch (ConfigurationException e) {
            this.upgraded.set(false);
            this.errors.add(new UpgradeError(e));
            this.addJohnsonValidationEvent(agentJohnson);
            throw new UpgradeException(e);
        }
        try {
            if (needSchemaUpgrade) {
                this.runSchemaUpgradeTasks(this.getPreSchemaUpgradeTasks());
                this.schemaHelper.updateSchemaIfNeeded();
                this.runSchemaUpgradeTasks(this.getSchemaUpgradeTasks());
            }
            if (needUpgrade) {
                this.runUpgradeTasks(this.getUpgradeTasks());
            }
            this.upgraded.set(true);
        }
        catch (UpgradeException e) {
            this.upgraded.set(false);
            this.addJohnsonEvent(agentJohnson);
            throw e;
        }
        catch (ConfigurationException e) {
            this.upgraded.set(false);
            this.errors.add(new UpgradeError(e));
            this.addJohnsonEvent(agentJohnson);
            throw new UpgradeException(e);
        }
    }

    private void validateSchemaUpgradeTasks(List<UpgradeTask> upgradeTasks) throws UpgradeException {
        this.executeUpgradeStep(upgradeTasks, UpgradeStep.SCHEMA_VALIDATION);
    }

    private void runSchemaUpgradeTasks(List<UpgradeTask> upgradeTasks) throws UpgradeException {
        this.executeUpgradeStep(upgradeTasks, UpgradeStep.SCHEMA_UPGRADE);
    }

    private void validateUpgradeTasks(List<UpgradeTask> upgradeTasks) throws UpgradeException {
        this.executeUpgradeStep(upgradeTasks, UpgradeStep.VALIDATION);
    }

    private void runUpgradeTasks(List<UpgradeTask> upgradeTasks) throws UpgradeException {
        this.upgradeStarted();
        this.executeUpgradeStep(upgradeTasks, UpgradeStep.UPGRADE);
        try {
            this.upgradeFinished();
        }
        catch (Exception e) {
            this.errors.add(new UpgradeError(e));
            throw new UpgradeException(e);
        }
    }

    private void executeUpgradeStep(List<UpgradeTask> upgradeTasks, UpgradeStep step) throws UpgradeException {
        String localConfigurationBuildNumber = this.getConfiguredBuildNumber();
        String databaseBuildNumber = this.getDatabaseBuildNumber();
        for (UpgradeTask upgradeTask : upgradeTasks) {
            boolean taskNewerThanDatabase;
            boolean taskNewerThanHome = this.buildNumberComp.compare(localConfigurationBuildNumber, upgradeTask.getBuildNumber()) < 0;
            boolean bl = taskNewerThanDatabase = this.buildNumberComp.compare(databaseBuildNumber, upgradeTask.getBuildNumber()) < 0;
            if (!taskNewerThanHome) continue;
            try {
                if (upgradeTask instanceof DatabaseUpgradeTask) {
                    if (taskNewerThanDatabase && this.permitDatabaseUpgrades()) {
                        step.execute(upgradeTask);
                        if (step.shouldUpdateBuildNumber() && CollectionUtils.isEmpty(upgradeTask.getErrors())) {
                            this.setDatabaseBuildNumber(upgradeTask.getBuildNumber());
                        }
                    } else {
                        step.executeNonDatabase(upgradeTask);
                    }
                } else {
                    step.execute(upgradeTask);
                }
                if (!CollectionUtils.isEmpty(upgradeTask.getErrors())) {
                    throw new UpgradeException("Upgrade task " + upgradeTask + " failed during the " + (Object)((Object)step) + " phase");
                }
                if (!step.shouldUpdateBuildNumber()) continue;
                this.upgradeTaskSucceeded(upgradeTask);
            }
            catch (UpgradeException e) {
                throw e;
            }
            catch (Throwable e) {
                this.errors.add(new UpgradeError(e));
                throw new UpgradeException("Upgrade task " + upgradeTask + " failed during the " + (Object)((Object)step) + " phase " + "due to: " + e.getMessage(), e);
            }
            finally {
                if (!CollectionUtils.isEmpty(upgradeTask.getErrors())) {
                    this.errors.addAll(upgradeTask.getErrors());
                }
                if (!step.isUpgrade()) continue;
                this.postUpgrade();
            }
        }
    }

    protected void upgradeTaskSucceeded(UpgradeTask upgradeTask) throws Exception {
        this.setConfiguredBuildNumber(upgradeTask.getBuildNumber());
    }

    private void addJohnsonValidationEvent(JohnsonEventContainer johnson) {
        this.addJohnsonEvent(johnson, "Pre upgrade validation failed. Please consult the system logs for details. You will need to fix these problems and restart.");
    }

    private void addJohnsonEvent(JohnsonEventContainer johnson) {
        this.addJohnsonEvent(johnson, "Upgrade failed. Please consult the system logs for details. You will need to fix these problems, restore your database and confluence home directory to the pre upgrade state. Then retry the upgrade.");
    }

    private void addJohnsonEvent(JohnsonEventContainer johnson, String message) {
        if (johnson != null) {
            johnson.addEvent(new Event(EventType.get((String)"upgrade"), message, EventLevel.get((String)"error")));
        }
    }

    protected void upgradeStarted() {
        log.info("Starting automatic upgrade of Confluence");
    }

    public List<UpgradeTask> getPreSchemaUpgradeTasks() {
        return this.preSchemaUpgradeTasks;
    }

    public void setPreSchemaUpgradeTasks(List<UpgradeTask> preSchemaUpgradeTasks) {
        this.preSchemaUpgradeTasks = preSchemaUpgradeTasks;
    }

    public void setUpgradeTasks(List<UpgradeTask> upgradeTasks) {
        this.assertNoDuplicateBuildNumbers(upgradeTasks);
        this.upgradeTasks = upgradeTasks;
    }

    private void assertNoDuplicateBuildNumbers(List<UpgradeTask> upgradeTasks) throws IllegalStateException {
        HashSet buildNumbers = Sets.newHashSet();
        for (UpgradeTask upgradeTask : upgradeTasks) {
            if (buildNumbers.contains(upgradeTask.getBuildNumber())) {
                throw new IllegalStateException("Duplicate build number for upgrade task: " + upgradeTask.getClass().getName() + ", " + "build number: " + upgradeTask.getBuildNumber());
            }
            buildNumbers.add(upgradeTask.getBuildNumber());
        }
    }

    public List<UpgradeTask> getUpgradeTasks() {
        return this.upgradeTasks;
    }

    public void setSchemaUpgradeTasks(List<UpgradeTask> upgradeTasks) {
        this.schemaUpgradeTasks = upgradeTasks;
    }

    public List<UpgradeTask> getSchemaUpgradeTasks() {
        return this.schemaUpgradeTasks;
    }

    @Override
    public List<UpgradeError> getErrors() {
        return this.errors;
    }

    protected abstract List<UpgradeError> runUpgradePrerequisites();

    protected String getConfiguredBuildNumber() {
        return this.applicationConfig.getBuildNumber();
    }

    protected void setConfiguredBuildNumber(String buildNumber) throws ConfigurationException {
        if (this.buildNumberComp.compare(this.applicationConfig.getBuildNumber(), buildNumber) < 0) {
            this.applicationConfig.setBuildNumber(buildNumber);
            this.applicationConfig.save();
        }
    }

    @Override
    public boolean needUpgrade() {
        boolean afterSetup = this.applicationConfig.isSetupComplete();
        try {
            int realBuildNumber = Integer.parseInt(this.getRealBuildNumber());
            int configuredBuildNumber = Integer.parseInt(this.getConfiguredBuildNumber());
            boolean differentBuildNumbers = realBuildNumber != configuredBuildNumber;
            return afterSetup && differentBuildNumbers;
        }
        catch (NumberFormatException e) {
            log.warn("Skipping upgrade because build numbers cannot be compared (application: \"{}\", configuration: \"{}\")", (Object)this.getRealBuildNumber(), (Object)this.getConfiguredBuildNumber());
            return false;
        }
    }

    protected void upgradeFinished() throws Exception {
        if (this.errors.isEmpty()) {
            if (this.permitDatabaseUpgrades()) {
                this.setDatabaseBuildNumber(this.getRealBuildNumber());
            }
            this.setConfiguredBuildNumber(this.getRealBuildNumber());
        }
        log.info("Upgrade completed successfully");
    }

    protected abstract String getRealBuildNumber();

    protected abstract String getDatabaseBuildNumber();

    protected abstract void setDatabaseBuildNumber(String var1) throws Exception;

    protected boolean permitDatabaseUpgrades() throws UpgradeException {
        return true;
    }

    protected void postUpgrade() {
    }

    @Override
    public boolean isUpgraded() {
        return this.upgraded.get();
    }

    private static enum UpgradeStep {
        SCHEMA_VALIDATION{

            @Override
            public void execute(UpgradeTask upgradeTask) throws Exception {
                upgradeTask.validate();
            }
        }
        ,
        VALIDATION{

            @Override
            public void execute(UpgradeTask upgradeTask) throws Exception {
                upgradeTask.validate();
            }
        }
        ,
        SCHEMA_UPGRADE{

            @Override
            public void execute(UpgradeTask upgradeTask) throws Exception {
                upgradeTask.doUpgrade();
            }
        }
        ,
        UPGRADE{

            @Override
            public void execute(UpgradeTask upgradeTask) throws Exception {
                upgradeTask.doUpgrade();
            }
        };


        public boolean isValidation() {
            return this == SCHEMA_VALIDATION || this == VALIDATION;
        }

        public boolean isUpgrade() {
            return this == SCHEMA_UPGRADE || this == UPGRADE;
        }

        public boolean shouldUpdateBuildNumber() {
            return this == UPGRADE;
        }

        public abstract void execute(UpgradeTask var1) throws Exception;

        public void executeNonDatabase(UpgradeTask upgradeTask) {
            if (this.isValidation()) {
                ((DatabaseUpgradeTask)upgradeTask).nonDatabaseValidate();
            } else if (this.isUpgrade()) {
                ((DatabaseUpgradeTask)upgradeTask).doNonDatabaseUpgrade();
            }
        }
    }
}

