/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.config.lifecycle.LifecycleContext;
import com.atlassian.config.lifecycle.LifecycleItem;
import com.atlassian.confluence.upgrade.UpgradeError;
import com.atlassian.confluence.upgrade.UpgradeException;
import com.atlassian.confluence.upgrade.UpgradeManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeLifecycleItem
implements LifecycleItem {
    private static final Logger log = LoggerFactory.getLogger(UpgradeLifecycleItem.class);
    private UpgradeManager upgradeManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup(LifecycleContext context) throws Exception {
        block6: {
            try {
                this.upgradeManager.upgrade(context.getAgentJohnson());
            }
            catch (UpgradeException e) {
                log.error("Upgrade failed, application will not start: " + e.getMessage(), (Throwable)((Object)e));
            }
            finally {
                List<UpgradeError> errors = this.upgradeManager.getErrors();
                if (errors == null || errors.isEmpty()) break block6;
                log.error(String.valueOf(errors.size()) + " errors were encountered during upgrade:");
                int i = 1;
                for (UpgradeError error : errors) {
                    log.error(String.valueOf(i++) + ": " + error.getMessage());
                }
            }
        }
    }

    public void shutdown(LifecycleContext context) throws Exception {
    }

    public void setUpgradeManager(UpgradeManager upgradeManager) {
        this.upgradeManager = upgradeManager;
    }
}

