/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.upgrade.UpgradeError;
import com.atlassian.confluence.upgrade.UpgradeException;
import com.atlassian.confluence.upgrade.UpgradeManager;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.spring.container.ContainerManager;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeLauncherServletContextListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(UpgradeLauncherServletContextListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent event) {
        block7: {
            JohnsonEventContainer johnsonEvent = JohnsonEventContainer.get((ServletContext)event.getServletContext());
            if (BootstrapUtils.getBootstrapManager() != null && BootstrapUtils.getBootstrapManager().isSetupComplete() && !this.hasLicenseError(johnsonEvent)) {
                UpgradeManager upgradeManager = (UpgradeManager)ContainerManager.getComponent((String)"upgradeManager");
                try {
                    if (!ContainerManager.isContainerSetup()) break block7;
                    upgradeManager.upgrade(johnsonEvent);
                }
                catch (UpgradeException e) {
                    log.error("Upgrade failed, application will not start: " + e.getMessage(), (Throwable)((Object)e));
                }
                finally {
                    List<UpgradeError> errors = upgradeManager.getErrors();
                    if (errors == null || errors.isEmpty()) break block7;
                    log.error(String.valueOf(errors.size()) + " errors were encountered during upgrade:");
                    int i = 1;
                    for (UpgradeError error : errors) {
                        log.error(String.valueOf(i) + ": " + error.getMessage());
                        ++i;
                    }
                }
            }
        }
    }

    private boolean hasLicenseError(JohnsonEventContainer johnsonEvent) {
        if (johnsonEvent.hasEvents()) {
            for (Object o : johnsonEvent.getEvents()) {
                Event e = (Event)o;
                if (!"license-inconsistency".equals(e.getKey().getType())) continue;
                return true;
            }
        }
        return false;
    }

    public void contextDestroyed(ServletContextEvent event) {
    }
}

