/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import bucket.core.persistence.hibernate.schema.SchemaHelper;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.upgrade.BuildNumComparator;
import com.atlassian.confluence.upgrade.DatabaseUpgradeTask;
import com.atlassian.confluence.upgrade.UpgradeError;
import com.atlassian.confluence.upgrade.UpgradeException;
import com.atlassian.confluence.upgrade.UpgradeManager;
import com.atlassian.confluence.upgrade.UpgradeTask;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUpgradeManager
implements UpgradeManager {
    @Deprecated
    protected static final Logger log = Logger.getLogger(AbstractUpgradeManager.class);
    private ApplicationConfiguration applicationConfig;
    private SchemaHelper schemaHelper;
    private List<UpgradeTask> upgradeTasks = new ArrayList<UpgradeTask>();
    private List<UpgradeTask> preSchemaUpgradeTasks = new ArrayList<UpgradeTask>();
    private List<UpgradeTask> schemaUpgradeTasks = new ArrayList<UpgradeTask>();
    private final List<UpgradeError> errors = new ArrayList<UpgradeError>();
    private AtomicBoolean upgraded = new AtomicBoolean(true);
    protected final Comparator<String> buildNumberComp = new BuildNumComparator();

    public void setApplicationConfig(ApplicationConfiguration applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public void setSchemaHelper(SchemaHelper schemaHelper) {
        this.schemaHelper = schemaHelper;
    }

    @Override
    public void upgrade(JohnsonEventContainer agentJohnson) throws UpgradeException {
        try {
            List<String> failureMessages = this.runUpgradePrerequisites();
            if (failureMessages.size() > 0) {
                this.upgraded.set(false);
                for (String failureMessage : failureMessages) {
                    log.warn((Object)failureMessage);
                    this.addJohnsonEvent(agentJohnson, failureMessage);
                }
                return;
            }
            boolean needUpgrade = this.needUpgrade();
            if (Boolean.getBoolean("atlassian.forceSchemaUpdate") || needUpgrade) {
                this.upgradeSchema();
            }
            if (needUpgrade) {
                this.upgradeStarted();
                this.doUpgrade();
                this.upgradeFinished();
            }
            this.upgraded.set(true);
        }
        catch (UpgradeException e) {
            this.upgraded.set(false);
            this.addJohnsonEvent(agentJohnson);
            throw e;
        }
        catch (Throwable e) {
            this.upgraded.set(false);
            log.error((Object)("Exception thrown during upgrade: " + e.getMessage()), e);
            this.errors.add(new UpgradeError(e));
            this.addJohnsonEvent(agentJohnson);
            throw new UpgradeException(e);
        }
    }

    protected void doUpgrade() throws Throwable {
        try {
            String localConfigurationBuildNumber = this.getConfiguredBuildNumber();
            String databaseBuildNumber = this.getDatabaseBuildNumber();
            List<UpgradeTask> upgradeTasks = this.getUpgradeTasks();
            for (UpgradeTask upgradeTask : upgradeTasks) {
                boolean patchBuildGreaterThanDatabase;
                boolean patchBuildGreaterThanCurrent = this.buildNumberComp.compare(localConfigurationBuildNumber, upgradeTask.getBuildNumber()) < 0;
                boolean bl = patchBuildGreaterThanDatabase = this.buildNumberComp.compare(databaseBuildNumber, upgradeTask.getBuildNumber()) < 0;
                if (!patchBuildGreaterThanCurrent) continue;
                try {
                    if (upgradeTask instanceof DatabaseUpgradeTask) {
                        if (patchBuildGreaterThanDatabase && this.permitDatabaseUpgrades()) {
                            upgradeTask.doUpgrade();
                        } else {
                            ((DatabaseUpgradeTask)upgradeTask).doNonDatabaseUpgrade();
                        }
                    } else {
                        upgradeTask.doUpgrade();
                    }
                    this.upgradeTaskSucceeded(upgradeTask);
                }
                catch (Exception e) {
                    this.upgradeTaskFailed(upgradeTask, e);
                    throw e;
                }
                finally {
                    if (upgradeTask.getErrors() != null) {
                        this.errors.addAll(upgradeTask.getErrors());
                    }
                    this.postUpgrade();
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)("Upgrade failed: " + e.getMessage()), e);
            throw new UpgradeException(e);
        }
    }

    protected void upgradeSchema() throws ConfigurationException, UpgradeException {
        this.runSchemaUpgradeTasks(this.preSchemaUpgradeTasks);
        this.schemaHelper.updateSchemaIfNeeded();
        this.runSchemaUpgradeTasks(this.getSchemaUpgradeTasks());
    }

    private void runSchemaUpgradeTasks(List<UpgradeTask> upgradeTasks) throws UpgradeException {
        String currentBuildNumber = this.getConfiguredBuildNumber();
        for (UpgradeTask upgradeTask : upgradeTasks) {
            boolean patchBuildGreaterThanCurrent = this.buildNumberComp.compare(currentBuildNumber, upgradeTask.getBuildNumber()) < 0;
            if (!patchBuildGreaterThanCurrent) continue;
            try {
                upgradeTask.doUpgrade();
            }
            catch (Exception e) {
                this.errors.add(new UpgradeError(e));
                throw new UpgradeException("Schema upgrade task [ " + upgradeTask + " ] failed due to : " + e.getMessage(), e);
            }
        }
    }

    protected void upgradeTaskSucceeded(UpgradeTask upgradeTask) throws ConfigurationException {
        this.setConfiguredBuildNumber(upgradeTask.getBuildNumber());
    }

    protected void upgradeTaskFailed(UpgradeTask upgradeTask, Throwable e) {
        if (upgradeTask.getErrors() == null || upgradeTask.getErrors().size() == 0) {
            this.errors.add(new UpgradeError(e));
        }
    }

    private void addJohnsonEvent(JohnsonEventContainer johnson) {
        this.addJohnsonEvent(johnson, "Upgrade failed. Please consult the system logs for details. You will need to fix these problems and restart.");
    }

    private void addJohnsonEvent(JohnsonEventContainer johnson, String message) {
        if (johnson != null) {
            johnson.addEvent(new Event(EventType.get((String)"upgrade"), message, EventLevel.get((String)"error")));
        }
    }

    protected void upgradeStarted() throws Exception {
        log.info((Object)"Starting automatic upgrade of Confluence");
    }

    public void setPreSchemaUpgradeTasks(List<UpgradeTask> preSchemaUpgradeTasks) {
        this.preSchemaUpgradeTasks = preSchemaUpgradeTasks;
    }

    public void setUpgradeTasks(List<UpgradeTask> upgradeTasks) {
        this.upgradeTasks = upgradeTasks;
    }

    public List<UpgradeTask> getUpgradeTasks() {
        return this.upgradeTasks;
    }

    public void setSchemaUpgradeTasks(List<UpgradeTask> upgradeTasks) {
        this.schemaUpgradeTasks = upgradeTasks;
    }

    public List<UpgradeTask> getSchemaUpgradeTasks() {
        return this.schemaUpgradeTasks;
    }

    @Override
    public List<UpgradeError> getErrors() {
        return this.errors;
    }

    protected abstract List<String> runUpgradePrerequisites();

    protected String getConfiguredBuildNumber() {
        return this.applicationConfig.getBuildNumber();
    }

    protected void setConfiguredBuildNumber(String buildNumber) throws ConfigurationException {
        this.applicationConfig.setBuildNumber(buildNumber);
        this.applicationConfig.save();
    }

    @Override
    public boolean needUpgrade() {
        boolean afterSetup = this.applicationConfig.isSetupComplete();
        try {
            int realBuildNumber = Integer.parseInt(this.getRealBuildNumber());
            int configuredBuildNumber = Integer.parseInt(this.getConfiguredBuildNumber());
            boolean differentBuildNumbers = realBuildNumber != configuredBuildNumber;
            return afterSetup && differentBuildNumbers;
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Skipping upgrade because build numbers cannot be compared (application: \"" + this.getRealBuildNumber() + "\", " + "configuration: \"" + this.getConfiguredBuildNumber() + "\")"));
            return false;
        }
    }

    protected void upgradeFinished() throws Exception {
        if (this.errors.isEmpty()) {
            this.setDatabaseBuildNumber(this.getRealBuildNumber());
            this.applicationConfig.setBuildNumber(this.getRealBuildNumber());
            this.applicationConfig.save();
        }
        log.info((Object)"Upgrade completed successfully");
    }

    protected abstract String getRealBuildNumber();

    protected abstract String getDatabaseBuildNumber();

    protected abstract void setDatabaseBuildNumber(String var1) throws Exception;

    protected boolean permitDatabaseUpgrades() throws UpgradeException {
        return true;
    }

    protected void postUpgrade() {
    }

    @Override
    public boolean isUpgraded() {
        return this.upgraded.get();
    }
}

