/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.serialization;

import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.reference.EnrichableMap;
import com.atlassian.confluence.api.serialization.ApiSerializerModuleFactory;
import com.atlassian.confluence.rest.api.model.RestList;
import com.atlassian.confluence.rest.serialization.CollapsedSerializer;
import com.atlassian.confluence.rest.serialization.ContentTypeSerializer;
import com.atlassian.confluence.rest.serialization.CustomValueInstantiators;
import com.atlassian.confluence.rest.serialization.DateTimeDeserializer;
import com.atlassian.confluence.rest.serialization.DateTimeSerializer;
import com.atlassian.confluence.rest.serialization.EnrichedMapDeserializer;
import com.atlassian.confluence.rest.serialization.JsonStringDeserializer;
import com.atlassian.confluence.rest.serialization.JsonStringSerializer;
import com.atlassian.confluence.rest.serialization.OptionSerializer;
import com.atlassian.confluence.rest.serialization.PageResponseSerializer;
import com.atlassian.confluence.rest.serialization.ReferenceSerializer;
import com.atlassian.confluence.rest.serialization.RestEntitySerializer;
import com.atlassian.confluence.rest.serialization.RestListDeserializer;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.BeanDescription;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.Deserializers;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.Serializers;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.deser.ValueInstantiators;
import org.codehaus.jackson.map.module.SimpleDeserializers;
import org.codehaus.jackson.map.module.SimpleSerializers;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.type.JavaType;
import org.joda.time.DateTime;

public class SerializerModule
extends Module {
    static final SerializerModule INSTANCE = new SerializerModule();

    public String getModuleName() {
        return "Custom Confluence Serializers";
    }

    public Version version() {
        return new Version(1, 0, 0, null);
    }

    public void setupModule(Module.SetupContext setupContext) {
        SimpleSerializers customSerializers = new SimpleSerializers();
        customSerializers.addSerializer((JsonSerializer)new OptionSerializer());
        customSerializers.addSerializer((JsonSerializer)new RestEntitySerializer());
        customSerializers.addSerializer((JsonSerializer)new DateTimeSerializer());
        customSerializers.addSerializer((JsonSerializer)new JsonStringSerializer());
        customSerializers.addSerializer((JsonSerializer)new ContentTypeSerializer());
        customSerializers.addSerializer((JsonSerializer)new ReferenceSerializer());
        customSerializers.addSerializer((JsonSerializer)new CollapsedSerializer());
        customSerializers.addSerializer((JsonSerializer)new PageResponseSerializer());
        for (JsonSerializer serializer : ApiSerializerModuleFactory.getApiSerializers()) {
            customSerializers.addSerializer(serializer);
        }
        setupContext.addSerializers((Serializers)customSerializers);
        SimpleDeserializers deserializers = new SimpleDeserializers();
        for (Map.Entry deserEntry : ApiSerializerModuleFactory.getApiDeserializers().entrySet()) {
            deserializers.addDeserializer((Class)deserEntry.getKey(), (JsonDeserializer)deserEntry.getValue());
        }
        setupContext.addDeserializers((Deserializers)new ConfluenceJacksonDeserializers());
        setupContext.addValueInstantiators((ValueInstantiators)new CustomValueInstantiators());
    }

    public static class ConfluenceJacksonDeserializers
    extends Deserializers.Base {
        private final Map<String, ? extends JsonDeserializer> beanDeserializer = ImmutableMap.of((Object)DateTime.class.getName(), (Object)((Object)new DateTimeDeserializer()), (Object)JsonString.class.getName(), (Object)((Object)new JsonStringDeserializer()));

        public JsonDeserializer<?> findMapDeserializer(MapType type, DeserializationConfig config, DeserializerProvider provider, BeanDescription beanDesc, BeanProperty property, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
            if (type.getRawClass().equals(EnrichableMap.class)) {
                return EnrichedMapDeserializer.make(type, config, provider, property, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            return super.findMapDeserializer(type, config, provider, beanDesc, property, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }

        public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, DeserializerProvider provider, BeanDescription beanDesc, BeanProperty property, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
            if (type.getRawClass().equals(RestList.class)) {
                return new RestListDeserializer(this.findElementDeserializer(elementDeserializer, provider, config, type.getContentType(), property), type.getContentType());
            }
            return super.findCollectionDeserializer(type, config, provider, beanDesc, property, elementTypeDeserializer, elementDeserializer);
        }

        private JsonDeserializer findElementDeserializer(JsonDeserializer<?> elementDeserializer, DeserializerProvider provider, DeserializationConfig config, JavaType type, BeanProperty property) throws JsonMappingException {
            return provider.findValueDeserializer(config, type, property);
        }

        public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, DeserializerProvider provider, BeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
            return this.beanDeserializer.get(type.getRawClass().getName());
        }
    }
}

