/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.serialization.jackson2;

import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.reference.EnrichableMap;
import com.atlassian.confluence.api.serialization.jackson2.OffsetDateTimeDeserializer;
import com.atlassian.confluence.rest.serialization.jackson2.CollapsedSerializer;
import com.atlassian.confluence.rest.serialization.jackson2.ContentDeserializer;
import com.atlassian.confluence.rest.serialization.jackson2.ContentTypeSerializer;
import com.atlassian.confluence.rest.serialization.jackson2.CustomValueInstantiators;
import com.atlassian.confluence.rest.serialization.jackson2.DateTimeDeserializer;
import com.atlassian.confluence.rest.serialization.jackson2.DateTimeSerializer;
import com.atlassian.confluence.rest.serialization.jackson2.EnrichedMapDeserializer;
import com.atlassian.confluence.rest.serialization.jackson2.InstantSerializer;
import com.atlassian.confluence.rest.serialization.jackson2.JsonStringDeserializer;
import com.atlassian.confluence.rest.serialization.jackson2.JsonStringSerializer;
import com.atlassian.confluence.rest.serialization.jackson2.OffsetDateTimeSerializer;
import com.atlassian.confluence.rest.serialization.jackson2.OptionDeserializer;
import com.atlassian.confluence.rest.serialization.jackson2.OptionSerializer;
import com.atlassian.confluence.rest.serialization.jackson2.OptionalDeserializer;
import com.atlassian.confluence.rest.serialization.jackson2.OptionalSerializer;
import com.atlassian.confluence.rest.serialization.jackson2.PageResponseSerializer;
import com.atlassian.confluence.rest.serialization.jackson2.ReferenceSerializer;
import com.atlassian.confluence.rest.serialization.jackson2.RestEntitySerializer;
import com.atlassian.confluence.rest.serialization.jackson2.RestListDeserializer;
import com.atlassian.confluence.rest.serialization.jackson2.SpaceDeserializer;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.fugue.Option;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTime;

public class SerializerModule
extends Module {
    static final SerializerModule INSTANCE = new SerializerModule();

    public String getModuleName() {
        return "Custom Confluence Serializers";
    }

    public Version version() {
        return new Version(1, 0, 0, null);
    }

    public void setupModule(Module.SetupContext setupContext) {
        SimpleSerializers customSerializers = new SimpleSerializers();
        customSerializers.addSerializer((JsonSerializer)new OptionSerializer());
        customSerializers.addSerializer((JsonSerializer)new OptionalSerializer());
        customSerializers.addSerializer((JsonSerializer)new RestEntitySerializer());
        customSerializers.addSerializer((JsonSerializer)new DateTimeSerializer());
        customSerializers.addSerializer((JsonSerializer)OffsetDateTimeSerializer.serializeAsIso());
        customSerializers.addSerializer((JsonSerializer)new InstantSerializer());
        customSerializers.addSerializer((JsonSerializer)new JsonStringSerializer());
        customSerializers.addSerializer((JsonSerializer)new ContentTypeSerializer());
        customSerializers.addSerializer((JsonSerializer)new ReferenceSerializer());
        customSerializers.addSerializer((JsonSerializer)new CollapsedSerializer());
        customSerializers.addSerializer((JsonSerializer)new PageResponseSerializer());
        setupContext.addSerializers((Serializers)customSerializers);
        setupContext.addDeserializers((Deserializers)new ConfluenceJacksonDeserializers());
        setupContext.addBeanDeserializerModifier((BeanDeserializerModifier)new ConfluenceBeanDeserializerModifier());
        setupContext.addValueInstantiators((ValueInstantiators)new CustomValueInstantiators());
    }

    public Iterable<? extends Module> getDependencies() {
        return Collections.singletonList(new JavaTimeModule());
    }

    public static class ConfluenceJacksonDeserializers
    extends Deserializers.Base {
        private final Map<String, JsonDeserializer<?>> beanDeserializer = new LinkedHashMap();

        public ConfluenceJacksonDeserializers() {
            this.beanDeserializer.put(DateTime.class.getName(), new DateTimeDeserializer());
            this.beanDeserializer.put(OffsetDateTime.class.getName(), (JsonDeserializer<?>)new OffsetDateTimeDeserializer());
            this.beanDeserializer.put(JsonString.class.getName(), new JsonStringDeserializer());
        }

        public JsonDeserializer<?> findCollectionLikeDeserializer(CollectionLikeType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
            if (type.getRawClass().equals(Option.class)) {
                return new OptionDeserializer(elementDeserializer, (JavaType)type);
            }
            if (type.getRawClass().equals(Optional.class)) {
                return new OptionalDeserializer(elementDeserializer, (JavaType)type);
            }
            if (PageResponse.class.isAssignableFrom(type.getRawClass())) {
                return new RestListDeserializer(elementDeserializer, type.getContentType(), elementTypeDeserializer);
            }
            return super.findCollectionLikeDeserializer(type, config, beanDesc, elementTypeDeserializer, elementDeserializer);
        }

        public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
            if (PageResponse.class.isAssignableFrom(type.getRawClass())) {
                return new RestListDeserializer(elementDeserializer, type.getContentType(), elementTypeDeserializer);
            }
            return super.findCollectionDeserializer(type, config, beanDesc, elementTypeDeserializer, elementDeserializer);
        }

        public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
            JavaType containedType;
            if (type.getRawClass().equals(Option.class)) {
                JavaType containedType2 = type.containedType(0);
                return new OptionDeserializer(super.findBeanDeserializer(containedType2, config, config.introspect(containedType2)), containedType2);
            }
            if (type.getRawClass().equals(Optional.class)) {
                JavaType containedType3 = type.containedType(0);
                return new OptionalDeserializer(super.findBeanDeserializer(containedType3, config, config.introspect(containedType3)), containedType3);
            }
            if ((PageResponse.class.equals((Object)type.getRawClass()) || PageResponseImpl.class.equals((Object)type.getRawClass()) || RestList.class.equals((Object)type.getRawClass())) && (containedType = type.containedType(0)) != null) {
                return new RestListDeserializer(super.findBeanDeserializer(containedType, config, config.introspect(containedType)), containedType, (TypeDeserializer)containedType.getTypeHandler());
            }
            return this.beanDeserializer.get(type.getRawClass().getName());
        }
    }

    public static class ConfluenceBeanDeserializerModifier
    extends BeanDeserializerModifier {
        public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
            if (Content.class.equals((Object)beanDesc.getBeanClass())) {
                return new ContentDeserializer(deserializer);
            }
            if (Space.class.equals((Object)beanDesc.getBeanClass())) {
                return new SpaceDeserializer(deserializer);
            }
            return super.modifyDeserializer(config, beanDesc, deserializer);
        }

        public JsonDeserializer<?> modifyMapDeserializer(DeserializationConfig config, MapType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
            if (type.getRawClass().equals(EnrichableMap.class)) {
                return new EnrichedMapDeserializer((JavaType)type, beanDesc, (MapDeserializer)deserializer);
            }
            return super.modifyMapDeserializer(config, type, beanDesc, deserializer);
        }
    }
}

