/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.serialization.jackson2;

import com.atlassian.confluence.api.model.pagination.Cursor;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.pagination.CursorFactory;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestListDeserializer
extends ContainerDeserializerBase {
    private static final Logger log = LoggerFactory.getLogger(RestListDeserializer.class);
    private JsonDeserializer<?> contentDeserializer;
    private final JavaType contentType;
    private final TypeDeserializer elementTypeDeserializer;

    public RestListDeserializer(JsonDeserializer<?> contentDeserializer, JavaType contentType, TypeDeserializer elementTypeDeserializer) {
        super(contentType);
        this.contentDeserializer = contentDeserializer;
        this.elementTypeDeserializer = elementTypeDeserializer;
        this.contentType = Objects.requireNonNull(contentType);
    }

    public JavaType getContentType() {
        return this.contentType;
    }

    public JsonDeserializer<Object> getContentDeserializer() {
        return this.contentDeserializer;
    }

    public PageResponse deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        RestList list;
        DeserializedRestListData deserializedData = null;
        if (JsonToken.START_ARRAY.equals((Object)jsonParser.getCurrentToken())) {
            deserializedData = new DeserializedRestListData();
            deserializedData.resultList = this.deserializeArray(jsonParser, deserializationContext);
        } else if (JsonToken.START_OBJECT.equals((Object)jsonParser.getCurrentToken())) {
            deserializedData = this.deserializeObject(jsonParser, deserializationContext);
        }
        if (deserializedData == null || deserializedData.resultList == null) {
            return null;
        }
        if (deserializedData.limit == null) {
            deserializedData.limit = deserializedData.resultList.size();
        }
        if (deserializedData.requestCursor == null) {
            if (deserializedData.start == null) {
                deserializedData.start = 0;
            }
            list = RestList.newRestList((PageRequest)new SimplePageRequest(deserializedData.start.intValue(), deserializedData.limit.intValue())).results(deserializedData.resultList, deserializedData.hasMore).build();
        } else {
            list = RestList.newRestList((PageRequest)new SimplePageRequest(deserializedData.requestCursor, deserializedData.limit.intValue())).results(deserializedData.resultList, deserializedData.nextCursor, deserializedData.prevCursor, deserializedData.hasMore).build();
        }
        list.putProperties(deserializedData.properties);
        return list;
    }

    private List deserializeArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken token;
        ArrayList<Object> results = new ArrayList<Object>();
        while ((token = jsonParser.nextToken()) != JsonToken.END_ARRAY && token != null) {
            if (!token.equals((Object)JsonToken.START_OBJECT)) {
                throw new IllegalStateException();
            }
            results.add(this.deserializeNextElement(jsonParser, deserializationContext));
        }
        return Collections.unmodifiableList(results);
    }

    private Object deserializeNextElement(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this.contentDeserializer == null) {
            this.contentDeserializer = deserializationContext.findNonContextualValueDeserializer(this.contentType);
        }
        return this.elementTypeDeserializer == null ? this.contentDeserializer.deserialize(jsonParser, deserializationContext) : this.contentDeserializer.deserializeWithType(jsonParser, deserializationContext, this.elementTypeDeserializer);
    }

    private DeserializedRestListData deserializeObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        DeserializedRestListData deserializedData = new DeserializedRestListData();
        JsonToken token = jsonParser.getCurrentToken();
        int openObjectCount = 0;
        do {
            if (token == JsonToken.END_OBJECT) {
                --openObjectCount;
                continue;
            }
            if (token == JsonToken.START_OBJECT) {
                ++openObjectCount;
                continue;
            }
            if (token != JsonToken.FIELD_NAME || jsonParser.getCurrentName() == null) continue;
            log.debug("Start parsing field {0}", (Object)jsonParser.getCurrentName());
            String fieldName = jsonParser.getCurrentName().toLowerCase();
            if (openObjectCount == 1) {
                this.deserializeFirstLevelField(jsonParser, deserializationContext, deserializedData, fieldName);
                continue;
            }
            this.deserializeField(jsonParser, deserializationContext, deserializedData, fieldName);
        } while (openObjectCount != 0 && (token = jsonParser.nextToken()) != null);
        return deserializedData;
    }

    private void deserializeFirstLevelField(JsonParser jsonParser, DeserializationContext deserializationContext, DeserializedRestListData deserializedData, String fieldName) throws IOException {
        switch (fieldName) {
            case "results": 
            case "start": 
            case "limit": 
            case "hasmore": 
            case "cursor": 
            case "nextcursor": 
            case "prevcursor": {
                this.deserializePageResponseField(jsonParser, deserializationContext, deserializedData, fieldName);
                break;
            }
            case "cqlquery": 
            case "totalsize": 
            case "searchduration": 
            case "archivedresultcount": {
                this.deserializeSearchPageResponseField(jsonParser, deserializedData, fieldName);
                break;
            }
            default: {
                this.deserializeField(jsonParser, deserializationContext, deserializedData, fieldName);
            }
        }
    }

    private void deserializePageResponseField(JsonParser jsonParser, DeserializationContext deserializationContext, DeserializedRestListData deserializedData, String fieldName) throws IOException {
        JsonToken token = jsonParser.nextToken();
        switch (fieldName) {
            case "results": {
                if (!token.equals((Object)JsonToken.START_ARRAY)) {
                    throw new IllegalStateException();
                }
                deserializedData.resultList = this.deserializeArray(jsonParser, deserializationContext);
                break;
            }
            case "start": {
                deserializedData.start = jsonParser.getIntValue();
                break;
            }
            case "limit": {
                deserializedData.limit = jsonParser.getIntValue();
                break;
            }
            case "hasmore": {
                deserializedData.hasMore = jsonParser.getBooleanValue();
                break;
            }
            case "cursor": {
                deserializedData.requestCursor = this.deserializeCursor(jsonParser);
                break;
            }
            case "nextcursor": {
                deserializedData.nextCursor = this.deserializeCursor(jsonParser);
                break;
            }
            case "prevcursor": {
                deserializedData.prevCursor = this.deserializeCursor(jsonParser);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected PageResponse field %s", fieldName));
            }
        }
    }

    private void deserializeSearchPageResponseField(JsonParser jsonParser, DeserializedRestListData deserializedData, String fieldName) throws IOException {
        jsonParser.nextToken();
        switch (fieldName) {
            case "cqlquery": {
                deserializedData.properties.put("cqlQuery", jsonParser.getText());
                break;
            }
            case "totalsize": {
                deserializedData.properties.put("totalSize", jsonParser.getIntValue());
                break;
            }
            case "searchduration": {
                deserializedData.properties.put("searchDuration", jsonParser.getIntValue());
                break;
            }
            case "archivedresultcount": {
                deserializedData.properties.put("archivedResultCount", jsonParser.getIntValue());
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected SearchPageResponse field %s", fieldName));
            }
        }
    }

    private void deserializeField(JsonParser jsonParser, DeserializationContext deserializationContext, DeserializedRestListData deserializedData, String fieldName) throws IOException {
        switch (fieldName) {
            case "nodes": {
                JsonToken token = jsonParser.nextToken();
                if (!token.equals((Object)JsonToken.START_ARRAY)) {
                    throw new IllegalStateException();
                }
                deserializedData.resultList = this.deserializeArray(jsonParser, deserializationContext);
                break;
            }
            case "pageinfo": {
                jsonParser.nextToken();
                JsonNode pageInfo = (JsonNode)jsonParser.readValueAsTree();
                deserializedData.hasMore = pageInfo.get("hasNextPage").asBoolean();
                break;
            }
            case "next": {
                jsonParser.nextToken();
                deserializedData.hasMore = true;
                break;
            }
            default: {
                log.debug("Deserializer for field {0} not found", (Object)jsonParser.getCurrentName());
            }
        }
    }

    private Cursor deserializeCursor(JsonParser jsonParser) throws IOException {
        String stringCursor = jsonParser.getText();
        return CursorFactory.buildFrom((String)stringCursor);
    }

    private static class DeserializedRestListData {
        private Integer start;
        private Integer limit;
        private boolean hasMore;
        private Cursor requestCursor;
        private Cursor nextCursor;
        private Cursor prevCursor;
        private final Map<String, Object> properties = new HashMap<String, Object>();
        private List<Object> resultList;

        private DeserializedRestListData() {
        }
    }
}

